package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NamedClusterRoleBindingFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedClusterRoleBindingFluentAssert<S extends AbstractNamedClusterRoleBindingFluentAssert<S, A>, A extends NamedClusterRoleBindingFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedClusterRoleBindingFluentAssert}</code> to make assertions on actual NamedClusterRoleBindingFluent.
   * @param actual the NamedClusterRoleBindingFluent we want to make assertions on.
   */
  protected AbstractNamedClusterRoleBindingFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NamedClusterRoleBindingFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NamedClusterRoleBindingFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedClusterRoleBindingFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NamedClusterRoleBindingFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedClusterRoleBindingFluent's name is equal to the given one.
   * @param name the given name to compare the actual NamedClusterRoleBindingFluent's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedClusterRoleBindingFluent's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual NamedClusterRoleBindingFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedClusterRoleBindingFluent's roleBinding is equal to the given one.
   * @param roleBinding the given roleBinding to compare the actual NamedClusterRoleBindingFluent's roleBinding to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedClusterRoleBindingFluent's roleBinding is not equal to the given one.
   */
  public S hasRoleBinding(ClusterRoleBinding roleBinding) {
    // check that actual NamedClusterRoleBindingFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected roleBinding of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    ClusterRoleBinding actualRoleBinding = actual.getRoleBinding();
    if (!Objects.areEqual(actualRoleBinding, roleBinding)) {
      failWithMessage(assertjErrorMessage, actual, roleBinding, actualRoleBinding);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
