package io.fabric8.kubernetes.assertions.internal;

/**
 * Entry point for assertions of different data types. Each method in this class is a static factory for the
 * type-specific assertion objects.
 */
public class Assertions {

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AuthInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AuthInfoAssert assertThat(io.fabric8.kubernetes.api.model.AuthInfo actual) {
    return new io.fabric8.kubernetes.api.model.AuthInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AuthInfoBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AuthInfoBuilderAssert assertThat(io.fabric8.kubernetes.api.model.AuthInfoBuilder actual) {
    return new io.fabric8.kubernetes.api.model.AuthInfoBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AuthInfoFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AuthInfoFluentAssert assertThat(io.fabric8.kubernetes.api.model.AuthInfoFluent actual) {
    return new io.fabric8.kubernetes.api.model.AuthInfoFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.BaseKubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.BaseKubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.BaseKubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.BaseKubernetesListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.BaseKubernetesListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.BaseKubernetesListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.BaseKubernetesListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.BaseKubernetesListFluentAssert assertThat(io.fabric8.kubernetes.api.model.BaseKubernetesListFluent actual) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CapabilitiesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CapabilitiesAssert assertThat(io.fabric8.kubernetes.api.model.Capabilities actual) {
    return new io.fabric8.kubernetes.api.model.CapabilitiesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CapabilitiesBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CapabilitiesBuilderAssert assertThat(io.fabric8.kubernetes.api.model.CapabilitiesBuilder actual) {
    return new io.fabric8.kubernetes.api.model.CapabilitiesBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CapabilitiesFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CapabilitiesFluentAssert assertThat(io.fabric8.kubernetes.api.model.CapabilitiesFluent actual) {
    return new io.fabric8.kubernetes.api.model.CapabilitiesFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CephFSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CephFSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.CephFSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.CephFSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.CephFSVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.CephFSVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ClusterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ClusterAssert assertThat(io.fabric8.kubernetes.api.model.Cluster actual) {
    return new io.fabric8.kubernetes.api.model.ClusterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ClusterBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ClusterBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ClusterBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ClusterBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ClusterFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ClusterFluentAssert assertThat(io.fabric8.kubernetes.api.model.ClusterFluent actual) {
    return new io.fabric8.kubernetes.api.model.ClusterFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigAssert assertThat(io.fabric8.kubernetes.api.model.Config actual) {
    return new io.fabric8.kubernetes.api.model.ConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ConfigBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ConfigBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigFluentAssert assertThat(io.fabric8.kubernetes.api.model.ConfigFluent actual) {
    return new io.fabric8.kubernetes.api.model.ConfigFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerAssert assertThat(io.fabric8.kubernetes.api.model.Container actual) {
    return new io.fabric8.kubernetes.api.model.ContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerPortAssert assertThat(io.fabric8.kubernetes.api.model.ContainerPort actual) {
    return new io.fabric8.kubernetes.api.model.ContainerPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerPortBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerPortBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerPortBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerPortBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerPortFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerPortFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerPortFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerPortFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateAssert assertThat(io.fabric8.kubernetes.api.model.ContainerState actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunning actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunningBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunningFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminated actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaiting actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaitingFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatus actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContextAssert assertThat(io.fabric8.kubernetes.api.model.Context actual) {
    return new io.fabric8.kubernetes.api.model.ContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContextBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContextBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ContextBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ContextBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContextFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContextFluentAssert assertThat(io.fabric8.kubernetes.api.model.ContextFluent actual) {
    return new io.fabric8.kubernetes.api.model.ContextFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableAssert assertThat(io.fabric8.kubernetes.api.model.Doneable actual) {
    return new io.fabric8.kubernetes.api.model.DoneableAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableAWSElasticBlockStoreVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableAWSElasticBlockStoreVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableAWSElasticBlockStoreVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableAWSElasticBlockStoreVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableAuthInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableAuthInfoAssert assertThat(io.fabric8.kubernetes.api.model.DoneableAuthInfo actual) {
    return new io.fabric8.kubernetes.api.model.DoneableAuthInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableBaseKubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableBaseKubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableBaseKubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableBaseKubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableCapabilitiesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableCapabilitiesAssert assertThat(io.fabric8.kubernetes.api.model.DoneableCapabilities actual) {
    return new io.fabric8.kubernetes.api.model.DoneableCapabilitiesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableCephFSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableCephFSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableCephFSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableCephFSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableClusterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableClusterAssert assertThat(io.fabric8.kubernetes.api.model.DoneableCluster actual) {
    return new io.fabric8.kubernetes.api.model.DoneableClusterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableConfigAssert assertThat(io.fabric8.kubernetes.api.model.DoneableConfig actual) {
    return new io.fabric8.kubernetes.api.model.DoneableConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContainerAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContainer actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContainerPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContainerPortAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContainerPort actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContainerPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContainerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContainerStateAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContainerState actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContainerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContainerStateRunningAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContainerStateRunningAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContainerStateRunning actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContainerStateRunningAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContainerStateTerminatedAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContainerStateTerminatedAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContainerStateTerminated actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContainerStateTerminatedAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContainerStateWaitingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContainerStateWaitingAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContainerStateWaiting actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContainerStateWaitingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContainerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContainerStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContainerStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContainerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableContextAssert assertThat(io.fabric8.kubernetes.api.model.DoneableContext actual) {
    return new io.fabric8.kubernetes.api.model.DoneableContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEmptyDirVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEmptyDirVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEmptyDirVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEmptyDirVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEndpointAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEndpointAddressAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEndpointAddress actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEndpointAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEndpointPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEndpointPortAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEndpointPort actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEndpointPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEndpointSubsetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEndpointSubsetAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEndpointSubset actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEndpointSubsetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEndpointsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEndpointsAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEndpoints actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEndpointsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEndpointsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEndpointsListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEndpointsList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEndpointsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEnvVarAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEnvVar actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEnvVarSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEnvVarSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEnvVarSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEnvVarSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEventAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEvent actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEventListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEventListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEventList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEventListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableEventSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableEventSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableEventSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableEventSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableExecActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableExecActionAssert assertThat(io.fabric8.kubernetes.api.model.DoneableExecAction actual) {
    return new io.fabric8.kubernetes.api.model.DoneableExecActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableGCEPersistentDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableGCEPersistentDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableGCEPersistentDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableGCEPersistentDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableGitRepoVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableGitRepoVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableGitRepoVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableGitRepoVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableGlusterfsVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableGlusterfsVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableGlusterfsVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableGlusterfsVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableHTTPGetActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableHTTPGetActionAssert assertThat(io.fabric8.kubernetes.api.model.DoneableHTTPGetAction actual) {
    return new io.fabric8.kubernetes.api.model.DoneableHTTPGetActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableHandlerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableHandlerAssert assertThat(io.fabric8.kubernetes.api.model.DoneableHandler actual) {
    return new io.fabric8.kubernetes.api.model.DoneableHandlerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableHostPathVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableHostPathVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableHostPathVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableHostPathVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableISCSIVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableISCSIVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableISCSIVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableISCSIVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableIntOrStringAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableIntOrStringAssert assertThat(io.fabric8.kubernetes.api.model.DoneableIntOrString actual) {
    return new io.fabric8.kubernetes.api.model.DoneableIntOrStringAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableKubeSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableKubeSchemaAssert assertThat(io.fabric8.kubernetes.api.model.DoneableKubeSchema actual) {
    return new io.fabric8.kubernetes.api.model.DoneableKubeSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableKubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableKubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableKubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableKubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableLifecycleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableLifecycleAssert assertThat(io.fabric8.kubernetes.api.model.DoneableLifecycle actual) {
    return new io.fabric8.kubernetes.api.model.DoneableLifecycleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableListMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableListMetaAssert assertThat(io.fabric8.kubernetes.api.model.DoneableListMeta actual) {
    return new io.fabric8.kubernetes.api.model.DoneableListMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableLoadBalancerIngressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableLoadBalancerIngressAssert assertThat(io.fabric8.kubernetes.api.model.DoneableLoadBalancerIngress actual) {
    return new io.fabric8.kubernetes.api.model.DoneableLoadBalancerIngressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableLoadBalancerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableLoadBalancerStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneableLoadBalancerStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneableLoadBalancerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableLocalObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableLocalObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableLocalObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.DoneableLocalObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableMetadataFileAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableMetadataFileAssert assertThat(io.fabric8.kubernetes.api.model.DoneableMetadataFile actual) {
    return new io.fabric8.kubernetes.api.model.DoneableMetadataFileAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableMetadataVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableMetadataVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableMetadataVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableMetadataVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNFSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNFSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNFSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNFSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNamedAuthInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNamedAuthInfoAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNamedAuthInfo actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNamedAuthInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNamedClusterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNamedClusterAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNamedCluster actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNamedClusterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNamedContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNamedContextAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNamedContext actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNamedContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNamedExtensionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNamedExtensionAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNamedExtension actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNamedExtensionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNamespaceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNamespaceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNamespace actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNamespaceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNamespaceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNamespaceListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNamespaceList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNamespaceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNamespaceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNamespaceSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNamespaceSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNamespaceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNamespaceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNamespaceStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNamespaceStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNamespaceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNodeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNodeAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNode actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNodeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNodeAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNodeAddressAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNodeAddress actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNodeAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNodeConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNodeConditionAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNodeCondition actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNodeConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNodeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNodeListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNodeList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNodeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNodeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNodeSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNodeSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNodeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNodeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNodeStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNodeStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNodeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableNodeSystemInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableNodeSystemInfoAssert assertThat(io.fabric8.kubernetes.api.model.DoneableNodeSystemInfo actual) {
    return new io.fabric8.kubernetes.api.model.DoneableNodeSystemInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableObjectFieldSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableObjectFieldSelectorAssert assertThat(io.fabric8.kubernetes.api.model.DoneableObjectFieldSelector actual) {
    return new io.fabric8.kubernetes.api.model.DoneableObjectFieldSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableObjectMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableObjectMetaAssert assertThat(io.fabric8.kubernetes.api.model.DoneableObjectMeta actual) {
    return new io.fabric8.kubernetes.api.model.DoneableObjectMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.DoneableObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolume actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaim actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimListAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimList actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaimVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeListAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolumeList actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolumeSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePersistentVolumeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePersistentVolumeStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePersistentVolumeStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePersistentVolumeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePodAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePodAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePod actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePodAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePodConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePodConditionAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePodCondition actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePodConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePodListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePodListAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePodList actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePodListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePodSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePodSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePodSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePodSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePodStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePodStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePodStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePodStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePodTemplateSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePodTemplateSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePodTemplateSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePodTemplateSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneablePreferencesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneablePreferencesAssert assertThat(io.fabric8.kubernetes.api.model.DoneablePreferences actual) {
    return new io.fabric8.kubernetes.api.model.DoneablePreferencesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableProbeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableProbeAssert assertThat(io.fabric8.kubernetes.api.model.DoneableProbe actual) {
    return new io.fabric8.kubernetes.api.model.DoneableProbeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableQuantityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableQuantityAssert assertThat(io.fabric8.kubernetes.api.model.DoneableQuantity actual) {
    return new io.fabric8.kubernetes.api.model.DoneableQuantityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableRBDVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableRBDVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableRBDVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableRBDVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableReplicationControllerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableReplicationControllerAssert assertThat(io.fabric8.kubernetes.api.model.DoneableReplicationController actual) {
    return new io.fabric8.kubernetes.api.model.DoneableReplicationControllerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableReplicationControllerListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableReplicationControllerListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableReplicationControllerList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableReplicationControllerListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableReplicationControllerSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableReplicationControllerSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneableReplicationControllerSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneableReplicationControllerSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableReplicationControllerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableReplicationControllerStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneableReplicationControllerStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneableReplicationControllerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableResourceQuotaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableResourceQuotaAssert assertThat(io.fabric8.kubernetes.api.model.DoneableResourceQuota actual) {
    return new io.fabric8.kubernetes.api.model.DoneableResourceQuotaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableResourceQuotaListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableResourceQuotaListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableResourceQuotaList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableResourceQuotaListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableResourceQuotaSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableResourceQuotaSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneableResourceQuotaSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneableResourceQuotaSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableResourceQuotaStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableResourceQuotaStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneableResourceQuotaStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneableResourceQuotaStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableResourceRequirementsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableResourceRequirementsAssert assertThat(io.fabric8.kubernetes.api.model.DoneableResourceRequirements actual) {
    return new io.fabric8.kubernetes.api.model.DoneableResourceRequirementsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableRootPathsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableRootPathsAssert assertThat(io.fabric8.kubernetes.api.model.DoneableRootPaths actual) {
    return new io.fabric8.kubernetes.api.model.DoneableRootPathsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableRunAsUserStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableRunAsUserStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.DoneableRunAsUserStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.DoneableRunAsUserStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableSELinuxContextStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableSELinuxContextStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.DoneableSELinuxContextStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.DoneableSELinuxContextStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableSELinuxOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableSELinuxOptionsAssert assertThat(io.fabric8.kubernetes.api.model.DoneableSELinuxOptions actual) {
    return new io.fabric8.kubernetes.api.model.DoneableSELinuxOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableSecretAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableSecretAssert assertThat(io.fabric8.kubernetes.api.model.DoneableSecret actual) {
    return new io.fabric8.kubernetes.api.model.DoneableSecretAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableSecretListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableSecretListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableSecretList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableSecretListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableSecretVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableSecretVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableSecretVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DoneableSecretVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableSecurityContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableSecurityContextAssert assertThat(io.fabric8.kubernetes.api.model.DoneableSecurityContext actual) {
    return new io.fabric8.kubernetes.api.model.DoneableSecurityContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraintsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraintsAssert assertThat(io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraints actual) {
    return new io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraintsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraintsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraintsListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraintsList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraintsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableServiceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableServiceAssert assertThat(io.fabric8.kubernetes.api.model.DoneableService actual) {
    return new io.fabric8.kubernetes.api.model.DoneableServiceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableServiceAccountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableServiceAccountAssert assertThat(io.fabric8.kubernetes.api.model.DoneableServiceAccount actual) {
    return new io.fabric8.kubernetes.api.model.DoneableServiceAccountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableServiceAccountListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableServiceAccountListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableServiceAccountList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableServiceAccountListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableServiceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableServiceListAssert assertThat(io.fabric8.kubernetes.api.model.DoneableServiceList actual) {
    return new io.fabric8.kubernetes.api.model.DoneableServiceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableServicePortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableServicePortAssert assertThat(io.fabric8.kubernetes.api.model.DoneableServicePort actual) {
    return new io.fabric8.kubernetes.api.model.DoneableServicePortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableServiceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableServiceSpecAssert assertThat(io.fabric8.kubernetes.api.model.DoneableServiceSpec actual) {
    return new io.fabric8.kubernetes.api.model.DoneableServiceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableServiceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableServiceStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneableServiceStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneableServiceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableStatusAssert assertThat(io.fabric8.kubernetes.api.model.DoneableStatus actual) {
    return new io.fabric8.kubernetes.api.model.DoneableStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableStatusCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableStatusCauseAssert assertThat(io.fabric8.kubernetes.api.model.DoneableStatusCause actual) {
    return new io.fabric8.kubernetes.api.model.DoneableStatusCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableStatusDetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableStatusDetailsAssert assertThat(io.fabric8.kubernetes.api.model.DoneableStatusDetails actual) {
    return new io.fabric8.kubernetes.api.model.DoneableStatusDetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableTCPSocketActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableTCPSocketActionAssert assertThat(io.fabric8.kubernetes.api.model.DoneableTCPSocketAction actual) {
    return new io.fabric8.kubernetes.api.model.DoneableTCPSocketActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableVolumeAssert assertThat(io.fabric8.kubernetes.api.model.DoneableVolume actual) {
    return new io.fabric8.kubernetes.api.model.DoneableVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableVolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableVolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.DoneableVolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.DoneableVolumeMountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DoneableWatchEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DoneableWatchEventAssert assertThat(io.fabric8.kubernetes.api.model.DoneableWatchEvent actual) {
    return new io.fabric8.kubernetes.api.model.DoneableWatchEventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableAWSElasticBlockStoreVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableAWSElasticBlockStoreVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableAWSElasticBlockStoreVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableAWSElasticBlockStoreVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableAuthInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableAuthInfoAssert assertThat(io.fabric8.kubernetes.api.model.EditableAuthInfo actual) {
    return new io.fabric8.kubernetes.api.model.EditableAuthInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableBaseKubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableBaseKubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.EditableBaseKubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.EditableBaseKubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableCapabilitiesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableCapabilitiesAssert assertThat(io.fabric8.kubernetes.api.model.EditableCapabilities actual) {
    return new io.fabric8.kubernetes.api.model.EditableCapabilitiesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableCephFSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableCephFSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableCephFSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableCephFSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableClusterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableClusterAssert assertThat(io.fabric8.kubernetes.api.model.EditableCluster actual) {
    return new io.fabric8.kubernetes.api.model.EditableClusterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableConfigAssert assertThat(io.fabric8.kubernetes.api.model.EditableConfig actual) {
    return new io.fabric8.kubernetes.api.model.EditableConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContainerAssert assertThat(io.fabric8.kubernetes.api.model.EditableContainer actual) {
    return new io.fabric8.kubernetes.api.model.EditableContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContainerPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContainerPortAssert assertThat(io.fabric8.kubernetes.api.model.EditableContainerPort actual) {
    return new io.fabric8.kubernetes.api.model.EditableContainerPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContainerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContainerStateAssert assertThat(io.fabric8.kubernetes.api.model.EditableContainerState actual) {
    return new io.fabric8.kubernetes.api.model.EditableContainerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContainerStateRunningAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContainerStateRunningAssert assertThat(io.fabric8.kubernetes.api.model.EditableContainerStateRunning actual) {
    return new io.fabric8.kubernetes.api.model.EditableContainerStateRunningAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContainerStateTerminatedAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContainerStateTerminatedAssert assertThat(io.fabric8.kubernetes.api.model.EditableContainerStateTerminated actual) {
    return new io.fabric8.kubernetes.api.model.EditableContainerStateTerminatedAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContainerStateWaitingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContainerStateWaitingAssert assertThat(io.fabric8.kubernetes.api.model.EditableContainerStateWaiting actual) {
    return new io.fabric8.kubernetes.api.model.EditableContainerStateWaitingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContainerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContainerStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditableContainerStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditableContainerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableContextAssert assertThat(io.fabric8.kubernetes.api.model.EditableContext actual) {
    return new io.fabric8.kubernetes.api.model.EditableContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEmptyDirVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEmptyDirVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableEmptyDirVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableEmptyDirVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEndpointAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEndpointAddressAssert assertThat(io.fabric8.kubernetes.api.model.EditableEndpointAddress actual) {
    return new io.fabric8.kubernetes.api.model.EditableEndpointAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEndpointPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEndpointPortAssert assertThat(io.fabric8.kubernetes.api.model.EditableEndpointPort actual) {
    return new io.fabric8.kubernetes.api.model.EditableEndpointPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEndpointSubsetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEndpointSubsetAssert assertThat(io.fabric8.kubernetes.api.model.EditableEndpointSubset actual) {
    return new io.fabric8.kubernetes.api.model.EditableEndpointSubsetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEndpointsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEndpointsAssert assertThat(io.fabric8.kubernetes.api.model.EditableEndpoints actual) {
    return new io.fabric8.kubernetes.api.model.EditableEndpointsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEndpointsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEndpointsListAssert assertThat(io.fabric8.kubernetes.api.model.EditableEndpointsList actual) {
    return new io.fabric8.kubernetes.api.model.EditableEndpointsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEnvVarAssert assertThat(io.fabric8.kubernetes.api.model.EditableEnvVar actual) {
    return new io.fabric8.kubernetes.api.model.EditableEnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEnvVarSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEnvVarSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableEnvVarSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableEnvVarSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEventAssert assertThat(io.fabric8.kubernetes.api.model.EditableEvent actual) {
    return new io.fabric8.kubernetes.api.model.EditableEventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEventListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEventListAssert assertThat(io.fabric8.kubernetes.api.model.EditableEventList actual) {
    return new io.fabric8.kubernetes.api.model.EditableEventListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableEventSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableEventSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableEventSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableEventSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableExecActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableExecActionAssert assertThat(io.fabric8.kubernetes.api.model.EditableExecAction actual) {
    return new io.fabric8.kubernetes.api.model.EditableExecActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableGCEPersistentDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableGCEPersistentDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableGCEPersistentDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableGCEPersistentDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableGitRepoVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableGitRepoVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableGitRepoVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableGitRepoVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableGlusterfsVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableGlusterfsVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableGlusterfsVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableGlusterfsVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableHTTPGetActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableHTTPGetActionAssert assertThat(io.fabric8.kubernetes.api.model.EditableHTTPGetAction actual) {
    return new io.fabric8.kubernetes.api.model.EditableHTTPGetActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableHandlerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableHandlerAssert assertThat(io.fabric8.kubernetes.api.model.EditableHandler actual) {
    return new io.fabric8.kubernetes.api.model.EditableHandlerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableHostPathVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableHostPathVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableHostPathVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableHostPathVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableISCSIVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableISCSIVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableISCSIVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableISCSIVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableIntOrStringAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableIntOrStringAssert assertThat(io.fabric8.kubernetes.api.model.EditableIntOrString actual) {
    return new io.fabric8.kubernetes.api.model.EditableIntOrStringAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableKubeSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableKubeSchemaAssert assertThat(io.fabric8.kubernetes.api.model.EditableKubeSchema actual) {
    return new io.fabric8.kubernetes.api.model.EditableKubeSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableKubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableKubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.EditableKubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.EditableKubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableLifecycleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableLifecycleAssert assertThat(io.fabric8.kubernetes.api.model.EditableLifecycle actual) {
    return new io.fabric8.kubernetes.api.model.EditableLifecycleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableListMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableListMetaAssert assertThat(io.fabric8.kubernetes.api.model.EditableListMeta actual) {
    return new io.fabric8.kubernetes.api.model.EditableListMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableLoadBalancerIngressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableLoadBalancerIngressAssert assertThat(io.fabric8.kubernetes.api.model.EditableLoadBalancerIngress actual) {
    return new io.fabric8.kubernetes.api.model.EditableLoadBalancerIngressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableLoadBalancerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableLoadBalancerStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditableLoadBalancerStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditableLoadBalancerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableLocalObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableLocalObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.EditableLocalObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.EditableLocalObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableMetadataFileAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableMetadataFileAssert assertThat(io.fabric8.kubernetes.api.model.EditableMetadataFile actual) {
    return new io.fabric8.kubernetes.api.model.EditableMetadataFileAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableMetadataVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableMetadataVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableMetadataVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableMetadataVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNFSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNFSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableNFSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableNFSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNamedAuthInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNamedAuthInfoAssert assertThat(io.fabric8.kubernetes.api.model.EditableNamedAuthInfo actual) {
    return new io.fabric8.kubernetes.api.model.EditableNamedAuthInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNamedClusterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNamedClusterAssert assertThat(io.fabric8.kubernetes.api.model.EditableNamedCluster actual) {
    return new io.fabric8.kubernetes.api.model.EditableNamedClusterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNamedContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNamedContextAssert assertThat(io.fabric8.kubernetes.api.model.EditableNamedContext actual) {
    return new io.fabric8.kubernetes.api.model.EditableNamedContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNamedExtensionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNamedExtensionAssert assertThat(io.fabric8.kubernetes.api.model.EditableNamedExtension actual) {
    return new io.fabric8.kubernetes.api.model.EditableNamedExtensionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNamespaceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNamespaceAssert assertThat(io.fabric8.kubernetes.api.model.EditableNamespace actual) {
    return new io.fabric8.kubernetes.api.model.EditableNamespaceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNamespaceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNamespaceListAssert assertThat(io.fabric8.kubernetes.api.model.EditableNamespaceList actual) {
    return new io.fabric8.kubernetes.api.model.EditableNamespaceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNamespaceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNamespaceSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditableNamespaceSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditableNamespaceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNamespaceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNamespaceStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditableNamespaceStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditableNamespaceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNodeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNodeAssert assertThat(io.fabric8.kubernetes.api.model.EditableNode actual) {
    return new io.fabric8.kubernetes.api.model.EditableNodeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNodeAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNodeAddressAssert assertThat(io.fabric8.kubernetes.api.model.EditableNodeAddress actual) {
    return new io.fabric8.kubernetes.api.model.EditableNodeAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNodeConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNodeConditionAssert assertThat(io.fabric8.kubernetes.api.model.EditableNodeCondition actual) {
    return new io.fabric8.kubernetes.api.model.EditableNodeConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNodeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNodeListAssert assertThat(io.fabric8.kubernetes.api.model.EditableNodeList actual) {
    return new io.fabric8.kubernetes.api.model.EditableNodeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNodeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNodeSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditableNodeSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditableNodeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNodeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNodeStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditableNodeStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditableNodeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableNodeSystemInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableNodeSystemInfoAssert assertThat(io.fabric8.kubernetes.api.model.EditableNodeSystemInfo actual) {
    return new io.fabric8.kubernetes.api.model.EditableNodeSystemInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableObjectFieldSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableObjectFieldSelectorAssert assertThat(io.fabric8.kubernetes.api.model.EditableObjectFieldSelector actual) {
    return new io.fabric8.kubernetes.api.model.EditableObjectFieldSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableObjectMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableObjectMetaAssert assertThat(io.fabric8.kubernetes.api.model.EditableObjectMeta actual) {
    return new io.fabric8.kubernetes.api.model.EditableObjectMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.EditableObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.EditableObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolume actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaim actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimListAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimList actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeClaimVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeListAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolumeList actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolumeSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePersistentVolumeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePersistentVolumeStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditablePersistentVolumeStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditablePersistentVolumeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePodAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePodAssert assertThat(io.fabric8.kubernetes.api.model.EditablePod actual) {
    return new io.fabric8.kubernetes.api.model.EditablePodAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePodConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePodConditionAssert assertThat(io.fabric8.kubernetes.api.model.EditablePodCondition actual) {
    return new io.fabric8.kubernetes.api.model.EditablePodConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePodListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePodListAssert assertThat(io.fabric8.kubernetes.api.model.EditablePodList actual) {
    return new io.fabric8.kubernetes.api.model.EditablePodListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePodSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePodSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditablePodSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditablePodSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePodStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePodStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditablePodStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditablePodStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePodTemplateSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePodTemplateSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditablePodTemplateSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditablePodTemplateSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditablePreferencesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditablePreferencesAssert assertThat(io.fabric8.kubernetes.api.model.EditablePreferences actual) {
    return new io.fabric8.kubernetes.api.model.EditablePreferencesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableProbeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableProbeAssert assertThat(io.fabric8.kubernetes.api.model.EditableProbe actual) {
    return new io.fabric8.kubernetes.api.model.EditableProbeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableQuantityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableQuantityAssert assertThat(io.fabric8.kubernetes.api.model.EditableQuantity actual) {
    return new io.fabric8.kubernetes.api.model.EditableQuantityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableRBDVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableRBDVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableRBDVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableRBDVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableReplicationControllerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableReplicationControllerAssert assertThat(io.fabric8.kubernetes.api.model.EditableReplicationController actual) {
    return new io.fabric8.kubernetes.api.model.EditableReplicationControllerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableReplicationControllerListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableReplicationControllerListAssert assertThat(io.fabric8.kubernetes.api.model.EditableReplicationControllerList actual) {
    return new io.fabric8.kubernetes.api.model.EditableReplicationControllerListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableReplicationControllerSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableReplicationControllerSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditableReplicationControllerSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditableReplicationControllerSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableReplicationControllerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableReplicationControllerStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditableReplicationControllerStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditableReplicationControllerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableResourceQuotaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableResourceQuotaAssert assertThat(io.fabric8.kubernetes.api.model.EditableResourceQuota actual) {
    return new io.fabric8.kubernetes.api.model.EditableResourceQuotaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableResourceQuotaListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableResourceQuotaListAssert assertThat(io.fabric8.kubernetes.api.model.EditableResourceQuotaList actual) {
    return new io.fabric8.kubernetes.api.model.EditableResourceQuotaListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableResourceQuotaSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableResourceQuotaSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditableResourceQuotaSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditableResourceQuotaSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableResourceQuotaStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableResourceQuotaStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditableResourceQuotaStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditableResourceQuotaStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableResourceRequirementsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableResourceRequirementsAssert assertThat(io.fabric8.kubernetes.api.model.EditableResourceRequirements actual) {
    return new io.fabric8.kubernetes.api.model.EditableResourceRequirementsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableRootPathsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableRootPathsAssert assertThat(io.fabric8.kubernetes.api.model.EditableRootPaths actual) {
    return new io.fabric8.kubernetes.api.model.EditableRootPathsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableRunAsUserStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableRunAsUserStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.EditableRunAsUserStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.EditableRunAsUserStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableSELinuxContextStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableSELinuxContextStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.EditableSELinuxContextStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.EditableSELinuxContextStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableSELinuxOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableSELinuxOptionsAssert assertThat(io.fabric8.kubernetes.api.model.EditableSELinuxOptions actual) {
    return new io.fabric8.kubernetes.api.model.EditableSELinuxOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableSecretAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableSecretAssert assertThat(io.fabric8.kubernetes.api.model.EditableSecret actual) {
    return new io.fabric8.kubernetes.api.model.EditableSecretAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableSecretListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableSecretListAssert assertThat(io.fabric8.kubernetes.api.model.EditableSecretList actual) {
    return new io.fabric8.kubernetes.api.model.EditableSecretListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableSecretVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableSecretVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EditableSecretVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EditableSecretVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableSecurityContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableSecurityContextAssert assertThat(io.fabric8.kubernetes.api.model.EditableSecurityContext actual) {
    return new io.fabric8.kubernetes.api.model.EditableSecurityContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableSecurityContextConstraintsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableSecurityContextConstraintsAssert assertThat(io.fabric8.kubernetes.api.model.EditableSecurityContextConstraints actual) {
    return new io.fabric8.kubernetes.api.model.EditableSecurityContextConstraintsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableSecurityContextConstraintsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableSecurityContextConstraintsListAssert assertThat(io.fabric8.kubernetes.api.model.EditableSecurityContextConstraintsList actual) {
    return new io.fabric8.kubernetes.api.model.EditableSecurityContextConstraintsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableServiceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableServiceAssert assertThat(io.fabric8.kubernetes.api.model.EditableService actual) {
    return new io.fabric8.kubernetes.api.model.EditableServiceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableServiceAccountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableServiceAccountAssert assertThat(io.fabric8.kubernetes.api.model.EditableServiceAccount actual) {
    return new io.fabric8.kubernetes.api.model.EditableServiceAccountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableServiceAccountListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableServiceAccountListAssert assertThat(io.fabric8.kubernetes.api.model.EditableServiceAccountList actual) {
    return new io.fabric8.kubernetes.api.model.EditableServiceAccountListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableServiceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableServiceListAssert assertThat(io.fabric8.kubernetes.api.model.EditableServiceList actual) {
    return new io.fabric8.kubernetes.api.model.EditableServiceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableServicePortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableServicePortAssert assertThat(io.fabric8.kubernetes.api.model.EditableServicePort actual) {
    return new io.fabric8.kubernetes.api.model.EditableServicePortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableServiceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableServiceSpecAssert assertThat(io.fabric8.kubernetes.api.model.EditableServiceSpec actual) {
    return new io.fabric8.kubernetes.api.model.EditableServiceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableServiceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableServiceStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditableServiceStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditableServiceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableStatusAssert assertThat(io.fabric8.kubernetes.api.model.EditableStatus actual) {
    return new io.fabric8.kubernetes.api.model.EditableStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableStatusCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableStatusCauseAssert assertThat(io.fabric8.kubernetes.api.model.EditableStatusCause actual) {
    return new io.fabric8.kubernetes.api.model.EditableStatusCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableStatusDetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableStatusDetailsAssert assertThat(io.fabric8.kubernetes.api.model.EditableStatusDetails actual) {
    return new io.fabric8.kubernetes.api.model.EditableStatusDetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableTCPSocketActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableTCPSocketActionAssert assertThat(io.fabric8.kubernetes.api.model.EditableTCPSocketAction actual) {
    return new io.fabric8.kubernetes.api.model.EditableTCPSocketActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableVolumeAssert assertThat(io.fabric8.kubernetes.api.model.EditableVolume actual) {
    return new io.fabric8.kubernetes.api.model.EditableVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableVolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableVolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.EditableVolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.EditableVolumeMountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EditableWatchEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EditableWatchEventAssert assertThat(io.fabric8.kubernetes.api.model.EditableWatchEvent actual) {
    return new io.fabric8.kubernetes.api.model.EditableWatchEventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDirVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointAddressAssert assertThat(io.fabric8.kubernetes.api.model.EndpointAddress actual) {
    return new io.fabric8.kubernetes.api.model.EndpointAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointAddressBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointAddressBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointAddressBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointAddressBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointAddressFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointAddressFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointAddressFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointAddressFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointPortAssert assertThat(io.fabric8.kubernetes.api.model.EndpointPort actual) {
    return new io.fabric8.kubernetes.api.model.EndpointPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointPortBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointPortBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointPortBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointPortBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointPortFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointPortFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointPortFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointPortFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointSubsetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointSubsetAssert assertThat(io.fabric8.kubernetes.api.model.EndpointSubset actual) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointSubsetBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointSubsetBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointSubsetBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointSubsetFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointSubsetFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointSubsetFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsAssert assertThat(io.fabric8.kubernetes.api.model.Endpoints actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsList actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListFluentAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsListFluent actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarAssert assertThat(io.fabric8.kubernetes.api.model.EnvVar actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarFluentAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarFluent actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarSourceAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarSource actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventAssert assertThat(io.fabric8.kubernetes.api.model.Event actual) {
    return new io.fabric8.kubernetes.api.model.EventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EventBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EventBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventFluentAssert assertThat(io.fabric8.kubernetes.api.model.EventFluent actual) {
    return new io.fabric8.kubernetes.api.model.EventFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventListAssert assertThat(io.fabric8.kubernetes.api.model.EventList actual) {
    return new io.fabric8.kubernetes.api.model.EventListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EventListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EventListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventListFluentAssert assertThat(io.fabric8.kubernetes.api.model.EventListFluent actual) {
    return new io.fabric8.kubernetes.api.model.EventListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventSourceAssert assertThat(io.fabric8.kubernetes.api.model.EventSource actual) {
    return new io.fabric8.kubernetes.api.model.EventSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.EventSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.EventSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.EventSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.EventSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionAssert assertThat(io.fabric8.kubernetes.api.model.ExecAction actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ExecActionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionFluentAssert assertThat(io.fabric8.kubernetes.api.model.ExecActionFluent actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GitRepoVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GlusterfsVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetAction actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetActionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionFluentAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetActionFluent actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerAssert assertThat(io.fabric8.kubernetes.api.model.Handler actual) {
    return new io.fabric8.kubernetes.api.model.HandlerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerBuilderAssert assertThat(io.fabric8.kubernetes.api.model.HandlerBuilder actual) {
    return new io.fabric8.kubernetes.api.model.HandlerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerFluentAssert assertThat(io.fabric8.kubernetes.api.model.HandlerFluent actual) {
    return new io.fabric8.kubernetes.api.model.HandlerFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HasMetadataAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HasMetadataAssert assertThat(io.fabric8.kubernetes.api.model.HasMetadata actual) {
    return new io.fabric8.kubernetes.api.model.HasMetadataAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.HostPathVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.HostPathVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.ISCSIVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.IntOrStringAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.IntOrStringAssert assertThat(io.fabric8.kubernetes.api.model.IntOrString actual) {
    return new io.fabric8.kubernetes.api.model.IntOrStringAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.IntOrStringBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.IntOrStringBuilderAssert assertThat(io.fabric8.kubernetes.api.model.IntOrStringBuilder actual) {
    return new io.fabric8.kubernetes.api.model.IntOrStringBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.IntOrStringFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.IntOrStringFluentAssert assertThat(io.fabric8.kubernetes.api.model.IntOrStringFluent actual) {
    return new io.fabric8.kubernetes.api.model.IntOrStringFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchema actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaBuilderAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchemaBuilder actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaFluentAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchemaFluent actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesKindAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesKindAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesKind actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesKindAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListFluentAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesListFluent actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesResourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesResourceAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesResource actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesResourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesResourceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesResourceListAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesResourceList actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesResourceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleAssert assertThat(io.fabric8.kubernetes.api.model.Lifecycle actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleBuilderAssert assertThat(io.fabric8.kubernetes.api.model.LifecycleBuilder actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleFluentAssert assertThat(io.fabric8.kubernetes.api.model.LifecycleFluent actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ListMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ListMetaAssert assertThat(io.fabric8.kubernetes.api.model.ListMeta actual) {
    return new io.fabric8.kubernetes.api.model.ListMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ListMetaBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ListMetaBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ListMetaBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ListMetaBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ListMetaFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ListMetaFluentAssert assertThat(io.fabric8.kubernetes.api.model.ListMetaFluent actual) {
    return new io.fabric8.kubernetes.api.model.ListMetaFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert assertThat(io.fabric8.kubernetes.api.model.LoadBalancerIngress actual) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilderAssert assertThat(io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilder actual) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerIngressBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LoadBalancerIngressFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LoadBalancerIngressFluentAssert assertThat(io.fabric8.kubernetes.api.model.LoadBalancerIngressFluent actual) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerIngressFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert assertThat(io.fabric8.kubernetes.api.model.LoadBalancerStatus actual) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LoadBalancerStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LoadBalancerStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.LoadBalancerStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.LocalObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentAssert assertThat(io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent actual) {
    return new io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MetadataFileAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MetadataFileAssert assertThat(io.fabric8.kubernetes.api.model.MetadataFile actual) {
    return new io.fabric8.kubernetes.api.model.MetadataFileAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MetadataFileBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MetadataFileBuilderAssert assertThat(io.fabric8.kubernetes.api.model.MetadataFileBuilder actual) {
    return new io.fabric8.kubernetes.api.model.MetadataFileBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MetadataFileFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MetadataFileFluentAssert assertThat(io.fabric8.kubernetes.api.model.MetadataFileFluent actual) {
    return new io.fabric8.kubernetes.api.model.MetadataFileFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MetadataVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MetadataVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.MetadataVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.MetadataVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MetadataVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MetadataVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.MetadataVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.MetadataVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.MetadataVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.MetadataVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.MetadataVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.MetadataVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.NFSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NFSVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.NFSVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.NFSVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedAuthInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedAuthInfoAssert assertThat(io.fabric8.kubernetes.api.model.NamedAuthInfo actual) {
    return new io.fabric8.kubernetes.api.model.NamedAuthInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedAuthInfoBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedAuthInfoBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamedAuthInfoBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamedAuthInfoBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedAuthInfoFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedAuthInfoFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamedAuthInfoFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamedAuthInfoFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedClusterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedClusterAssert assertThat(io.fabric8.kubernetes.api.model.NamedCluster actual) {
    return new io.fabric8.kubernetes.api.model.NamedClusterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedClusterBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedClusterBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamedClusterBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamedClusterBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedClusterFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedClusterFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamedClusterFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamedClusterFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedContextAssert assertThat(io.fabric8.kubernetes.api.model.NamedContext actual) {
    return new io.fabric8.kubernetes.api.model.NamedContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedContextBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedContextBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamedContextBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamedContextBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedContextFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedContextFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamedContextFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamedContextFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedExtensionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedExtensionAssert assertThat(io.fabric8.kubernetes.api.model.NamedExtension actual) {
    return new io.fabric8.kubernetes.api.model.NamedExtensionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedExtensionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedExtensionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamedExtensionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamedExtensionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedExtensionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedExtensionFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamedExtensionFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamedExtensionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceAssert assertThat(io.fabric8.kubernetes.api.model.Namespace actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceListAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceList actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceListFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceListFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceSpecAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceSpec actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceStatusAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceStatus actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAssert assertThat(io.fabric8.kubernetes.api.model.Node actual) {
    return new io.fabric8.kubernetes.api.model.NodeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAddressAssert assertThat(io.fabric8.kubernetes.api.model.NodeAddress actual) {
    return new io.fabric8.kubernetes.api.model.NodeAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAddressBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAddressBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeAddressBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeAddressBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAddressFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAddressFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeAddressFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeAddressFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionAssert assertThat(io.fabric8.kubernetes.api.model.NodeCondition actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeConditionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeConditionFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeListAssert assertThat(io.fabric8.kubernetes.api.model.NodeList actual) {
    return new io.fabric8.kubernetes.api.model.NodeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeListFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeListFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSpecAssert assertThat(io.fabric8.kubernetes.api.model.NodeSpec actual) {
    return new io.fabric8.kubernetes.api.model.NodeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatus actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSystemInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSystemInfoAssert assertThat(io.fabric8.kubernetes.api.model.NodeSystemInfo actual) {
    return new io.fabric8.kubernetes.api.model.NodeSystemInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSystemInfoBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSystemInfoBuilderAssert assertThat(io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder actual) {
    return new io.fabric8.kubernetes.api.model.NodeSystemInfoBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSystemInfoFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSystemInfoFluentAssert assertThat(io.fabric8.kubernetes.api.model.NodeSystemInfoFluent actual) {
    return new io.fabric8.kubernetes.api.model.NodeSystemInfoFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert assertThat(io.fabric8.kubernetes.api.model.ObjectFieldSelector actual) {
    return new io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ObjectFieldSelectorBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluentAssert assertThat(io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluent actual) {
    return new io.fabric8.kubernetes.api.model.ObjectFieldSelectorFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectMetaAssert assertThat(io.fabric8.kubernetes.api.model.ObjectMeta actual) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectMetaBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectMetaBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ObjectMetaBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectMetaFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectMetaFluentAssert assertThat(io.fabric8.kubernetes.api.model.ObjectMetaFluent actual) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.ObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.ObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectReferenceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectReferenceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ObjectReferenceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ObjectReferenceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectReferenceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectReferenceFluentAssert assertThat(io.fabric8.kubernetes.api.model.ObjectReferenceFluent actual) {
    return new io.fabric8.kubernetes.api.model.ObjectReferenceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolume actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaim actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimListAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimList actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimListFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimListFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeListAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeList actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeListFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeListFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeSpecAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeSpec actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeStatusAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeStatus actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodAssert assertThat(io.fabric8.kubernetes.api.model.Pod actual) {
    return new io.fabric8.kubernetes.api.model.PodAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodConditionAssert assertThat(io.fabric8.kubernetes.api.model.PodCondition actual) {
    return new io.fabric8.kubernetes.api.model.PodConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodConditionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodConditionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodConditionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodConditionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodConditionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodConditionFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodConditionFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodConditionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListAssert assertThat(io.fabric8.kubernetes.api.model.PodList actual) {
    return new io.fabric8.kubernetes.api.model.PodListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodListFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodSpecAssert assertThat(io.fabric8.kubernetes.api.model.PodSpec actual) {
    return new io.fabric8.kubernetes.api.model.PodSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStatusAssert assertThat(io.fabric8.kubernetes.api.model.PodStatus actual) {
    return new io.fabric8.kubernetes.api.model.PodStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateSpecAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateSpec actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PreferencesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PreferencesAssert assertThat(io.fabric8.kubernetes.api.model.Preferences actual) {
    return new io.fabric8.kubernetes.api.model.PreferencesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PreferencesBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PreferencesBuilderAssert assertThat(io.fabric8.kubernetes.api.model.PreferencesBuilder actual) {
    return new io.fabric8.kubernetes.api.model.PreferencesBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PreferencesFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PreferencesFluentAssert assertThat(io.fabric8.kubernetes.api.model.PreferencesFluent actual) {
    return new io.fabric8.kubernetes.api.model.PreferencesFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ProbeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ProbeAssert assertThat(io.fabric8.kubernetes.api.model.Probe actual) {
    return new io.fabric8.kubernetes.api.model.ProbeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ProbeBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ProbeBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ProbeBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ProbeBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ProbeFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ProbeFluentAssert assertThat(io.fabric8.kubernetes.api.model.ProbeFluent actual) {
    return new io.fabric8.kubernetes.api.model.ProbeFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.QuantityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.QuantityAssert assertThat(io.fabric8.kubernetes.api.model.Quantity actual) {
    return new io.fabric8.kubernetes.api.model.QuantityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.QuantityBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.QuantityBuilderAssert assertThat(io.fabric8.kubernetes.api.model.QuantityBuilder actual) {
    return new io.fabric8.kubernetes.api.model.QuantityBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.QuantityFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.QuantityFluentAssert assertThat(io.fabric8.kubernetes.api.model.QuantityFluent actual) {
    return new io.fabric8.kubernetes.api.model.QuantityFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.RBDVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.RBDVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RBDVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RBDVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.RBDVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.RBDVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationController actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerList actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerListFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerSpec actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerStatus actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuota actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaFluentAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaFluent actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaListAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaList actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaListFluentAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaListFluent actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaSpecAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaSpec actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaStatusAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaStatus actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceRequirementsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceRequirementsAssert assertThat(io.fabric8.kubernetes.api.model.ResourceRequirements actual) {
    return new io.fabric8.kubernetes.api.model.ResourceRequirementsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceRequirementsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceRequirementsBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ResourceRequirementsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceRequirementsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceRequirementsFluentAssert assertThat(io.fabric8.kubernetes.api.model.ResourceRequirementsFluent actual) {
    return new io.fabric8.kubernetes.api.model.ResourceRequirementsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RootPathsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RootPathsAssert assertThat(io.fabric8.kubernetes.api.model.RootPaths actual) {
    return new io.fabric8.kubernetes.api.model.RootPathsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RootPathsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RootPathsBuilderAssert assertThat(io.fabric8.kubernetes.api.model.RootPathsBuilder actual) {
    return new io.fabric8.kubernetes.api.model.RootPathsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RootPathsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RootPathsFluentAssert assertThat(io.fabric8.kubernetes.api.model.RootPathsFluent actual) {
    return new io.fabric8.kubernetes.api.model.RootPathsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.RunAsUserStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsBuilderAssert assertThat(io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsBuilder actual) {
    return new io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsFluentAssert assertThat(io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsFluent actual) {
    return new io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsFluentAssert assertThat(io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsFluent actual) {
    return new io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SELinuxOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SELinuxOptionsAssert assertThat(io.fabric8.kubernetes.api.model.SELinuxOptions actual) {
    return new io.fabric8.kubernetes.api.model.SELinuxOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SELinuxOptionsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SELinuxOptionsBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SELinuxOptionsBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SELinuxOptionsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SELinuxOptionsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SELinuxOptionsFluentAssert assertThat(io.fabric8.kubernetes.api.model.SELinuxOptionsFluent actual) {
    return new io.fabric8.kubernetes.api.model.SELinuxOptionsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretAssert assertThat(io.fabric8.kubernetes.api.model.Secret actual) {
    return new io.fabric8.kubernetes.api.model.SecretAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SecretBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SecretBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretFluentAssert assertThat(io.fabric8.kubernetes.api.model.SecretFluent actual) {
    return new io.fabric8.kubernetes.api.model.SecretFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretListAssert assertThat(io.fabric8.kubernetes.api.model.SecretList actual) {
    return new io.fabric8.kubernetes.api.model.SecretListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SecretListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SecretListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretListFluentAssert assertThat(io.fabric8.kubernetes.api.model.SecretListFluent actual) {
    return new io.fabric8.kubernetes.api.model.SecretListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.SecretVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretVolumeSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretVolumeSourceFluentAssert assertThat(io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent actual) {
    return new io.fabric8.kubernetes.api.model.SecretVolumeSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContext actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContextBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextConstraintsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextConstraintsAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContextConstraints actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextConstraintsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextConstraintsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextConstraintsBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContextConstraintsBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextConstraintsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluentAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluent actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextConstraintsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextConstraintsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextConstraintsListAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContextConstraintsList actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextConstraintsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextConstraintsListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextConstraintsListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContextConstraintsListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextConstraintsListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextConstraintsListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextConstraintsListFluentAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContextConstraintsListFluent actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextConstraintsListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextFluentAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContextFluent actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAssert assertThat(io.fabric8.kubernetes.api.model.Service actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccount actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountListAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountList actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountListFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountListFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListAssert assertThat(io.fabric8.kubernetes.api.model.ServiceList actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceListBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceListFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServicePortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServicePortAssert assertThat(io.fabric8.kubernetes.api.model.ServicePort actual) {
    return new io.fabric8.kubernetes.api.model.ServicePortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServicePortBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServicePortBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServicePortBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServicePortBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServicePortFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServicePortFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServicePortFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServicePortFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceSpecAssert assertThat(io.fabric8.kubernetes.api.model.ServiceSpec actual) {
    return new io.fabric8.kubernetes.api.model.ServiceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceSpecBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceSpecBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceSpecFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceSpecFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceStatusAssert assertThat(io.fabric8.kubernetes.api.model.ServiceStatus actual) {
    return new io.fabric8.kubernetes.api.model.ServiceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceStatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.ServiceStatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.ServiceStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceStatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.ServiceStatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.ServiceStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusAssert assertThat(io.fabric8.kubernetes.api.model.Status actual) {
    return new io.fabric8.kubernetes.api.model.StatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusBuilderAssert assertThat(io.fabric8.kubernetes.api.model.StatusBuilder actual) {
    return new io.fabric8.kubernetes.api.model.StatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusCauseAssert assertThat(io.fabric8.kubernetes.api.model.StatusCause actual) {
    return new io.fabric8.kubernetes.api.model.StatusCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusCauseBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusCauseBuilderAssert assertThat(io.fabric8.kubernetes.api.model.StatusCauseBuilder actual) {
    return new io.fabric8.kubernetes.api.model.StatusCauseBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusCauseFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusCauseFluentAssert assertThat(io.fabric8.kubernetes.api.model.StatusCauseFluent actual) {
    return new io.fabric8.kubernetes.api.model.StatusCauseFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusDetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusDetailsAssert assertThat(io.fabric8.kubernetes.api.model.StatusDetails actual) {
    return new io.fabric8.kubernetes.api.model.StatusDetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusDetailsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusDetailsBuilderAssert assertThat(io.fabric8.kubernetes.api.model.StatusDetailsBuilder actual) {
    return new io.fabric8.kubernetes.api.model.StatusDetailsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusDetailsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusDetailsFluentAssert assertThat(io.fabric8.kubernetes.api.model.StatusDetailsFluent actual) {
    return new io.fabric8.kubernetes.api.model.StatusDetailsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusFluentAssert assertThat(io.fabric8.kubernetes.api.model.StatusFluent actual) {
    return new io.fabric8.kubernetes.api.model.StatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketAction actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionBuilderAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketActionBuilder actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionFluentAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketActionFluent actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeAssert assertThat(io.fabric8.kubernetes.api.model.Volume actual) {
    return new io.fabric8.kubernetes.api.model.VolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeBuilderAssert assertThat(io.fabric8.kubernetes.api.model.VolumeBuilder actual) {
    return new io.fabric8.kubernetes.api.model.VolumeBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeFluentAssert assertThat(io.fabric8.kubernetes.api.model.VolumeFluent actual) {
    return new io.fabric8.kubernetes.api.model.VolumeFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountBuilderAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMountBuilder actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountFluentAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMountFluent actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.WatchEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.WatchEventAssert assertThat(io.fabric8.kubernetes.api.model.WatchEvent actual) {
    return new io.fabric8.kubernetes.api.model.WatchEventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.WatchEventBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.WatchEventBuilderAssert assertThat(io.fabric8.kubernetes.api.model.WatchEventBuilder actual) {
    return new io.fabric8.kubernetes.api.model.WatchEventBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.WatchEventFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.WatchEventFluentAssert assertThat(io.fabric8.kubernetes.api.model.WatchEventFluent actual) {
    return new io.fabric8.kubernetes.api.model.WatchEventFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildAssert assertThat(io.fabric8.openshift.api.model.Build actual) {
    return new io.fabric8.openshift.api.model.BuildAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildBuilderAssert assertThat(io.fabric8.openshift.api.model.BuildBuilder actual) {
    return new io.fabric8.openshift.api.model.BuildBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigAssert assertThat(io.fabric8.openshift.api.model.BuildConfig actual) {
    return new io.fabric8.openshift.api.model.BuildConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigBuilderAssert assertThat(io.fabric8.openshift.api.model.BuildConfigBuilder actual) {
    return new io.fabric8.openshift.api.model.BuildConfigBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigFluentAssert assertThat(io.fabric8.openshift.api.model.BuildConfigFluent actual) {
    return new io.fabric8.openshift.api.model.BuildConfigFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigListAssert assertThat(io.fabric8.openshift.api.model.BuildConfigList actual) {
    return new io.fabric8.openshift.api.model.BuildConfigListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigListBuilderAssert assertThat(io.fabric8.openshift.api.model.BuildConfigListBuilder actual) {
    return new io.fabric8.openshift.api.model.BuildConfigListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigListFluentAssert assertThat(io.fabric8.openshift.api.model.BuildConfigListFluent actual) {
    return new io.fabric8.openshift.api.model.BuildConfigListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigSpecAssert assertThat(io.fabric8.openshift.api.model.BuildConfigSpec actual) {
    return new io.fabric8.openshift.api.model.BuildConfigSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigSpecBuilderAssert assertThat(io.fabric8.openshift.api.model.BuildConfigSpecBuilder actual) {
    return new io.fabric8.openshift.api.model.BuildConfigSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigSpecFluentAssert assertThat(io.fabric8.openshift.api.model.BuildConfigSpecFluent actual) {
    return new io.fabric8.openshift.api.model.BuildConfigSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigStatusAssert assertThat(io.fabric8.openshift.api.model.BuildConfigStatus actual) {
    return new io.fabric8.openshift.api.model.BuildConfigStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigStatusBuilderAssert assertThat(io.fabric8.openshift.api.model.BuildConfigStatusBuilder actual) {
    return new io.fabric8.openshift.api.model.BuildConfigStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigStatusFluentAssert assertThat(io.fabric8.openshift.api.model.BuildConfigStatusFluent actual) {
    return new io.fabric8.openshift.api.model.BuildConfigStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildFluentAssert assertThat(io.fabric8.openshift.api.model.BuildFluent actual) {
    return new io.fabric8.openshift.api.model.BuildFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildListAssert assertThat(io.fabric8.openshift.api.model.BuildList actual) {
    return new io.fabric8.openshift.api.model.BuildListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildListBuilderAssert assertThat(io.fabric8.openshift.api.model.BuildListBuilder actual) {
    return new io.fabric8.openshift.api.model.BuildListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildListFluentAssert assertThat(io.fabric8.openshift.api.model.BuildListFluent actual) {
    return new io.fabric8.openshift.api.model.BuildListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildOutputAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildOutputAssert assertThat(io.fabric8.openshift.api.model.BuildOutput actual) {
    return new io.fabric8.openshift.api.model.BuildOutputAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildOutputBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildOutputBuilderAssert assertThat(io.fabric8.openshift.api.model.BuildOutputBuilder actual) {
    return new io.fabric8.openshift.api.model.BuildOutputBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildOutputFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildOutputFluentAssert assertThat(io.fabric8.openshift.api.model.BuildOutputFluent actual) {
    return new io.fabric8.openshift.api.model.BuildOutputFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildRequestAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildRequestAssert assertThat(io.fabric8.openshift.api.model.BuildRequest actual) {
    return new io.fabric8.openshift.api.model.BuildRequestAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildRequestBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildRequestBuilderAssert assertThat(io.fabric8.openshift.api.model.BuildRequestBuilder actual) {
    return new io.fabric8.openshift.api.model.BuildRequestBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildRequestFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildRequestFluentAssert assertThat(io.fabric8.openshift.api.model.BuildRequestFluent actual) {
    return new io.fabric8.openshift.api.model.BuildRequestFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildSourceAssert assertThat(io.fabric8.openshift.api.model.BuildSource actual) {
    return new io.fabric8.openshift.api.model.BuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildSourceBuilderAssert assertThat(io.fabric8.openshift.api.model.BuildSourceBuilder actual) {
    return new io.fabric8.openshift.api.model.BuildSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildSourceFluentAssert assertThat(io.fabric8.openshift.api.model.BuildSourceFluent actual) {
    return new io.fabric8.openshift.api.model.BuildSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildSpecAssert assertThat(io.fabric8.openshift.api.model.BuildSpec actual) {
    return new io.fabric8.openshift.api.model.BuildSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildSpecBuilderAssert assertThat(io.fabric8.openshift.api.model.BuildSpecBuilder actual) {
    return new io.fabric8.openshift.api.model.BuildSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildSpecFluentAssert assertThat(io.fabric8.openshift.api.model.BuildSpecFluent actual) {
    return new io.fabric8.openshift.api.model.BuildSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildStatusAssert assertThat(io.fabric8.openshift.api.model.BuildStatus actual) {
    return new io.fabric8.openshift.api.model.BuildStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildStatusBuilderAssert assertThat(io.fabric8.openshift.api.model.BuildStatusBuilder actual) {
    return new io.fabric8.openshift.api.model.BuildStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildStatusFluentAssert assertThat(io.fabric8.openshift.api.model.BuildStatusFluent actual) {
    return new io.fabric8.openshift.api.model.BuildStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildStrategyAssert assertThat(io.fabric8.openshift.api.model.BuildStrategy actual) {
    return new io.fabric8.openshift.api.model.BuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildStrategyBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildStrategyBuilderAssert assertThat(io.fabric8.openshift.api.model.BuildStrategyBuilder actual) {
    return new io.fabric8.openshift.api.model.BuildStrategyBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildStrategyFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildStrategyFluentAssert assertThat(io.fabric8.openshift.api.model.BuildStrategyFluent actual) {
    return new io.fabric8.openshift.api.model.BuildStrategyFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildTriggerPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildTriggerPolicyAssert assertThat(io.fabric8.openshift.api.model.BuildTriggerPolicy actual) {
    return new io.fabric8.openshift.api.model.BuildTriggerPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildTriggerPolicyBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildTriggerPolicyBuilderAssert assertThat(io.fabric8.openshift.api.model.BuildTriggerPolicyBuilder actual) {
    return new io.fabric8.openshift.api.model.BuildTriggerPolicyBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildTriggerPolicyFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildTriggerPolicyFluentAssert assertThat(io.fabric8.openshift.api.model.BuildTriggerPolicyFluent actual) {
    return new io.fabric8.openshift.api.model.BuildTriggerPolicyFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicy actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyBindingAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicyBinding actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyBindingBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyBindingBuilderAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicyBindingBuilder actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyBindingBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyBindingFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyBindingFluentAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicyBindingFluent actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyBindingFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyBindingListAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicyBindingList actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyBindingListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyBindingListBuilderAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicyBindingListBuilder actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyBindingListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyBindingListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyBindingListFluentAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicyBindingListFluent actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyBindingListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyBuilderAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicyBuilder actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyFluentAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicyFluent actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyListAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicyList actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyListBuilderAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicyListBuilder actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyListFluentAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicyListFluent actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterRoleAssert assertThat(io.fabric8.openshift.api.model.ClusterRole actual) {
    return new io.fabric8.openshift.api.model.ClusterRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterRoleBindingAssert assertThat(io.fabric8.openshift.api.model.ClusterRoleBinding actual) {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterRoleBindingBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterRoleBindingBuilderAssert assertThat(io.fabric8.openshift.api.model.ClusterRoleBindingBuilder actual) {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterRoleBindingFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterRoleBindingFluentAssert assertThat(io.fabric8.openshift.api.model.ClusterRoleBindingFluent actual) {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterRoleBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterRoleBindingListAssert assertThat(io.fabric8.openshift.api.model.ClusterRoleBindingList actual) {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterRoleBindingListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterRoleBindingListBuilderAssert assertThat(io.fabric8.openshift.api.model.ClusterRoleBindingListBuilder actual) {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterRoleBindingListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterRoleBindingListFluentAssert assertThat(io.fabric8.openshift.api.model.ClusterRoleBindingListFluent actual) {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterRoleBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterRoleBuilderAssert assertThat(io.fabric8.openshift.api.model.ClusterRoleBuilder actual) {
    return new io.fabric8.openshift.api.model.ClusterRoleBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterRoleFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterRoleFluentAssert assertThat(io.fabric8.openshift.api.model.ClusterRoleFluent actual) {
    return new io.fabric8.openshift.api.model.ClusterRoleFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.CustomBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.CustomBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.CustomBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.CustomBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.CustomBuildStrategyBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.CustomBuildStrategyBuilderAssert assertThat(io.fabric8.openshift.api.model.CustomBuildStrategyBuilder actual) {
    return new io.fabric8.openshift.api.model.CustomBuildStrategyBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.CustomBuildStrategyFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.CustomBuildStrategyFluentAssert assertThat(io.fabric8.openshift.api.model.CustomBuildStrategyFluent actual) {
    return new io.fabric8.openshift.api.model.CustomBuildStrategyFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.CustomDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsBuilderAssert assertThat(io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsBuilder actual) {
    return new io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsFluentAssert assertThat(io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsFluent actual) {
    return new io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DecAssert assertThat(io.fabric8.openshift.api.model.Dec actual) {
    return new io.fabric8.openshift.api.model.DecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentCauseAssert assertThat(io.fabric8.openshift.api.model.DeploymentCause actual) {
    return new io.fabric8.openshift.api.model.DeploymentCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentCauseBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentCauseBuilderAssert assertThat(io.fabric8.openshift.api.model.DeploymentCauseBuilder actual) {
    return new io.fabric8.openshift.api.model.DeploymentCauseBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentCauseFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentCauseFluentAssert assertThat(io.fabric8.openshift.api.model.DeploymentCauseFluent actual) {
    return new io.fabric8.openshift.api.model.DeploymentCauseFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentCauseImageTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentCauseImageTriggerAssert assertThat(io.fabric8.openshift.api.model.DeploymentCauseImageTrigger actual) {
    return new io.fabric8.openshift.api.model.DeploymentCauseImageTriggerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentCauseImageTriggerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentCauseImageTriggerBuilderAssert assertThat(io.fabric8.openshift.api.model.DeploymentCauseImageTriggerBuilder actual) {
    return new io.fabric8.openshift.api.model.DeploymentCauseImageTriggerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentCauseImageTriggerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentCauseImageTriggerFluentAssert assertThat(io.fabric8.openshift.api.model.DeploymentCauseImageTriggerFluent actual) {
    return new io.fabric8.openshift.api.model.DeploymentCauseImageTriggerFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfig actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigBuilderAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigBuilder actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigFluentAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigFluent actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigListAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigList actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigListBuilderAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigListBuilder actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigListFluentAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigListFluent actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigSpecAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigSpec actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigSpecBuilderAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigSpecBuilder actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigSpecFluentAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigSpecFluent actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigStatusAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigStatus actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigStatusBuilderAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigStatusBuilder actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigStatusFluentAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigStatusFluent actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentDetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentDetailsAssert assertThat(io.fabric8.openshift.api.model.DeploymentDetails actual) {
    return new io.fabric8.openshift.api.model.DeploymentDetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentDetailsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentDetailsBuilderAssert assertThat(io.fabric8.openshift.api.model.DeploymentDetailsBuilder actual) {
    return new io.fabric8.openshift.api.model.DeploymentDetailsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentDetailsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentDetailsFluentAssert assertThat(io.fabric8.openshift.api.model.DeploymentDetailsFluent actual) {
    return new io.fabric8.openshift.api.model.DeploymentDetailsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentStrategyAssert assertThat(io.fabric8.openshift.api.model.DeploymentStrategy actual) {
    return new io.fabric8.openshift.api.model.DeploymentStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentStrategyBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentStrategyBuilderAssert assertThat(io.fabric8.openshift.api.model.DeploymentStrategyBuilder actual) {
    return new io.fabric8.openshift.api.model.DeploymentStrategyBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentStrategyFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentStrategyFluentAssert assertThat(io.fabric8.openshift.api.model.DeploymentStrategyFluent actual) {
    return new io.fabric8.openshift.api.model.DeploymentStrategyFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsAssert assertThat(io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParams actual) {
    return new io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsBuilderAssert assertThat(io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsBuilder actual) {
    return new io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsFluentAssert assertThat(io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsFluent actual) {
    return new io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentTriggerPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentTriggerPolicyAssert assertThat(io.fabric8.openshift.api.model.DeploymentTriggerPolicy actual) {
    return new io.fabric8.openshift.api.model.DeploymentTriggerPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilderAssert assertThat(io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder actual) {
    return new io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluentAssert assertThat(io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluent actual) {
    return new io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DockerBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DockerBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.DockerBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.DockerBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DockerBuildStrategyBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DockerBuildStrategyBuilderAssert assertThat(io.fabric8.openshift.api.model.DockerBuildStrategyBuilder actual) {
    return new io.fabric8.openshift.api.model.DockerBuildStrategyBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DockerBuildStrategyFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DockerBuildStrategyFluentAssert assertThat(io.fabric8.openshift.api.model.DockerBuildStrategyFluent actual) {
    return new io.fabric8.openshift.api.model.DockerBuildStrategyFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableBuildAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableBuildAssert assertThat(io.fabric8.openshift.api.model.DoneableBuild actual) {
    return new io.fabric8.openshift.api.model.DoneableBuildAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableBuildConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableBuildConfigAssert assertThat(io.fabric8.openshift.api.model.DoneableBuildConfig actual) {
    return new io.fabric8.openshift.api.model.DoneableBuildConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableBuildConfigListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableBuildConfigListAssert assertThat(io.fabric8.openshift.api.model.DoneableBuildConfigList actual) {
    return new io.fabric8.openshift.api.model.DoneableBuildConfigListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableBuildConfigSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableBuildConfigSpecAssert assertThat(io.fabric8.openshift.api.model.DoneableBuildConfigSpec actual) {
    return new io.fabric8.openshift.api.model.DoneableBuildConfigSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableBuildConfigStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableBuildConfigStatusAssert assertThat(io.fabric8.openshift.api.model.DoneableBuildConfigStatus actual) {
    return new io.fabric8.openshift.api.model.DoneableBuildConfigStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableBuildListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableBuildListAssert assertThat(io.fabric8.openshift.api.model.DoneableBuildList actual) {
    return new io.fabric8.openshift.api.model.DoneableBuildListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableBuildOutputAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableBuildOutputAssert assertThat(io.fabric8.openshift.api.model.DoneableBuildOutput actual) {
    return new io.fabric8.openshift.api.model.DoneableBuildOutputAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableBuildRequestAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableBuildRequestAssert assertThat(io.fabric8.openshift.api.model.DoneableBuildRequest actual) {
    return new io.fabric8.openshift.api.model.DoneableBuildRequestAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableBuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableBuildSourceAssert assertThat(io.fabric8.openshift.api.model.DoneableBuildSource actual) {
    return new io.fabric8.openshift.api.model.DoneableBuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableBuildSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableBuildSpecAssert assertThat(io.fabric8.openshift.api.model.DoneableBuildSpec actual) {
    return new io.fabric8.openshift.api.model.DoneableBuildSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableBuildStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableBuildStatusAssert assertThat(io.fabric8.openshift.api.model.DoneableBuildStatus actual) {
    return new io.fabric8.openshift.api.model.DoneableBuildStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.DoneableBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.DoneableBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableBuildTriggerPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableBuildTriggerPolicyAssert assertThat(io.fabric8.openshift.api.model.DoneableBuildTriggerPolicy actual) {
    return new io.fabric8.openshift.api.model.DoneableBuildTriggerPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableClusterPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableClusterPolicyAssert assertThat(io.fabric8.openshift.api.model.DoneableClusterPolicy actual) {
    return new io.fabric8.openshift.api.model.DoneableClusterPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableClusterPolicyBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableClusterPolicyBindingAssert assertThat(io.fabric8.openshift.api.model.DoneableClusterPolicyBinding actual) {
    return new io.fabric8.openshift.api.model.DoneableClusterPolicyBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableClusterPolicyBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableClusterPolicyBindingListAssert assertThat(io.fabric8.openshift.api.model.DoneableClusterPolicyBindingList actual) {
    return new io.fabric8.openshift.api.model.DoneableClusterPolicyBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableClusterPolicyListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableClusterPolicyListAssert assertThat(io.fabric8.openshift.api.model.DoneableClusterPolicyList actual) {
    return new io.fabric8.openshift.api.model.DoneableClusterPolicyListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableClusterRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableClusterRoleAssert assertThat(io.fabric8.openshift.api.model.DoneableClusterRole actual) {
    return new io.fabric8.openshift.api.model.DoneableClusterRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableClusterRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableClusterRoleBindingAssert assertThat(io.fabric8.openshift.api.model.DoneableClusterRoleBinding actual) {
    return new io.fabric8.openshift.api.model.DoneableClusterRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableClusterRoleBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableClusterRoleBindingListAssert assertThat(io.fabric8.openshift.api.model.DoneableClusterRoleBindingList actual) {
    return new io.fabric8.openshift.api.model.DoneableClusterRoleBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableCustomBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableCustomBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.DoneableCustomBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.DoneableCustomBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableCustomDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableCustomDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.DoneableCustomDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.DoneableCustomDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableDeploymentCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableDeploymentCauseAssert assertThat(io.fabric8.openshift.api.model.DoneableDeploymentCause actual) {
    return new io.fabric8.openshift.api.model.DoneableDeploymentCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableDeploymentCauseImageTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableDeploymentCauseImageTriggerAssert assertThat(io.fabric8.openshift.api.model.DoneableDeploymentCauseImageTrigger actual) {
    return new io.fabric8.openshift.api.model.DoneableDeploymentCauseImageTriggerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableDeploymentConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableDeploymentConfigAssert assertThat(io.fabric8.openshift.api.model.DoneableDeploymentConfig actual) {
    return new io.fabric8.openshift.api.model.DoneableDeploymentConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableDeploymentConfigListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableDeploymentConfigListAssert assertThat(io.fabric8.openshift.api.model.DoneableDeploymentConfigList actual) {
    return new io.fabric8.openshift.api.model.DoneableDeploymentConfigListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableDeploymentConfigSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableDeploymentConfigSpecAssert assertThat(io.fabric8.openshift.api.model.DoneableDeploymentConfigSpec actual) {
    return new io.fabric8.openshift.api.model.DoneableDeploymentConfigSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableDeploymentConfigStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableDeploymentConfigStatusAssert assertThat(io.fabric8.openshift.api.model.DoneableDeploymentConfigStatus actual) {
    return new io.fabric8.openshift.api.model.DoneableDeploymentConfigStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableDeploymentDetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableDeploymentDetailsAssert assertThat(io.fabric8.openshift.api.model.DoneableDeploymentDetails actual) {
    return new io.fabric8.openshift.api.model.DoneableDeploymentDetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableDeploymentStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableDeploymentStrategyAssert assertThat(io.fabric8.openshift.api.model.DoneableDeploymentStrategy actual) {
    return new io.fabric8.openshift.api.model.DoneableDeploymentStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableDeploymentTriggerImageChangeParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableDeploymentTriggerImageChangeParamsAssert assertThat(io.fabric8.openshift.api.model.DoneableDeploymentTriggerImageChangeParams actual) {
    return new io.fabric8.openshift.api.model.DoneableDeploymentTriggerImageChangeParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableDeploymentTriggerPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableDeploymentTriggerPolicyAssert assertThat(io.fabric8.openshift.api.model.DoneableDeploymentTriggerPolicy actual) {
    return new io.fabric8.openshift.api.model.DoneableDeploymentTriggerPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableDockerBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableDockerBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.DoneableDockerBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.DoneableDockerBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableExecNewPodHookAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableExecNewPodHookAssert assertThat(io.fabric8.openshift.api.model.DoneableExecNewPodHook actual) {
    return new io.fabric8.openshift.api.model.DoneableExecNewPodHookAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableGitBuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableGitBuildSourceAssert assertThat(io.fabric8.openshift.api.model.DoneableGitBuildSource actual) {
    return new io.fabric8.openshift.api.model.DoneableGitBuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableGitSourceRevisionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableGitSourceRevisionAssert assertThat(io.fabric8.openshift.api.model.DoneableGitSourceRevision actual) {
    return new io.fabric8.openshift.api.model.DoneableGitSourceRevisionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableGroupAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableGroupAssert assertThat(io.fabric8.openshift.api.model.DoneableGroup actual) {
    return new io.fabric8.openshift.api.model.DoneableGroupAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableGroupListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableGroupListAssert assertThat(io.fabric8.openshift.api.model.DoneableGroupList actual) {
    return new io.fabric8.openshift.api.model.DoneableGroupListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableIdentityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableIdentityAssert assertThat(io.fabric8.openshift.api.model.DoneableIdentity actual) {
    return new io.fabric8.openshift.api.model.DoneableIdentityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableIdentityListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableIdentityListAssert assertThat(io.fabric8.openshift.api.model.DoneableIdentityList actual) {
    return new io.fabric8.openshift.api.model.DoneableIdentityListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableImageAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableImageAssert assertThat(io.fabric8.openshift.api.model.DoneableImage actual) {
    return new io.fabric8.openshift.api.model.DoneableImageAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableImageChangeTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableImageChangeTriggerAssert assertThat(io.fabric8.openshift.api.model.DoneableImageChangeTrigger actual) {
    return new io.fabric8.openshift.api.model.DoneableImageChangeTriggerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableImageListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableImageListAssert assertThat(io.fabric8.openshift.api.model.DoneableImageList actual) {
    return new io.fabric8.openshift.api.model.DoneableImageListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableImageStreamAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableImageStreamAssert assertThat(io.fabric8.openshift.api.model.DoneableImageStream actual) {
    return new io.fabric8.openshift.api.model.DoneableImageStreamAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableImageStreamListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableImageStreamListAssert assertThat(io.fabric8.openshift.api.model.DoneableImageStreamList actual) {
    return new io.fabric8.openshift.api.model.DoneableImageStreamListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableImageStreamSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableImageStreamSpecAssert assertThat(io.fabric8.openshift.api.model.DoneableImageStreamSpec actual) {
    return new io.fabric8.openshift.api.model.DoneableImageStreamSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableImageStreamStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableImageStreamStatusAssert assertThat(io.fabric8.openshift.api.model.DoneableImageStreamStatus actual) {
    return new io.fabric8.openshift.api.model.DoneableImageStreamStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableLifecycleHookAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableLifecycleHookAssert assertThat(io.fabric8.openshift.api.model.DoneableLifecycleHook actual) {
    return new io.fabric8.openshift.api.model.DoneableLifecycleHookAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableNamedClusterRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableNamedClusterRoleAssert assertThat(io.fabric8.openshift.api.model.DoneableNamedClusterRole actual) {
    return new io.fabric8.openshift.api.model.DoneableNamedClusterRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableNamedClusterRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableNamedClusterRoleBindingAssert assertThat(io.fabric8.openshift.api.model.DoneableNamedClusterRoleBinding actual) {
    return new io.fabric8.openshift.api.model.DoneableNamedClusterRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableNamedRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableNamedRoleAssert assertThat(io.fabric8.openshift.api.model.DoneableNamedRole actual) {
    return new io.fabric8.openshift.api.model.DoneableNamedRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableNamedRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableNamedRoleBindingAssert assertThat(io.fabric8.openshift.api.model.DoneableNamedRoleBinding actual) {
    return new io.fabric8.openshift.api.model.DoneableNamedRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableNamedTagEventListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableNamedTagEventListAssert assertThat(io.fabric8.openshift.api.model.DoneableNamedTagEventList actual) {
    return new io.fabric8.openshift.api.model.DoneableNamedTagEventListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableNamedTagReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableNamedTagReferenceAssert assertThat(io.fabric8.openshift.api.model.DoneableNamedTagReference actual) {
    return new io.fabric8.openshift.api.model.DoneableNamedTagReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableOAuthAccessTokenAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableOAuthAccessTokenAssert assertThat(io.fabric8.openshift.api.model.DoneableOAuthAccessToken actual) {
    return new io.fabric8.openshift.api.model.DoneableOAuthAccessTokenAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableOAuthAccessTokenListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableOAuthAccessTokenListAssert assertThat(io.fabric8.openshift.api.model.DoneableOAuthAccessTokenList actual) {
    return new io.fabric8.openshift.api.model.DoneableOAuthAccessTokenListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableOAuthAuthorizeTokenAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableOAuthAuthorizeTokenAssert assertThat(io.fabric8.openshift.api.model.DoneableOAuthAuthorizeToken actual) {
    return new io.fabric8.openshift.api.model.DoneableOAuthAuthorizeTokenAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableOAuthAuthorizeTokenListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableOAuthAuthorizeTokenListAssert assertThat(io.fabric8.openshift.api.model.DoneableOAuthAuthorizeTokenList actual) {
    return new io.fabric8.openshift.api.model.DoneableOAuthAuthorizeTokenListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableOAuthClientAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableOAuthClientAssert assertThat(io.fabric8.openshift.api.model.DoneableOAuthClient actual) {
    return new io.fabric8.openshift.api.model.DoneableOAuthClientAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableOAuthClientAuthorizationAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableOAuthClientAuthorizationAssert assertThat(io.fabric8.openshift.api.model.DoneableOAuthClientAuthorization actual) {
    return new io.fabric8.openshift.api.model.DoneableOAuthClientAuthorizationAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableOAuthClientAuthorizationListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableOAuthClientAuthorizationListAssert assertThat(io.fabric8.openshift.api.model.DoneableOAuthClientAuthorizationList actual) {
    return new io.fabric8.openshift.api.model.DoneableOAuthClientAuthorizationListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableOAuthClientListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableOAuthClientListAssert assertThat(io.fabric8.openshift.api.model.DoneableOAuthClientList actual) {
    return new io.fabric8.openshift.api.model.DoneableOAuthClientListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableParameterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableParameterAssert assertThat(io.fabric8.openshift.api.model.DoneableParameter actual) {
    return new io.fabric8.openshift.api.model.DoneableParameterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneablePolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneablePolicyAssert assertThat(io.fabric8.openshift.api.model.DoneablePolicy actual) {
    return new io.fabric8.openshift.api.model.DoneablePolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneablePolicyBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneablePolicyBindingAssert assertThat(io.fabric8.openshift.api.model.DoneablePolicyBinding actual) {
    return new io.fabric8.openshift.api.model.DoneablePolicyBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneablePolicyBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneablePolicyBindingListAssert assertThat(io.fabric8.openshift.api.model.DoneablePolicyBindingList actual) {
    return new io.fabric8.openshift.api.model.DoneablePolicyBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneablePolicyListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneablePolicyListAssert assertThat(io.fabric8.openshift.api.model.DoneablePolicyList actual) {
    return new io.fabric8.openshift.api.model.DoneablePolicyListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneablePolicyRuleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneablePolicyRuleAssert assertThat(io.fabric8.openshift.api.model.DoneablePolicyRule actual) {
    return new io.fabric8.openshift.api.model.DoneablePolicyRuleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableRecreateDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableRecreateDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.DoneableRecreateDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.DoneableRecreateDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableRoleAssert assertThat(io.fabric8.openshift.api.model.DoneableRole actual) {
    return new io.fabric8.openshift.api.model.DoneableRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableRoleBindingAssert assertThat(io.fabric8.openshift.api.model.DoneableRoleBinding actual) {
    return new io.fabric8.openshift.api.model.DoneableRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableRoleBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableRoleBindingListAssert assertThat(io.fabric8.openshift.api.model.DoneableRoleBindingList actual) {
    return new io.fabric8.openshift.api.model.DoneableRoleBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableRoleListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableRoleListAssert assertThat(io.fabric8.openshift.api.model.DoneableRoleList actual) {
    return new io.fabric8.openshift.api.model.DoneableRoleListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableRollingDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableRollingDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.DoneableRollingDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.DoneableRollingDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableRouteAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableRouteAssert assertThat(io.fabric8.openshift.api.model.DoneableRoute actual) {
    return new io.fabric8.openshift.api.model.DoneableRouteAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableRouteListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableRouteListAssert assertThat(io.fabric8.openshift.api.model.DoneableRouteList actual) {
    return new io.fabric8.openshift.api.model.DoneableRouteListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableRouteSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableRouteSpecAssert assertThat(io.fabric8.openshift.api.model.DoneableRouteSpec actual) {
    return new io.fabric8.openshift.api.model.DoneableRouteSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableSourceBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableSourceBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.DoneableSourceBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.DoneableSourceBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableSourceControlUserAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableSourceControlUserAssert assertThat(io.fabric8.openshift.api.model.DoneableSourceControlUser actual) {
    return new io.fabric8.openshift.api.model.DoneableSourceControlUserAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableSourceRevisionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableSourceRevisionAssert assertThat(io.fabric8.openshift.api.model.DoneableSourceRevision actual) {
    return new io.fabric8.openshift.api.model.DoneableSourceRevisionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableTLSConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableTLSConfigAssert assertThat(io.fabric8.openshift.api.model.DoneableTLSConfig actual) {
    return new io.fabric8.openshift.api.model.DoneableTLSConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableTagEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableTagEventAssert assertThat(io.fabric8.openshift.api.model.DoneableTagEvent actual) {
    return new io.fabric8.openshift.api.model.DoneableTagEventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableTemplateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableTemplateAssert assertThat(io.fabric8.openshift.api.model.DoneableTemplate actual) {
    return new io.fabric8.openshift.api.model.DoneableTemplateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableTemplateListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableTemplateListAssert assertThat(io.fabric8.openshift.api.model.DoneableTemplateList actual) {
    return new io.fabric8.openshift.api.model.DoneableTemplateListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableUserAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableUserAssert assertThat(io.fabric8.openshift.api.model.DoneableUser actual) {
    return new io.fabric8.openshift.api.model.DoneableUserAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableUserListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableUserListAssert assertThat(io.fabric8.openshift.api.model.DoneableUserList actual) {
    return new io.fabric8.openshift.api.model.DoneableUserListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DoneableWebHookTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DoneableWebHookTriggerAssert assertThat(io.fabric8.openshift.api.model.DoneableWebHookTrigger actual) {
    return new io.fabric8.openshift.api.model.DoneableWebHookTriggerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableBuildAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableBuildAssert assertThat(io.fabric8.openshift.api.model.EditableBuild actual) {
    return new io.fabric8.openshift.api.model.EditableBuildAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableBuildConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableBuildConfigAssert assertThat(io.fabric8.openshift.api.model.EditableBuildConfig actual) {
    return new io.fabric8.openshift.api.model.EditableBuildConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableBuildConfigListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableBuildConfigListAssert assertThat(io.fabric8.openshift.api.model.EditableBuildConfigList actual) {
    return new io.fabric8.openshift.api.model.EditableBuildConfigListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableBuildConfigSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableBuildConfigSpecAssert assertThat(io.fabric8.openshift.api.model.EditableBuildConfigSpec actual) {
    return new io.fabric8.openshift.api.model.EditableBuildConfigSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableBuildConfigStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableBuildConfigStatusAssert assertThat(io.fabric8.openshift.api.model.EditableBuildConfigStatus actual) {
    return new io.fabric8.openshift.api.model.EditableBuildConfigStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableBuildListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableBuildListAssert assertThat(io.fabric8.openshift.api.model.EditableBuildList actual) {
    return new io.fabric8.openshift.api.model.EditableBuildListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableBuildOutputAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableBuildOutputAssert assertThat(io.fabric8.openshift.api.model.EditableBuildOutput actual) {
    return new io.fabric8.openshift.api.model.EditableBuildOutputAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableBuildRequestAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableBuildRequestAssert assertThat(io.fabric8.openshift.api.model.EditableBuildRequest actual) {
    return new io.fabric8.openshift.api.model.EditableBuildRequestAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableBuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableBuildSourceAssert assertThat(io.fabric8.openshift.api.model.EditableBuildSource actual) {
    return new io.fabric8.openshift.api.model.EditableBuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableBuildSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableBuildSpecAssert assertThat(io.fabric8.openshift.api.model.EditableBuildSpec actual) {
    return new io.fabric8.openshift.api.model.EditableBuildSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableBuildStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableBuildStatusAssert assertThat(io.fabric8.openshift.api.model.EditableBuildStatus actual) {
    return new io.fabric8.openshift.api.model.EditableBuildStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.EditableBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.EditableBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableBuildTriggerPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableBuildTriggerPolicyAssert assertThat(io.fabric8.openshift.api.model.EditableBuildTriggerPolicy actual) {
    return new io.fabric8.openshift.api.model.EditableBuildTriggerPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableClusterPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableClusterPolicyAssert assertThat(io.fabric8.openshift.api.model.EditableClusterPolicy actual) {
    return new io.fabric8.openshift.api.model.EditableClusterPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableClusterPolicyBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableClusterPolicyBindingAssert assertThat(io.fabric8.openshift.api.model.EditableClusterPolicyBinding actual) {
    return new io.fabric8.openshift.api.model.EditableClusterPolicyBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableClusterPolicyBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableClusterPolicyBindingListAssert assertThat(io.fabric8.openshift.api.model.EditableClusterPolicyBindingList actual) {
    return new io.fabric8.openshift.api.model.EditableClusterPolicyBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableClusterPolicyListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableClusterPolicyListAssert assertThat(io.fabric8.openshift.api.model.EditableClusterPolicyList actual) {
    return new io.fabric8.openshift.api.model.EditableClusterPolicyListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableClusterRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableClusterRoleAssert assertThat(io.fabric8.openshift.api.model.EditableClusterRole actual) {
    return new io.fabric8.openshift.api.model.EditableClusterRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableClusterRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableClusterRoleBindingAssert assertThat(io.fabric8.openshift.api.model.EditableClusterRoleBinding actual) {
    return new io.fabric8.openshift.api.model.EditableClusterRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableClusterRoleBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableClusterRoleBindingListAssert assertThat(io.fabric8.openshift.api.model.EditableClusterRoleBindingList actual) {
    return new io.fabric8.openshift.api.model.EditableClusterRoleBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableCustomBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableCustomBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.EditableCustomBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.EditableCustomBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableCustomDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableCustomDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.EditableCustomDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.EditableCustomDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableDeploymentCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableDeploymentCauseAssert assertThat(io.fabric8.openshift.api.model.EditableDeploymentCause actual) {
    return new io.fabric8.openshift.api.model.EditableDeploymentCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableDeploymentCauseImageTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableDeploymentCauseImageTriggerAssert assertThat(io.fabric8.openshift.api.model.EditableDeploymentCauseImageTrigger actual) {
    return new io.fabric8.openshift.api.model.EditableDeploymentCauseImageTriggerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableDeploymentConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableDeploymentConfigAssert assertThat(io.fabric8.openshift.api.model.EditableDeploymentConfig actual) {
    return new io.fabric8.openshift.api.model.EditableDeploymentConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableDeploymentConfigListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableDeploymentConfigListAssert assertThat(io.fabric8.openshift.api.model.EditableDeploymentConfigList actual) {
    return new io.fabric8.openshift.api.model.EditableDeploymentConfigListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableDeploymentConfigSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableDeploymentConfigSpecAssert assertThat(io.fabric8.openshift.api.model.EditableDeploymentConfigSpec actual) {
    return new io.fabric8.openshift.api.model.EditableDeploymentConfigSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableDeploymentConfigStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableDeploymentConfigStatusAssert assertThat(io.fabric8.openshift.api.model.EditableDeploymentConfigStatus actual) {
    return new io.fabric8.openshift.api.model.EditableDeploymentConfigStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableDeploymentDetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableDeploymentDetailsAssert assertThat(io.fabric8.openshift.api.model.EditableDeploymentDetails actual) {
    return new io.fabric8.openshift.api.model.EditableDeploymentDetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableDeploymentStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableDeploymentStrategyAssert assertThat(io.fabric8.openshift.api.model.EditableDeploymentStrategy actual) {
    return new io.fabric8.openshift.api.model.EditableDeploymentStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableDeploymentTriggerImageChangeParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableDeploymentTriggerImageChangeParamsAssert assertThat(io.fabric8.openshift.api.model.EditableDeploymentTriggerImageChangeParams actual) {
    return new io.fabric8.openshift.api.model.EditableDeploymentTriggerImageChangeParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableDeploymentTriggerPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableDeploymentTriggerPolicyAssert assertThat(io.fabric8.openshift.api.model.EditableDeploymentTriggerPolicy actual) {
    return new io.fabric8.openshift.api.model.EditableDeploymentTriggerPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableDockerBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableDockerBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.EditableDockerBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.EditableDockerBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableExecNewPodHookAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableExecNewPodHookAssert assertThat(io.fabric8.openshift.api.model.EditableExecNewPodHook actual) {
    return new io.fabric8.openshift.api.model.EditableExecNewPodHookAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableGitBuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableGitBuildSourceAssert assertThat(io.fabric8.openshift.api.model.EditableGitBuildSource actual) {
    return new io.fabric8.openshift.api.model.EditableGitBuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableGitSourceRevisionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableGitSourceRevisionAssert assertThat(io.fabric8.openshift.api.model.EditableGitSourceRevision actual) {
    return new io.fabric8.openshift.api.model.EditableGitSourceRevisionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableGroupAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableGroupAssert assertThat(io.fabric8.openshift.api.model.EditableGroup actual) {
    return new io.fabric8.openshift.api.model.EditableGroupAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableGroupListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableGroupListAssert assertThat(io.fabric8.openshift.api.model.EditableGroupList actual) {
    return new io.fabric8.openshift.api.model.EditableGroupListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableIdentityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableIdentityAssert assertThat(io.fabric8.openshift.api.model.EditableIdentity actual) {
    return new io.fabric8.openshift.api.model.EditableIdentityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableIdentityListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableIdentityListAssert assertThat(io.fabric8.openshift.api.model.EditableIdentityList actual) {
    return new io.fabric8.openshift.api.model.EditableIdentityListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableImageAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableImageAssert assertThat(io.fabric8.openshift.api.model.EditableImage actual) {
    return new io.fabric8.openshift.api.model.EditableImageAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableImageChangeTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableImageChangeTriggerAssert assertThat(io.fabric8.openshift.api.model.EditableImageChangeTrigger actual) {
    return new io.fabric8.openshift.api.model.EditableImageChangeTriggerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableImageListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableImageListAssert assertThat(io.fabric8.openshift.api.model.EditableImageList actual) {
    return new io.fabric8.openshift.api.model.EditableImageListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableImageStreamAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableImageStreamAssert assertThat(io.fabric8.openshift.api.model.EditableImageStream actual) {
    return new io.fabric8.openshift.api.model.EditableImageStreamAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableImageStreamListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableImageStreamListAssert assertThat(io.fabric8.openshift.api.model.EditableImageStreamList actual) {
    return new io.fabric8.openshift.api.model.EditableImageStreamListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableImageStreamSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableImageStreamSpecAssert assertThat(io.fabric8.openshift.api.model.EditableImageStreamSpec actual) {
    return new io.fabric8.openshift.api.model.EditableImageStreamSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableImageStreamStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableImageStreamStatusAssert assertThat(io.fabric8.openshift.api.model.EditableImageStreamStatus actual) {
    return new io.fabric8.openshift.api.model.EditableImageStreamStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableLifecycleHookAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableLifecycleHookAssert assertThat(io.fabric8.openshift.api.model.EditableLifecycleHook actual) {
    return new io.fabric8.openshift.api.model.EditableLifecycleHookAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableNamedClusterRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableNamedClusterRoleAssert assertThat(io.fabric8.openshift.api.model.EditableNamedClusterRole actual) {
    return new io.fabric8.openshift.api.model.EditableNamedClusterRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableNamedClusterRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableNamedClusterRoleBindingAssert assertThat(io.fabric8.openshift.api.model.EditableNamedClusterRoleBinding actual) {
    return new io.fabric8.openshift.api.model.EditableNamedClusterRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableNamedRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableNamedRoleAssert assertThat(io.fabric8.openshift.api.model.EditableNamedRole actual) {
    return new io.fabric8.openshift.api.model.EditableNamedRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableNamedRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableNamedRoleBindingAssert assertThat(io.fabric8.openshift.api.model.EditableNamedRoleBinding actual) {
    return new io.fabric8.openshift.api.model.EditableNamedRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableNamedTagEventListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableNamedTagEventListAssert assertThat(io.fabric8.openshift.api.model.EditableNamedTagEventList actual) {
    return new io.fabric8.openshift.api.model.EditableNamedTagEventListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableNamedTagReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableNamedTagReferenceAssert assertThat(io.fabric8.openshift.api.model.EditableNamedTagReference actual) {
    return new io.fabric8.openshift.api.model.EditableNamedTagReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableOAuthAccessTokenAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableOAuthAccessTokenAssert assertThat(io.fabric8.openshift.api.model.EditableOAuthAccessToken actual) {
    return new io.fabric8.openshift.api.model.EditableOAuthAccessTokenAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableOAuthAccessTokenListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableOAuthAccessTokenListAssert assertThat(io.fabric8.openshift.api.model.EditableOAuthAccessTokenList actual) {
    return new io.fabric8.openshift.api.model.EditableOAuthAccessTokenListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableOAuthAuthorizeTokenAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableOAuthAuthorizeTokenAssert assertThat(io.fabric8.openshift.api.model.EditableOAuthAuthorizeToken actual) {
    return new io.fabric8.openshift.api.model.EditableOAuthAuthorizeTokenAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableOAuthAuthorizeTokenListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableOAuthAuthorizeTokenListAssert assertThat(io.fabric8.openshift.api.model.EditableOAuthAuthorizeTokenList actual) {
    return new io.fabric8.openshift.api.model.EditableOAuthAuthorizeTokenListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableOAuthClientAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableOAuthClientAssert assertThat(io.fabric8.openshift.api.model.EditableOAuthClient actual) {
    return new io.fabric8.openshift.api.model.EditableOAuthClientAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableOAuthClientAuthorizationAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableOAuthClientAuthorizationAssert assertThat(io.fabric8.openshift.api.model.EditableOAuthClientAuthorization actual) {
    return new io.fabric8.openshift.api.model.EditableOAuthClientAuthorizationAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableOAuthClientAuthorizationListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableOAuthClientAuthorizationListAssert assertThat(io.fabric8.openshift.api.model.EditableOAuthClientAuthorizationList actual) {
    return new io.fabric8.openshift.api.model.EditableOAuthClientAuthorizationListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableOAuthClientListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableOAuthClientListAssert assertThat(io.fabric8.openshift.api.model.EditableOAuthClientList actual) {
    return new io.fabric8.openshift.api.model.EditableOAuthClientListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableParameterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableParameterAssert assertThat(io.fabric8.openshift.api.model.EditableParameter actual) {
    return new io.fabric8.openshift.api.model.EditableParameterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditablePolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditablePolicyAssert assertThat(io.fabric8.openshift.api.model.EditablePolicy actual) {
    return new io.fabric8.openshift.api.model.EditablePolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditablePolicyBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditablePolicyBindingAssert assertThat(io.fabric8.openshift.api.model.EditablePolicyBinding actual) {
    return new io.fabric8.openshift.api.model.EditablePolicyBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditablePolicyBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditablePolicyBindingListAssert assertThat(io.fabric8.openshift.api.model.EditablePolicyBindingList actual) {
    return new io.fabric8.openshift.api.model.EditablePolicyBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditablePolicyListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditablePolicyListAssert assertThat(io.fabric8.openshift.api.model.EditablePolicyList actual) {
    return new io.fabric8.openshift.api.model.EditablePolicyListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditablePolicyRuleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditablePolicyRuleAssert assertThat(io.fabric8.openshift.api.model.EditablePolicyRule actual) {
    return new io.fabric8.openshift.api.model.EditablePolicyRuleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableRecreateDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableRecreateDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.EditableRecreateDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.EditableRecreateDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableRoleAssert assertThat(io.fabric8.openshift.api.model.EditableRole actual) {
    return new io.fabric8.openshift.api.model.EditableRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableRoleBindingAssert assertThat(io.fabric8.openshift.api.model.EditableRoleBinding actual) {
    return new io.fabric8.openshift.api.model.EditableRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableRoleBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableRoleBindingListAssert assertThat(io.fabric8.openshift.api.model.EditableRoleBindingList actual) {
    return new io.fabric8.openshift.api.model.EditableRoleBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableRoleListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableRoleListAssert assertThat(io.fabric8.openshift.api.model.EditableRoleList actual) {
    return new io.fabric8.openshift.api.model.EditableRoleListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableRollingDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableRollingDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.EditableRollingDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.EditableRollingDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableRouteAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableRouteAssert assertThat(io.fabric8.openshift.api.model.EditableRoute actual) {
    return new io.fabric8.openshift.api.model.EditableRouteAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableRouteListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableRouteListAssert assertThat(io.fabric8.openshift.api.model.EditableRouteList actual) {
    return new io.fabric8.openshift.api.model.EditableRouteListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableRouteSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableRouteSpecAssert assertThat(io.fabric8.openshift.api.model.EditableRouteSpec actual) {
    return new io.fabric8.openshift.api.model.EditableRouteSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableSourceBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableSourceBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.EditableSourceBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.EditableSourceBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableSourceControlUserAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableSourceControlUserAssert assertThat(io.fabric8.openshift.api.model.EditableSourceControlUser actual) {
    return new io.fabric8.openshift.api.model.EditableSourceControlUserAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableSourceRevisionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableSourceRevisionAssert assertThat(io.fabric8.openshift.api.model.EditableSourceRevision actual) {
    return new io.fabric8.openshift.api.model.EditableSourceRevisionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableTLSConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableTLSConfigAssert assertThat(io.fabric8.openshift.api.model.EditableTLSConfig actual) {
    return new io.fabric8.openshift.api.model.EditableTLSConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableTagEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableTagEventAssert assertThat(io.fabric8.openshift.api.model.EditableTagEvent actual) {
    return new io.fabric8.openshift.api.model.EditableTagEventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableTemplateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableTemplateAssert assertThat(io.fabric8.openshift.api.model.EditableTemplate actual) {
    return new io.fabric8.openshift.api.model.EditableTemplateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableTemplateListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableTemplateListAssert assertThat(io.fabric8.openshift.api.model.EditableTemplateList actual) {
    return new io.fabric8.openshift.api.model.EditableTemplateListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableUserAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableUserAssert assertThat(io.fabric8.openshift.api.model.EditableUser actual) {
    return new io.fabric8.openshift.api.model.EditableUserAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableUserListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableUserListAssert assertThat(io.fabric8.openshift.api.model.EditableUserList actual) {
    return new io.fabric8.openshift.api.model.EditableUserListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.EditableWebHookTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.EditableWebHookTriggerAssert assertThat(io.fabric8.openshift.api.model.EditableWebHookTrigger actual) {
    return new io.fabric8.openshift.api.model.EditableWebHookTriggerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ExecNewPodHookAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ExecNewPodHookAssert assertThat(io.fabric8.openshift.api.model.ExecNewPodHook actual) {
    return new io.fabric8.openshift.api.model.ExecNewPodHookAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ExecNewPodHookBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ExecNewPodHookBuilderAssert assertThat(io.fabric8.openshift.api.model.ExecNewPodHookBuilder actual) {
    return new io.fabric8.openshift.api.model.ExecNewPodHookBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ExecNewPodHookFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ExecNewPodHookFluentAssert assertThat(io.fabric8.openshift.api.model.ExecNewPodHookFluent actual) {
    return new io.fabric8.openshift.api.model.ExecNewPodHookFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GitBuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GitBuildSourceAssert assertThat(io.fabric8.openshift.api.model.GitBuildSource actual) {
    return new io.fabric8.openshift.api.model.GitBuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GitBuildSourceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GitBuildSourceBuilderAssert assertThat(io.fabric8.openshift.api.model.GitBuildSourceBuilder actual) {
    return new io.fabric8.openshift.api.model.GitBuildSourceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GitBuildSourceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GitBuildSourceFluentAssert assertThat(io.fabric8.openshift.api.model.GitBuildSourceFluent actual) {
    return new io.fabric8.openshift.api.model.GitBuildSourceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GitSourceRevisionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GitSourceRevisionAssert assertThat(io.fabric8.openshift.api.model.GitSourceRevision actual) {
    return new io.fabric8.openshift.api.model.GitSourceRevisionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GitSourceRevisionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GitSourceRevisionBuilderAssert assertThat(io.fabric8.openshift.api.model.GitSourceRevisionBuilder actual) {
    return new io.fabric8.openshift.api.model.GitSourceRevisionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GitSourceRevisionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GitSourceRevisionFluentAssert assertThat(io.fabric8.openshift.api.model.GitSourceRevisionFluent actual) {
    return new io.fabric8.openshift.api.model.GitSourceRevisionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GroupAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GroupAssert assertThat(io.fabric8.openshift.api.model.Group actual) {
    return new io.fabric8.openshift.api.model.GroupAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GroupBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GroupBuilderAssert assertThat(io.fabric8.openshift.api.model.GroupBuilder actual) {
    return new io.fabric8.openshift.api.model.GroupBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GroupFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GroupFluentAssert assertThat(io.fabric8.openshift.api.model.GroupFluent actual) {
    return new io.fabric8.openshift.api.model.GroupFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GroupListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GroupListAssert assertThat(io.fabric8.openshift.api.model.GroupList actual) {
    return new io.fabric8.openshift.api.model.GroupListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GroupListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GroupListBuilderAssert assertThat(io.fabric8.openshift.api.model.GroupListBuilder actual) {
    return new io.fabric8.openshift.api.model.GroupListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GroupListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GroupListFluentAssert assertThat(io.fabric8.openshift.api.model.GroupListFluent actual) {
    return new io.fabric8.openshift.api.model.GroupListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.IdentityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.IdentityAssert assertThat(io.fabric8.openshift.api.model.Identity actual) {
    return new io.fabric8.openshift.api.model.IdentityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.IdentityBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.IdentityBuilderAssert assertThat(io.fabric8.openshift.api.model.IdentityBuilder actual) {
    return new io.fabric8.openshift.api.model.IdentityBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.IdentityFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.IdentityFluentAssert assertThat(io.fabric8.openshift.api.model.IdentityFluent actual) {
    return new io.fabric8.openshift.api.model.IdentityFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.IdentityListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.IdentityListAssert assertThat(io.fabric8.openshift.api.model.IdentityList actual) {
    return new io.fabric8.openshift.api.model.IdentityListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.IdentityListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.IdentityListBuilderAssert assertThat(io.fabric8.openshift.api.model.IdentityListBuilder actual) {
    return new io.fabric8.openshift.api.model.IdentityListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.IdentityListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.IdentityListFluentAssert assertThat(io.fabric8.openshift.api.model.IdentityListFluent actual) {
    return new io.fabric8.openshift.api.model.IdentityListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageAssert assertThat(io.fabric8.openshift.api.model.Image actual) {
    return new io.fabric8.openshift.api.model.ImageAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageBuilderAssert assertThat(io.fabric8.openshift.api.model.ImageBuilder actual) {
    return new io.fabric8.openshift.api.model.ImageBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageChangeTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageChangeTriggerAssert assertThat(io.fabric8.openshift.api.model.ImageChangeTrigger actual) {
    return new io.fabric8.openshift.api.model.ImageChangeTriggerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageChangeTriggerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageChangeTriggerBuilderAssert assertThat(io.fabric8.openshift.api.model.ImageChangeTriggerBuilder actual) {
    return new io.fabric8.openshift.api.model.ImageChangeTriggerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageChangeTriggerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageChangeTriggerFluentAssert assertThat(io.fabric8.openshift.api.model.ImageChangeTriggerFluent actual) {
    return new io.fabric8.openshift.api.model.ImageChangeTriggerFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageFluentAssert assertThat(io.fabric8.openshift.api.model.ImageFluent actual) {
    return new io.fabric8.openshift.api.model.ImageFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageListAssert assertThat(io.fabric8.openshift.api.model.ImageList actual) {
    return new io.fabric8.openshift.api.model.ImageListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageListBuilderAssert assertThat(io.fabric8.openshift.api.model.ImageListBuilder actual) {
    return new io.fabric8.openshift.api.model.ImageListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageListFluentAssert assertThat(io.fabric8.openshift.api.model.ImageListFluent actual) {
    return new io.fabric8.openshift.api.model.ImageListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamAssert assertThat(io.fabric8.openshift.api.model.ImageStream actual) {
    return new io.fabric8.openshift.api.model.ImageStreamAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamBuilderAssert assertThat(io.fabric8.openshift.api.model.ImageStreamBuilder actual) {
    return new io.fabric8.openshift.api.model.ImageStreamBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamFluentAssert assertThat(io.fabric8.openshift.api.model.ImageStreamFluent actual) {
    return new io.fabric8.openshift.api.model.ImageStreamFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamListAssert assertThat(io.fabric8.openshift.api.model.ImageStreamList actual) {
    return new io.fabric8.openshift.api.model.ImageStreamListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamListBuilderAssert assertThat(io.fabric8.openshift.api.model.ImageStreamListBuilder actual) {
    return new io.fabric8.openshift.api.model.ImageStreamListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamListFluentAssert assertThat(io.fabric8.openshift.api.model.ImageStreamListFluent actual) {
    return new io.fabric8.openshift.api.model.ImageStreamListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamSpecAssert assertThat(io.fabric8.openshift.api.model.ImageStreamSpec actual) {
    return new io.fabric8.openshift.api.model.ImageStreamSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamSpecBuilderAssert assertThat(io.fabric8.openshift.api.model.ImageStreamSpecBuilder actual) {
    return new io.fabric8.openshift.api.model.ImageStreamSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamSpecFluentAssert assertThat(io.fabric8.openshift.api.model.ImageStreamSpecFluent actual) {
    return new io.fabric8.openshift.api.model.ImageStreamSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamStatusAssert assertThat(io.fabric8.openshift.api.model.ImageStreamStatus actual) {
    return new io.fabric8.openshift.api.model.ImageStreamStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamStatusBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamStatusBuilderAssert assertThat(io.fabric8.openshift.api.model.ImageStreamStatusBuilder actual) {
    return new io.fabric8.openshift.api.model.ImageStreamStatusBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamStatusFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamStatusFluentAssert assertThat(io.fabric8.openshift.api.model.ImageStreamStatusFluent actual) {
    return new io.fabric8.openshift.api.model.ImageStreamStatusFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.LifecycleHookAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.LifecycleHookAssert assertThat(io.fabric8.openshift.api.model.LifecycleHook actual) {
    return new io.fabric8.openshift.api.model.LifecycleHookAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.LifecycleHookBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.LifecycleHookBuilderAssert assertThat(io.fabric8.openshift.api.model.LifecycleHookBuilder actual) {
    return new io.fabric8.openshift.api.model.LifecycleHookBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.LifecycleHookFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.LifecycleHookFluentAssert assertThat(io.fabric8.openshift.api.model.LifecycleHookFluent actual) {
    return new io.fabric8.openshift.api.model.LifecycleHookFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedClusterRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedClusterRoleAssert assertThat(io.fabric8.openshift.api.model.NamedClusterRole actual) {
    return new io.fabric8.openshift.api.model.NamedClusterRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedClusterRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedClusterRoleBindingAssert assertThat(io.fabric8.openshift.api.model.NamedClusterRoleBinding actual) {
    return new io.fabric8.openshift.api.model.NamedClusterRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedClusterRoleBindingBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedClusterRoleBindingBuilderAssert assertThat(io.fabric8.openshift.api.model.NamedClusterRoleBindingBuilder actual) {
    return new io.fabric8.openshift.api.model.NamedClusterRoleBindingBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedClusterRoleBindingFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedClusterRoleBindingFluentAssert assertThat(io.fabric8.openshift.api.model.NamedClusterRoleBindingFluent actual) {
    return new io.fabric8.openshift.api.model.NamedClusterRoleBindingFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedClusterRoleBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedClusterRoleBuilderAssert assertThat(io.fabric8.openshift.api.model.NamedClusterRoleBuilder actual) {
    return new io.fabric8.openshift.api.model.NamedClusterRoleBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedClusterRoleFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedClusterRoleFluentAssert assertThat(io.fabric8.openshift.api.model.NamedClusterRoleFluent actual) {
    return new io.fabric8.openshift.api.model.NamedClusterRoleFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedRoleAssert assertThat(io.fabric8.openshift.api.model.NamedRole actual) {
    return new io.fabric8.openshift.api.model.NamedRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedRoleBindingAssert assertThat(io.fabric8.openshift.api.model.NamedRoleBinding actual) {
    return new io.fabric8.openshift.api.model.NamedRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedRoleBindingBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedRoleBindingBuilderAssert assertThat(io.fabric8.openshift.api.model.NamedRoleBindingBuilder actual) {
    return new io.fabric8.openshift.api.model.NamedRoleBindingBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedRoleBindingFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedRoleBindingFluentAssert assertThat(io.fabric8.openshift.api.model.NamedRoleBindingFluent actual) {
    return new io.fabric8.openshift.api.model.NamedRoleBindingFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedRoleBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedRoleBuilderAssert assertThat(io.fabric8.openshift.api.model.NamedRoleBuilder actual) {
    return new io.fabric8.openshift.api.model.NamedRoleBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedRoleFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedRoleFluentAssert assertThat(io.fabric8.openshift.api.model.NamedRoleFluent actual) {
    return new io.fabric8.openshift.api.model.NamedRoleFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedTagEventListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedTagEventListAssert assertThat(io.fabric8.openshift.api.model.NamedTagEventList actual) {
    return new io.fabric8.openshift.api.model.NamedTagEventListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedTagEventListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedTagEventListBuilderAssert assertThat(io.fabric8.openshift.api.model.NamedTagEventListBuilder actual) {
    return new io.fabric8.openshift.api.model.NamedTagEventListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedTagEventListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedTagEventListFluentAssert assertThat(io.fabric8.openshift.api.model.NamedTagEventListFluent actual) {
    return new io.fabric8.openshift.api.model.NamedTagEventListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedTagReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedTagReferenceAssert assertThat(io.fabric8.openshift.api.model.NamedTagReference actual) {
    return new io.fabric8.openshift.api.model.NamedTagReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedTagReferenceBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedTagReferenceBuilderAssert assertThat(io.fabric8.openshift.api.model.NamedTagReferenceBuilder actual) {
    return new io.fabric8.openshift.api.model.NamedTagReferenceBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedTagReferenceFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedTagReferenceFluentAssert assertThat(io.fabric8.openshift.api.model.NamedTagReferenceFluent actual) {
    return new io.fabric8.openshift.api.model.NamedTagReferenceFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAccessTokenAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAccessTokenAssert assertThat(io.fabric8.openshift.api.model.OAuthAccessToken actual) {
    return new io.fabric8.openshift.api.model.OAuthAccessTokenAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAccessTokenBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAccessTokenBuilderAssert assertThat(io.fabric8.openshift.api.model.OAuthAccessTokenBuilder actual) {
    return new io.fabric8.openshift.api.model.OAuthAccessTokenBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAccessTokenFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAccessTokenFluentAssert assertThat(io.fabric8.openshift.api.model.OAuthAccessTokenFluent actual) {
    return new io.fabric8.openshift.api.model.OAuthAccessTokenFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAccessTokenListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAccessTokenListAssert assertThat(io.fabric8.openshift.api.model.OAuthAccessTokenList actual) {
    return new io.fabric8.openshift.api.model.OAuthAccessTokenListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAccessTokenListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAccessTokenListBuilderAssert assertThat(io.fabric8.openshift.api.model.OAuthAccessTokenListBuilder actual) {
    return new io.fabric8.openshift.api.model.OAuthAccessTokenListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAccessTokenListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAccessTokenListFluentAssert assertThat(io.fabric8.openshift.api.model.OAuthAccessTokenListFluent actual) {
    return new io.fabric8.openshift.api.model.OAuthAccessTokenListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAuthorizeTokenAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAuthorizeTokenAssert assertThat(io.fabric8.openshift.api.model.OAuthAuthorizeToken actual) {
    return new io.fabric8.openshift.api.model.OAuthAuthorizeTokenAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilderAssert assertThat(io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilder actual) {
    return new io.fabric8.openshift.api.model.OAuthAuthorizeTokenBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluentAssert assertThat(io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluent actual) {
    return new io.fabric8.openshift.api.model.OAuthAuthorizeTokenFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAuthorizeTokenListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAuthorizeTokenListAssert assertThat(io.fabric8.openshift.api.model.OAuthAuthorizeTokenList actual) {
    return new io.fabric8.openshift.api.model.OAuthAuthorizeTokenListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAuthorizeTokenListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAuthorizeTokenListBuilderAssert assertThat(io.fabric8.openshift.api.model.OAuthAuthorizeTokenListBuilder actual) {
    return new io.fabric8.openshift.api.model.OAuthAuthorizeTokenListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAuthorizeTokenListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAuthorizeTokenListFluentAssert assertThat(io.fabric8.openshift.api.model.OAuthAuthorizeTokenListFluent actual) {
    return new io.fabric8.openshift.api.model.OAuthAuthorizeTokenListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientAssert assertThat(io.fabric8.openshift.api.model.OAuthClient actual) {
    return new io.fabric8.openshift.api.model.OAuthClientAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientAuthorizationAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientAuthorizationAssert assertThat(io.fabric8.openshift.api.model.OAuthClientAuthorization actual) {
    return new io.fabric8.openshift.api.model.OAuthClientAuthorizationAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilderAssert assertThat(io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilder actual) {
    return new io.fabric8.openshift.api.model.OAuthClientAuthorizationBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientAuthorizationFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientAuthorizationFluentAssert assertThat(io.fabric8.openshift.api.model.OAuthClientAuthorizationFluent actual) {
    return new io.fabric8.openshift.api.model.OAuthClientAuthorizationFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientAuthorizationListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientAuthorizationListAssert assertThat(io.fabric8.openshift.api.model.OAuthClientAuthorizationList actual) {
    return new io.fabric8.openshift.api.model.OAuthClientAuthorizationListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientAuthorizationListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientAuthorizationListBuilderAssert assertThat(io.fabric8.openshift.api.model.OAuthClientAuthorizationListBuilder actual) {
    return new io.fabric8.openshift.api.model.OAuthClientAuthorizationListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientAuthorizationListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientAuthorizationListFluentAssert assertThat(io.fabric8.openshift.api.model.OAuthClientAuthorizationListFluent actual) {
    return new io.fabric8.openshift.api.model.OAuthClientAuthorizationListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientBuilderAssert assertThat(io.fabric8.openshift.api.model.OAuthClientBuilder actual) {
    return new io.fabric8.openshift.api.model.OAuthClientBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientFluentAssert assertThat(io.fabric8.openshift.api.model.OAuthClientFluent actual) {
    return new io.fabric8.openshift.api.model.OAuthClientFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientListAssert assertThat(io.fabric8.openshift.api.model.OAuthClientList actual) {
    return new io.fabric8.openshift.api.model.OAuthClientListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientListBuilderAssert assertThat(io.fabric8.openshift.api.model.OAuthClientListBuilder actual) {
    return new io.fabric8.openshift.api.model.OAuthClientListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientListFluentAssert assertThat(io.fabric8.openshift.api.model.OAuthClientListFluent actual) {
    return new io.fabric8.openshift.api.model.OAuthClientListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ParameterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ParameterAssert assertThat(io.fabric8.openshift.api.model.Parameter actual) {
    return new io.fabric8.openshift.api.model.ParameterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ParameterBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ParameterBuilderAssert assertThat(io.fabric8.openshift.api.model.ParameterBuilder actual) {
    return new io.fabric8.openshift.api.model.ParameterBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ParameterFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ParameterFluentAssert assertThat(io.fabric8.openshift.api.model.ParameterFluent actual) {
    return new io.fabric8.openshift.api.model.ParameterFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyAssert assertThat(io.fabric8.openshift.api.model.Policy actual) {
    return new io.fabric8.openshift.api.model.PolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyBindingAssert assertThat(io.fabric8.openshift.api.model.PolicyBinding actual) {
    return new io.fabric8.openshift.api.model.PolicyBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyBindingBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyBindingBuilderAssert assertThat(io.fabric8.openshift.api.model.PolicyBindingBuilder actual) {
    return new io.fabric8.openshift.api.model.PolicyBindingBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyBindingFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyBindingFluentAssert assertThat(io.fabric8.openshift.api.model.PolicyBindingFluent actual) {
    return new io.fabric8.openshift.api.model.PolicyBindingFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyBindingListAssert assertThat(io.fabric8.openshift.api.model.PolicyBindingList actual) {
    return new io.fabric8.openshift.api.model.PolicyBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyBindingListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyBindingListBuilderAssert assertThat(io.fabric8.openshift.api.model.PolicyBindingListBuilder actual) {
    return new io.fabric8.openshift.api.model.PolicyBindingListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyBindingListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyBindingListFluentAssert assertThat(io.fabric8.openshift.api.model.PolicyBindingListFluent actual) {
    return new io.fabric8.openshift.api.model.PolicyBindingListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyBuilderAssert assertThat(io.fabric8.openshift.api.model.PolicyBuilder actual) {
    return new io.fabric8.openshift.api.model.PolicyBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyFluentAssert assertThat(io.fabric8.openshift.api.model.PolicyFluent actual) {
    return new io.fabric8.openshift.api.model.PolicyFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyListAssert assertThat(io.fabric8.openshift.api.model.PolicyList actual) {
    return new io.fabric8.openshift.api.model.PolicyListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyListBuilderAssert assertThat(io.fabric8.openshift.api.model.PolicyListBuilder actual) {
    return new io.fabric8.openshift.api.model.PolicyListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyListFluentAssert assertThat(io.fabric8.openshift.api.model.PolicyListFluent actual) {
    return new io.fabric8.openshift.api.model.PolicyListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyRuleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyRuleAssert assertThat(io.fabric8.openshift.api.model.PolicyRule actual) {
    return new io.fabric8.openshift.api.model.PolicyRuleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyRuleBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyRuleBuilderAssert assertThat(io.fabric8.openshift.api.model.PolicyRuleBuilder actual) {
    return new io.fabric8.openshift.api.model.PolicyRuleBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyRuleFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyRuleFluentAssert assertThat(io.fabric8.openshift.api.model.PolicyRuleFluent actual) {
    return new io.fabric8.openshift.api.model.PolicyRuleFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.RecreateDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsBuilderAssert assertThat(io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsBuilder actual) {
    return new io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsFluentAssert assertThat(io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsFluent actual) {
    return new io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleAssert assertThat(io.fabric8.openshift.api.model.Role actual) {
    return new io.fabric8.openshift.api.model.RoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleBindingAssert assertThat(io.fabric8.openshift.api.model.RoleBinding actual) {
    return new io.fabric8.openshift.api.model.RoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleBindingBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleBindingBuilderAssert assertThat(io.fabric8.openshift.api.model.RoleBindingBuilder actual) {
    return new io.fabric8.openshift.api.model.RoleBindingBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleBindingFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleBindingFluentAssert assertThat(io.fabric8.openshift.api.model.RoleBindingFluent actual) {
    return new io.fabric8.openshift.api.model.RoleBindingFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleBindingListAssert assertThat(io.fabric8.openshift.api.model.RoleBindingList actual) {
    return new io.fabric8.openshift.api.model.RoleBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleBindingListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleBindingListBuilderAssert assertThat(io.fabric8.openshift.api.model.RoleBindingListBuilder actual) {
    return new io.fabric8.openshift.api.model.RoleBindingListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleBindingListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleBindingListFluentAssert assertThat(io.fabric8.openshift.api.model.RoleBindingListFluent actual) {
    return new io.fabric8.openshift.api.model.RoleBindingListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleBuilderAssert assertThat(io.fabric8.openshift.api.model.RoleBuilder actual) {
    return new io.fabric8.openshift.api.model.RoleBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleFluentAssert assertThat(io.fabric8.openshift.api.model.RoleFluent actual) {
    return new io.fabric8.openshift.api.model.RoleFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleListAssert assertThat(io.fabric8.openshift.api.model.RoleList actual) {
    return new io.fabric8.openshift.api.model.RoleListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleListBuilderAssert assertThat(io.fabric8.openshift.api.model.RoleListBuilder actual) {
    return new io.fabric8.openshift.api.model.RoleListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleListFluentAssert assertThat(io.fabric8.openshift.api.model.RoleListFluent actual) {
    return new io.fabric8.openshift.api.model.RoleListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.RollingDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsBuilderAssert assertThat(io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsBuilder actual) {
    return new io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluentAssert assertThat(io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluent actual) {
    return new io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteAssert assertThat(io.fabric8.openshift.api.model.Route actual) {
    return new io.fabric8.openshift.api.model.RouteAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteBuilderAssert assertThat(io.fabric8.openshift.api.model.RouteBuilder actual) {
    return new io.fabric8.openshift.api.model.RouteBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteFluentAssert assertThat(io.fabric8.openshift.api.model.RouteFluent actual) {
    return new io.fabric8.openshift.api.model.RouteFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteListAssert assertThat(io.fabric8.openshift.api.model.RouteList actual) {
    return new io.fabric8.openshift.api.model.RouteListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteListBuilderAssert assertThat(io.fabric8.openshift.api.model.RouteListBuilder actual) {
    return new io.fabric8.openshift.api.model.RouteListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteListFluentAssert assertThat(io.fabric8.openshift.api.model.RouteListFluent actual) {
    return new io.fabric8.openshift.api.model.RouteListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteSpecAssert assertThat(io.fabric8.openshift.api.model.RouteSpec actual) {
    return new io.fabric8.openshift.api.model.RouteSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteSpecBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteSpecBuilderAssert assertThat(io.fabric8.openshift.api.model.RouteSpecBuilder actual) {
    return new io.fabric8.openshift.api.model.RouteSpecBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteSpecFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteSpecFluentAssert assertThat(io.fabric8.openshift.api.model.RouteSpecFluent actual) {
    return new io.fabric8.openshift.api.model.RouteSpecFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteStatusAssert assertThat(io.fabric8.openshift.api.model.RouteStatus actual) {
    return new io.fabric8.openshift.api.model.RouteStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.SourceBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.SourceBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceBuildStrategyBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceBuildStrategyBuilderAssert assertThat(io.fabric8.openshift.api.model.SourceBuildStrategyBuilder actual) {
    return new io.fabric8.openshift.api.model.SourceBuildStrategyBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceBuildStrategyFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceBuildStrategyFluentAssert assertThat(io.fabric8.openshift.api.model.SourceBuildStrategyFluent actual) {
    return new io.fabric8.openshift.api.model.SourceBuildStrategyFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceControlUserAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceControlUserAssert assertThat(io.fabric8.openshift.api.model.SourceControlUser actual) {
    return new io.fabric8.openshift.api.model.SourceControlUserAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceControlUserBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceControlUserBuilderAssert assertThat(io.fabric8.openshift.api.model.SourceControlUserBuilder actual) {
    return new io.fabric8.openshift.api.model.SourceControlUserBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceControlUserFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceControlUserFluentAssert assertThat(io.fabric8.openshift.api.model.SourceControlUserFluent actual) {
    return new io.fabric8.openshift.api.model.SourceControlUserFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceRevisionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceRevisionAssert assertThat(io.fabric8.openshift.api.model.SourceRevision actual) {
    return new io.fabric8.openshift.api.model.SourceRevisionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceRevisionBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceRevisionBuilderAssert assertThat(io.fabric8.openshift.api.model.SourceRevisionBuilder actual) {
    return new io.fabric8.openshift.api.model.SourceRevisionBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceRevisionFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceRevisionFluentAssert assertThat(io.fabric8.openshift.api.model.SourceRevisionFluent actual) {
    return new io.fabric8.openshift.api.model.SourceRevisionFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TLSConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TLSConfigAssert assertThat(io.fabric8.openshift.api.model.TLSConfig actual) {
    return new io.fabric8.openshift.api.model.TLSConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TLSConfigBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TLSConfigBuilderAssert assertThat(io.fabric8.openshift.api.model.TLSConfigBuilder actual) {
    return new io.fabric8.openshift.api.model.TLSConfigBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TLSConfigFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TLSConfigFluentAssert assertThat(io.fabric8.openshift.api.model.TLSConfigFluent actual) {
    return new io.fabric8.openshift.api.model.TLSConfigFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagEventAssert assertThat(io.fabric8.openshift.api.model.TagEvent actual) {
    return new io.fabric8.openshift.api.model.TagEventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagEventBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagEventBuilderAssert assertThat(io.fabric8.openshift.api.model.TagEventBuilder actual) {
    return new io.fabric8.openshift.api.model.TagEventBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagEventFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagEventFluentAssert assertThat(io.fabric8.openshift.api.model.TagEventFluent actual) {
    return new io.fabric8.openshift.api.model.TagEventFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TemplateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TemplateAssert assertThat(io.fabric8.openshift.api.model.Template actual) {
    return new io.fabric8.openshift.api.model.TemplateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TemplateBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TemplateBuilderAssert assertThat(io.fabric8.openshift.api.model.TemplateBuilder actual) {
    return new io.fabric8.openshift.api.model.TemplateBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TemplateFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TemplateFluentAssert assertThat(io.fabric8.openshift.api.model.TemplateFluent actual) {
    return new io.fabric8.openshift.api.model.TemplateFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TemplateListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TemplateListAssert assertThat(io.fabric8.openshift.api.model.TemplateList actual) {
    return new io.fabric8.openshift.api.model.TemplateListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TemplateListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TemplateListBuilderAssert assertThat(io.fabric8.openshift.api.model.TemplateListBuilder actual) {
    return new io.fabric8.openshift.api.model.TemplateListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TemplateListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TemplateListFluentAssert assertThat(io.fabric8.openshift.api.model.TemplateListFluent actual) {
    return new io.fabric8.openshift.api.model.TemplateListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.UserAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.UserAssert assertThat(io.fabric8.openshift.api.model.User actual) {
    return new io.fabric8.openshift.api.model.UserAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.UserBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.UserBuilderAssert assertThat(io.fabric8.openshift.api.model.UserBuilder actual) {
    return new io.fabric8.openshift.api.model.UserBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.UserFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.UserFluentAssert assertThat(io.fabric8.openshift.api.model.UserFluent actual) {
    return new io.fabric8.openshift.api.model.UserFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.UserListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.UserListAssert assertThat(io.fabric8.openshift.api.model.UserList actual) {
    return new io.fabric8.openshift.api.model.UserListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.UserListBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.UserListBuilderAssert assertThat(io.fabric8.openshift.api.model.UserListBuilder actual) {
    return new io.fabric8.openshift.api.model.UserListBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.UserListFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.UserListFluentAssert assertThat(io.fabric8.openshift.api.model.UserListFluent actual) {
    return new io.fabric8.openshift.api.model.UserListFluentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.WebHookTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.WebHookTriggerAssert assertThat(io.fabric8.openshift.api.model.WebHookTrigger actual) {
    return new io.fabric8.openshift.api.model.WebHookTriggerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.WebHookTriggerBuilderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.WebHookTriggerBuilderAssert assertThat(io.fabric8.openshift.api.model.WebHookTriggerBuilder actual) {
    return new io.fabric8.openshift.api.model.WebHookTriggerBuilderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.WebHookTriggerFluentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.WebHookTriggerFluentAssert assertThat(io.fabric8.openshift.api.model.WebHookTriggerFluent actual) {
    return new io.fabric8.openshift.api.model.WebHookTriggerFluentAssert(actual);
  }

  /**
   * Creates a new <code>{@link Assertions}</code>.
   */
  protected Assertions() {
    // empty
  }
}
