package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link EventSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEventSourceAssert<S extends AbstractEventSourceAssert<S, A>, A extends EventSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEventSourceAssert}</code> to make assertions on actual EventSource.
   * @param actual the EventSource we want to make assertions on.
   */
  protected AbstractEventSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual EventSource's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual EventSource's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EventSource's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual EventSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EventSource's component is equal to the given one.
   * @param component the given component to compare the actual EventSource's component to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EventSource's component is not equal to the given one.
   */
  public S hasComponent(String component) {
    // check that actual EventSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected component of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualComponent = actual.getComponent();
    if (!Objects.areEqual(actualComponent, component)) {
      failWithMessage(assertjErrorMessage, actual, component, actualComponent);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual EventSource's host is equal to the given one.
   * @param host the given host to compare the actual EventSource's host to.
   * @return this assertion object.
   * @throws AssertionError - if the actual EventSource's host is not equal to the given one.
   */
  public S hasHost(String host) {
    // check that actual EventSource we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected host of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHost = actual.getHost();
    if (!Objects.areEqual(actualHost, host)) {
      failWithMessage(assertjErrorMessage, actual, host, actualHost);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
