package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link GitBuildSourceFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGitBuildSourceFluentAssert<S extends AbstractGitBuildSourceFluentAssert<S, A>, A extends GitBuildSourceFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGitBuildSourceFluentAssert}</code> to make assertions on actual GitBuildSourceFluent.
   * @param actual the GitBuildSourceFluent we want to make assertions on.
   */
  protected AbstractGitBuildSourceFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual GitBuildSourceFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual GitBuildSourceFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitBuildSourceFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual GitBuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GitBuildSourceFluent's httpProxy is equal to the given one.
   * @param httpProxy the given httpProxy to compare the actual GitBuildSourceFluent's httpProxy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitBuildSourceFluent's httpProxy is not equal to the given one.
   */
  public S hasHttpProxy(String httpProxy) {
    // check that actual GitBuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected httpProxy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHttpProxy = actual.getHttpProxy();
    if (!Objects.areEqual(actualHttpProxy, httpProxy)) {
      failWithMessage(assertjErrorMessage, actual, httpProxy, actualHttpProxy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GitBuildSourceFluent's httpsProxy is equal to the given one.
   * @param httpsProxy the given httpsProxy to compare the actual GitBuildSourceFluent's httpsProxy to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitBuildSourceFluent's httpsProxy is not equal to the given one.
   */
  public S hasHttpsProxy(String httpsProxy) {
    // check that actual GitBuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected httpsProxy of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualHttpsProxy = actual.getHttpsProxy();
    if (!Objects.areEqual(actualHttpsProxy, httpsProxy)) {
      failWithMessage(assertjErrorMessage, actual, httpsProxy, actualHttpsProxy);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GitBuildSourceFluent's ref is equal to the given one.
   * @param ref the given ref to compare the actual GitBuildSourceFluent's ref to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitBuildSourceFluent's ref is not equal to the given one.
   */
  public S hasRef(String ref) {
    // check that actual GitBuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected ref of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualRef = actual.getRef();
    if (!Objects.areEqual(actualRef, ref)) {
      failWithMessage(assertjErrorMessage, actual, ref, actualRef);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GitBuildSourceFluent's uri is equal to the given one.
   * @param uri the given uri to compare the actual GitBuildSourceFluent's uri to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitBuildSourceFluent's uri is not equal to the given one.
   */
  public S hasUri(String uri) {
    // check that actual GitBuildSourceFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected uri of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualUri = actual.getUri();
    if (!Objects.areEqual(actualUri, uri)) {
      failWithMessage(assertjErrorMessage, actual, uri, actualUri);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
