package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link RootPaths} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRootPathsAssert<S extends AbstractRootPathsAssert<S, A>, A extends RootPaths> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRootPathsAssert}</code> to make assertions on actual RootPaths.
   * @param actual the RootPaths we want to make assertions on.
   */
  protected AbstractRootPathsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual RootPaths's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual RootPaths's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RootPaths's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual RootPaths we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RootPaths's paths contains the given String elements.
   * @param paths the given elements that should be contained in actual RootPaths's paths.
   * @return this assertion object.
   * @throws AssertionError if the actual RootPaths's paths does not contain all given String elements.
   */
  public S hasPaths(String... paths) {
    // check that actual RootPaths we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (paths == null) throw new AssertionError("Expecting paths parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getPaths(), paths);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual RootPaths has no paths.
   * @return this assertion object.
   * @throws AssertionError if the actual RootPaths's paths is not empty.
   */
  public S hasNoPaths() {
    // check that actual RootPaths we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have paths but had :\n  <%s>";
    
    // check
    if (actual.getPaths().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getPaths());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

}
