package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NamespaceStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamespaceStatusAssert<S extends AbstractNamespaceStatusAssert<S, A>, A extends NamespaceStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamespaceStatusAssert}</code> to make assertions on actual NamespaceStatus.
   * @param actual the NamespaceStatus we want to make assertions on.
   */
  protected AbstractNamespaceStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NamespaceStatus's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NamespaceStatus's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamespaceStatus's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NamespaceStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamespaceStatus's phase is equal to the given one.
   * @param phase the given phase to compare the actual NamespaceStatus's phase to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamespaceStatus's phase is not equal to the given one.
   */
  public S hasPhase(String phase) {
    // check that actual NamespaceStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected phase of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualPhase = actual.getPhase();
    if (!Objects.areEqual(actualPhase, phase)) {
      failWithMessage(assertjErrorMessage, actual, phase, actualPhase);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
