/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventSource;
import io.fabric8.kubernetes.api.model.EventSourceBuilder;
import io.fabric8.kubernetes.api.model.EventSourceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import java.util.HashMap;
import java.util.Map;

public class EventFluent<T extends EventFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    Event.ApiVersion apiVersion;
    Integer count;
    String firstTimestamp;
    VisitableBuilder<ObjectReference, ?> involvedObject;
    String kind;
    String lastTimestamp;
    String message;
    VisitableBuilder<ObjectMeta, ?> metadata;
    String reason;
    VisitableBuilder<EventSource, ?> source;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public Event.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(Event.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public Integer getCount() {
        return this.count;
    }

    public T withCount(Integer count) {
        this.count = count;
        return (T)((Object)this);
    }

    public String getFirstTimestamp() {
        return this.firstTimestamp;
    }

    public T withFirstTimestamp(String firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
        return (T)((Object)this);
    }

    public ObjectReference getInvolvedObject() {
        return this.involvedObject != null ? (ObjectReference)this.involvedObject.build() : null;
    }

    public T withInvolvedObject(ObjectReference involvedObject) {
        if (involvedObject != null) {
            this.involvedObject = new ObjectReferenceBuilder(involvedObject);
            this._visitables.add(this.involvedObject);
        }
        return (T)((Object)this);
    }

    public InvolvedObjectNested<T> withNewInvolvedObject() {
        return new InvolvedObjectNested();
    }

    public InvolvedObjectNested<T> withNewInvolvedObjectLike(ObjectReference item) {
        return new InvolvedObjectNested(item);
    }

    public InvolvedObjectNested<T> editInvolvedObject() {
        return this.withNewInvolvedObjectLike(this.getInvolvedObject());
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)((Object)this);
    }

    public String getLastTimestamp() {
        return this.lastTimestamp;
    }

    public T withLastTimestamp(String lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
        return (T)((Object)this);
    }

    public String getMessage() {
        return this.message;
    }

    public T withMessage(String message) {
        this.message = message;
        return (T)((Object)this);
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)((Object)this);
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public String getReason() {
        return this.reason;
    }

    public T withReason(String reason) {
        this.reason = reason;
        return (T)((Object)this);
    }

    public EventSource getSource() {
        return this.source != null ? (EventSource)this.source.build() : null;
    }

    public T withSource(EventSource source) {
        if (source != null) {
            this.source = new EventSourceBuilder(source);
            this._visitables.add(this.source);
        }
        return (T)((Object)this);
    }

    public SourceNested<T> withNewSource() {
        return new SourceNested();
    }

    public SourceNested<T> withNewSourceLike(EventSource item) {
        return new SourceNested(item);
    }

    public SourceNested<T> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    public T withNewSource(String component, String host) {
        return this.withSource(new EventSource(component, host));
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EventFluent that = (EventFluent)((Object)o);
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.count != null ? !this.count.equals(that.count) : that.count != null) {
            return false;
        }
        if (this.firstTimestamp != null ? !this.firstTimestamp.equals(that.firstTimestamp) : that.firstTimestamp != null) {
            return false;
        }
        if (this.involvedObject != null ? !this.involvedObject.equals(that.involvedObject) : that.involvedObject != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastTimestamp != null ? !this.lastTimestamp.equals(that.lastTimestamp) : that.lastTimestamp != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SourceNested<N>
    extends EventSourceFluent<SourceNested<N>>
    implements Nested<N> {
        private final EventSourceBuilder builder;

        SourceNested() {
            this.builder = new EventSourceBuilder(this);
        }

        SourceNested(EventSource item) {
            this.builder = new EventSourceBuilder(this, item);
        }

        public N and() {
            return (N)EventFluent.this.withSource(this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        public N and() {
            return (N)EventFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class InvolvedObjectNested<N>
    extends ObjectReferenceFluent<InvolvedObjectNested<N>>
    implements Nested<N> {
        private final ObjectReferenceBuilder builder;

        InvolvedObjectNested() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        InvolvedObjectNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)EventFluent.this.withInvolvedObject(this.builder.build());
        }

        public N endInvolvedObject() {
            return this.and();
        }
    }
}

