/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.Preferences;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractConfigAssert<S extends AbstractConfigAssert<S, A>, A extends Config>
extends AbstractAssert<S, A> {
    protected AbstractConfigAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((Config)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractConfigAssert)this.myself));
    }

    public S hasApiVersion(String apiVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualApiVersion = ((Config)this.actual).getApiVersion();
        if (!Objects.areEqual((Object)actualApiVersion, (Object)apiVersion)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, apiVersion, actualApiVersion});
        }
        return (S)((Object)((AbstractConfigAssert)this.myself));
    }

    public S hasClusters(NamedCluster ... clusters) {
        this.isNotNull();
        if (clusters == null) {
            throw new AssertionError((Object)"Expecting clusters parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((Config)this.actual).getClusters(), (Object[])clusters);
        return (S)((Object)((AbstractConfigAssert)this.myself));
    }

    public S hasNoClusters() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have clusters but had :\n  <%s>";
        if (((Config)this.actual).getClusters().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Config)this.actual).getClusters()});
        }
        return (S)((Object)((AbstractConfigAssert)this.myself));
    }

    public S hasContexts(NamedContext ... contexts) {
        this.isNotNull();
        if (contexts == null) {
            throw new AssertionError((Object)"Expecting contexts parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((Config)this.actual).getContexts(), (Object[])contexts);
        return (S)((Object)((AbstractConfigAssert)this.myself));
    }

    public S hasNoContexts() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have contexts but had :\n  <%s>";
        if (((Config)this.actual).getContexts().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Config)this.actual).getContexts()});
        }
        return (S)((Object)((AbstractConfigAssert)this.myself));
    }

    public S hasCurrentContext(String currentContext) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected currentContext of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualCurrentContext = ((Config)this.actual).getCurrentContext();
        if (!Objects.areEqual((Object)actualCurrentContext, (Object)currentContext)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, currentContext, actualCurrentContext});
        }
        return (S)((Object)((AbstractConfigAssert)this.myself));
    }

    public S hasExtensions(NamedExtension ... extensions) {
        this.isNotNull();
        if (extensions == null) {
            throw new AssertionError((Object)"Expecting extensions parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((Config)this.actual).getExtensions(), (Object[])extensions);
        return (S)((Object)((AbstractConfigAssert)this.myself));
    }

    public S hasNoExtensions() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have extensions but had :\n  <%s>";
        if (((Config)this.actual).getExtensions().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Config)this.actual).getExtensions()});
        }
        return (S)((Object)((AbstractConfigAssert)this.myself));
    }

    public S hasKind(String kind) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualKind = ((Config)this.actual).getKind();
        if (!Objects.areEqual((Object)actualKind, (Object)kind)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, kind, actualKind});
        }
        return (S)((Object)((AbstractConfigAssert)this.myself));
    }

    public S hasPreferences(Preferences preferences) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected preferences of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Preferences actualPreferences = ((Config)this.actual).getPreferences();
        if (!Objects.areEqual((Object)actualPreferences, (Object)preferences)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, preferences, actualPreferences});
        }
        return (S)((Object)((AbstractConfigAssert)this.myself));
    }

    public S hasUsers(NamedAuthInfo ... users) {
        this.isNotNull();
        if (users == null) {
            throw new AssertionError((Object)"Expecting users parameter not to be null.");
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((Config)this.actual).getUsers(), (Object[])users);
        return (S)((Object)((AbstractConfigAssert)this.myself));
    }

    public S hasNoUsers() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have users but had :\n  <%s>";
        if (((Config)this.actual).getUsers().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Config)this.actual).getUsers()});
        }
        return (S)((Object)((AbstractConfigAssert)this.myself));
    }
}

