package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link GitSourceRevisionFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGitSourceRevisionFluentAssert<S extends AbstractGitSourceRevisionFluentAssert<S, A>, A extends GitSourceRevisionFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGitSourceRevisionFluentAssert}</code> to make assertions on actual GitSourceRevisionFluent.
   * @param actual the GitSourceRevisionFluent we want to make assertions on.
   */
  protected AbstractGitSourceRevisionFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual GitSourceRevisionFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual GitSourceRevisionFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitSourceRevisionFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual GitSourceRevisionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GitSourceRevisionFluent's author is equal to the given one.
   * @param author the given author to compare the actual GitSourceRevisionFluent's author to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitSourceRevisionFluent's author is not equal to the given one.
   */
  public S hasAuthor(SourceControlUser author) {
    // check that actual GitSourceRevisionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected author of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SourceControlUser actualAuthor = actual.getAuthor();
    if (!Objects.areEqual(actualAuthor, author)) {
      failWithMessage(assertjErrorMessage, actual, author, actualAuthor);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GitSourceRevisionFluent's commit is equal to the given one.
   * @param commit the given commit to compare the actual GitSourceRevisionFluent's commit to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitSourceRevisionFluent's commit is not equal to the given one.
   */
  public S hasCommit(String commit) {
    // check that actual GitSourceRevisionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected commit of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualCommit = actual.getCommit();
    if (!Objects.areEqual(actualCommit, commit)) {
      failWithMessage(assertjErrorMessage, actual, commit, actualCommit);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GitSourceRevisionFluent's committer is equal to the given one.
   * @param committer the given committer to compare the actual GitSourceRevisionFluent's committer to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitSourceRevisionFluent's committer is not equal to the given one.
   */
  public S hasCommitter(SourceControlUser committer) {
    // check that actual GitSourceRevisionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected committer of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    SourceControlUser actualCommitter = actual.getCommitter();
    if (!Objects.areEqual(actualCommitter, committer)) {
      failWithMessage(assertjErrorMessage, actual, committer, actualCommitter);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual GitSourceRevisionFluent's message is equal to the given one.
   * @param message the given message to compare the actual GitSourceRevisionFluent's message to.
   * @return this assertion object.
   * @throws AssertionError - if the actual GitSourceRevisionFluent's message is not equal to the given one.
   */
  public S hasMessage(String message) {
    // check that actual GitSourceRevisionFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected message of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualMessage = actual.getMessage();
    if (!Objects.areEqual(actualMessage, message)) {
      failWithMessage(assertjErrorMessage, actual, message, actualMessage);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
