package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link OAuthClientFluent} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractOAuthClientFluentAssert<S extends AbstractOAuthClientFluentAssert<S, A>, A extends OAuthClientFluent> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractOAuthClientFluentAssert}</code> to make assertions on actual OAuthClientFluent.
   * @param actual the OAuthClientFluent we want to make assertions on.
   */
  protected AbstractOAuthClientFluentAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual OAuthClientFluent's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual OAuthClientFluent's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthClientFluent's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual OAuthClientFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthClientFluent's apiVersion is equal to the given one.
   * @param apiVersion the given apiVersion to compare the actual OAuthClientFluent's apiVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthClientFluent's apiVersion is not equal to the given one.
   */
  public S hasApiVersion(OAuthClient.ApiVersion apiVersion) {
    // check that actual OAuthClientFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    OAuthClient.ApiVersion actualApiVersion = actual.getApiVersion();
    if (!Objects.areEqual(actualApiVersion, apiVersion)) {
      failWithMessage(assertjErrorMessage, actual, apiVersion, actualApiVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthClientFluent's kind is equal to the given one.
   * @param kind the given kind to compare the actual OAuthClientFluent's kind to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthClientFluent's kind is not equal to the given one.
   */
  public S hasKind(String kind) {
    // check that actual OAuthClientFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualKind = actual.getKind();
    if (!Objects.areEqual(actualKind, kind)) {
      failWithMessage(assertjErrorMessage, actual, kind, actualKind);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthClientFluent's metadata is equal to the given one.
   * @param metadata the given metadata to compare the actual OAuthClientFluent's metadata to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthClientFluent's metadata is not equal to the given one.
   */
  public S hasMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    // check that actual OAuthClientFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectMeta actualMetadata = actual.getMetadata();
    if (!Objects.areEqual(actualMetadata, metadata)) {
      failWithMessage(assertjErrorMessage, actual, metadata, actualMetadata);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthClientFluent's redirectURIs contains the given String elements.
   * @param redirectURIs the given elements that should be contained in actual OAuthClientFluent's redirectURIs.
   * @return this assertion object.
   * @throws AssertionError if the actual OAuthClientFluent's redirectURIs does not contain all given String elements.
   */
  public S hasRedirectURIs(String... redirectURIs) {
    // check that actual OAuthClientFluent we want to make assertions on is not null.
    isNotNull();

    // check that given String varargs is not null.
    if (redirectURIs == null) throw new AssertionError("Expecting redirectURIs parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getRedirectURIs(), redirectURIs);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual OAuthClientFluent has no redirectURIs.
   * @return this assertion object.
   * @throws AssertionError if the actual OAuthClientFluent's redirectURIs is not empty.
   */
  public S hasNoRedirectURIs() {
    // check that actual OAuthClientFluent we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have redirectURIs but had :\n  <%s>";
    
    // check
    if (actual.getRedirectURIs().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getRedirectURIs());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual OAuthClientFluent's secret is equal to the given one.
   * @param secret the given secret to compare the actual OAuthClientFluent's secret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual OAuthClientFluent's secret is not equal to the given one.
   */
  public S hasSecret(String secret) {
    // check that actual OAuthClientFluent we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected secret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualSecret = actual.getSecret();
    if (!Objects.areEqual(actualSecret, secret)) {
      failWithMessage(assertjErrorMessage, actual, secret, actualSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
