/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPodSelectionAssert {
    private static final transient Logger LOG = LoggerFactory.getLogger(AbstractPodSelectionAssert.class);
    public static final String PROPERTY_ASSERT_NOT_READY_TIMEOUT_MILLIS = "fabric8.assert.notReadyTimeoutMills";
    public static final String PROPERTY_ASSERT_READY_PERIOD_MILLIS = "fabric8.assert.readyPeriodMills";
    public static final long DEFAULT_NOT_READY_TIMEOUT_MS = 300000L;
    public static final long DEFAULT_READY_PERIOD_MS = 10000L;

    public static long getDefaultReadyPeriodMs() {
        return AbstractPodSelectionAssert.parseLongValue(Systems.getEnvVarOrSystemProperty((String)PROPERTY_ASSERT_READY_PERIOD_MILLIS), 10000L);
    }

    public static long getDefaultNotReadyTimeoutMs() {
        return AbstractPodSelectionAssert.parseLongValue(Systems.getEnvVarOrSystemProperty((String)PROPERTY_ASSERT_NOT_READY_TIMEOUT_MILLIS), 300000L);
    }

    private static long parseLongValue(String text, long defaultValue) {
        if (Strings.isNotBlank((String)text)) {
            try {
                return Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                LOG.warn("Could not parse long value " + text + ": " + e, (Throwable)e);
            }
        }
        return defaultValue;
    }

    public AbstractPodSelectionAssert isPodReadyForPeriod() {
        return this.isPodReadyForPeriod(AbstractPodSelectionAssert.getDefaultNotReadyTimeoutMs(), AbstractPodSelectionAssert.getDefaultReadyPeriodMs());
    }

    public abstract AbstractPodSelectionAssert isPodReadyForPeriod(long var1, long var3);

    public abstract List<Pod> getPods();
}

