package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link SecretSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSecretSpecAssert<S extends AbstractSecretSpecAssert<S, A>, A extends SecretSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSecretSpecAssert}</code> to make assertions on actual SecretSpec.
   * @param actual the SecretSpec we want to make assertions on.
   */
  protected AbstractSecretSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SecretSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property mountPath so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert mountPath()  {
    // check that actual SecretSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMountPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "mountPath"));
  }


  /**
   * Navigates to the property secretSource so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert secretSource()  {
    // check that actual SecretSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert) assertThat(actual.getSecretSource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretSource"));
  }


}
