package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link BuildStatusOutput} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractBuildStatusOutputAssert<S extends AbstractBuildStatusOutputAssert<S, A>, A extends BuildStatusOutput> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractBuildStatusOutputAssert}</code> to make assertions on actual BuildStatusOutput.
   * @param actual the BuildStatusOutput we want to make assertions on.
   */
  protected AbstractBuildStatusOutputAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual BuildStatusOutput we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property to so that assertions can be done on it
   */
  public BuildStatusOutputToAssert to()  {
    // check that actual BuildStatusOutput we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (BuildStatusOutputToAssert) assertThat(actual.getTo()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "to"));
  }


}
