package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link NamedCluster} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedClusterAssert<S extends AbstractNamedClusterAssert<S, A>, A extends NamedCluster> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedClusterAssert}</code> to make assertions on actual NamedCluster.
   * @param actual the NamedCluster we want to make assertions on.
   */
  protected AbstractNamedClusterAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual NamedCluster we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property cluster so that assertions can be done on it
   */
  public ClusterAssert cluster()  {
    // check that actual NamedCluster we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ClusterAssert) assertThat(actual.getCluster()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cluster"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual NamedCluster we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


}
