/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.assertions.Conditions;
import io.fabric8.kubernetes.assertions.HasMetadatasAssert;
import io.fabric8.kubernetes.assertions.PodLogsAssert;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.utils.Strings;
import java.util.HashMap;
import java.util.List;

public class PodsAssert
extends HasMetadatasAssert<Pod, PodsAssert> {
    private final KubernetesClient client;

    public PodsAssert(List<Pod> actual, KubernetesClient client) {
        super(actual);
        this.client = client;
    }

    public PodLogsAssert logs() {
        return this.logs(null);
    }

    public PodLogsAssert logs(String containerName) {
        HashMap<String, String> logs = new HashMap<String, String>();
        List pods = this.get();
        for (Pod pod : pods) {
            String log;
            ObjectMeta metadata = pod.getMetadata();
            if (metadata == null) continue;
            String name = metadata.getName();
            String namespace = metadata.getNamespace();
            String key = name;
            if (Strings.isNotBlank((String)namespace)) {
                key = namespace + "/" + name;
            }
            if ((log = (String)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withName(name)).getLog(Boolean.valueOf(true))) == null) continue;
            logs.put(key, log);
        }
        return new PodLogsAssert(logs, containerName);
    }

    public PodsAssert runningStatus() {
        return (PodsAssert)((Object)this.filter(Conditions.runningStatus()));
    }

    public PodsAssert waitingStatus() {
        return (PodsAssert)((Object)this.filter(Conditions.waitingStatus()));
    }

    public PodsAssert errorStatus() {
        return (PodsAssert)((Object)this.filter(Conditions.errorStatus()));
    }

    @Override
    protected PodsAssert createListAssert(List<Pod> list) {
        return new PodsAssert(list, this.client);
    }
}

