package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link SubjectAccessReviewResponse} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractSubjectAccessReviewResponseAssert<S extends AbstractSubjectAccessReviewResponseAssert<S, A>, A extends SubjectAccessReviewResponse> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractSubjectAccessReviewResponseAssert}</code> to make assertions on actual SubjectAccessReviewResponse.
   * @param actual the SubjectAccessReviewResponse we want to make assertions on.
   */
  protected AbstractSubjectAccessReviewResponseAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual SubjectAccessReviewResponse we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property allowed so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert allowed()  {
    // check that actual SubjectAccessReviewResponse we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getAllowed()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allowed"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual SubjectAccessReviewResponse we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property evaluationError so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert evaluationError()  {
    // check that actual SubjectAccessReviewResponse we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getEvaluationError()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "evaluationError"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual SubjectAccessReviewResponse we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property namespace so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert namespace()  {
    // check that actual SubjectAccessReviewResponse we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespace"));
  }


  /**
   * Navigates to the property reason so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert reason()  {
    // check that actual SubjectAccessReviewResponse we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getReason()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "reason"));
  }


}
