package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link StatefulSetStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractStatefulSetStatusAssert<S extends AbstractStatefulSetStatusAssert<S, A>, A extends StatefulSetStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractStatefulSetStatusAssert}</code> to make assertions on actual StatefulSetStatus.
   * @param actual the StatefulSetStatus we want to make assertions on.
   */
  protected AbstractStatefulSetStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual StatefulSetStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual StatefulSetStatus's observedGeneration is equal to the given one.
   * @param observedGeneration the given observedGeneration to compare the actual StatefulSetStatus's observedGeneration to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatefulSetStatus's observedGeneration is not equal to the given one.
   */
  public S hasObservedGeneration(Long observedGeneration) {
    // check that actual StatefulSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting observedGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualObservedGeneration = actual.getObservedGeneration();
    if (!Objects.areEqual(actualObservedGeneration, observedGeneration)) {
      failWithMessage(assertjErrorMessage, actual, observedGeneration, actualObservedGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual StatefulSetStatus's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual StatefulSetStatus's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual StatefulSetStatus's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual StatefulSetStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
