package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link KubeSchema} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractKubeSchemaAssert<S extends AbstractKubeSchemaAssert<S, A>, A extends KubeSchema> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractKubeSchemaAssert}</code> to make assertions on actual KubeSchema.
   * @param actual the KubeSchema we want to make assertions on.
   */
  protected AbstractKubeSchemaAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property baseKubernetesList so that assertions can be done on it
   */
  public BaseKubernetesListAssert baseKubernetesList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (BaseKubernetesListAssert) assertThat(actual.getBaseKubernetesList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "baseKubernetesList"));
  }


  /**
   * Navigates to the property binding so that assertions can be done on it
   */
  public BindingAssert binding()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (BindingAssert) assertThat(actual.getBinding()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "binding"));
  }


  /**
   * Navigates to the property buildConfigList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.BuildConfigListAssert buildConfigList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.BuildConfigListAssert) assertThat(actual.getBuildConfigList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "buildConfigList"));
  }


  /**
   * Navigates to the property buildList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.BuildListAssert buildList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.BuildListAssert) assertThat(actual.getBuildList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "buildList"));
  }


  /**
   * Navigates to the property buildRequest so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.BuildRequestAssert buildRequest()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.BuildRequestAssert) assertThat(actual.getBuildRequest()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "buildRequest"));
  }


  /**
   * Navigates to the property clusterPolicy so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ClusterPolicyAssert clusterPolicy()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ClusterPolicyAssert) assertThat(actual.getClusterPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterPolicy"));
  }


  /**
   * Navigates to the property clusterPolicyBinding so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ClusterPolicyBindingAssert clusterPolicyBinding()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ClusterPolicyBindingAssert) assertThat(actual.getClusterPolicyBinding()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterPolicyBinding"));
  }


  /**
   * Navigates to the property clusterPolicyBindingList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ClusterPolicyBindingListAssert clusterPolicyBindingList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ClusterPolicyBindingListAssert) assertThat(actual.getClusterPolicyBindingList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterPolicyBindingList"));
  }


  /**
   * Navigates to the property clusterPolicyList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ClusterPolicyListAssert clusterPolicyList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ClusterPolicyListAssert) assertThat(actual.getClusterPolicyList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterPolicyList"));
  }


  /**
   * Navigates to the property clusterRoleBinding so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ClusterRoleBindingAssert clusterRoleBinding()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ClusterRoleBindingAssert) assertThat(actual.getClusterRoleBinding()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterRoleBinding"));
  }


  /**
   * Navigates to the property clusterRoleBindingList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ClusterRoleBindingListAssert clusterRoleBindingList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ClusterRoleBindingListAssert) assertThat(actual.getClusterRoleBindingList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterRoleBindingList"));
  }


  /**
   * Navigates to the property componentStatusList so that assertions can be done on it
   */
  public ComponentStatusListAssert componentStatusList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ComponentStatusListAssert) assertThat(actual.getComponentStatusList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "componentStatusList"));
  }


  /**
   * Navigates to the property config so that assertions can be done on it
   */
  public ConfigAssert config()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ConfigAssert) assertThat(actual.getConfig()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "config"));
  }


  /**
   * Navigates to the property configMap so that assertions can be done on it
   */
  public ConfigMapAssert configMap()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ConfigMapAssert) assertThat(actual.getConfigMap()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "configMap"));
  }


  /**
   * Navigates to the property configMapList so that assertions can be done on it
   */
  public ConfigMapListAssert configMapList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ConfigMapListAssert) assertThat(actual.getConfigMapList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "configMapList"));
  }


  /**
   * Navigates to the property containerStatus so that assertions can be done on it
   */
  public ContainerStatusAssert containerStatus()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ContainerStatusAssert) assertThat(actual.getContainerStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containerStatus"));
  }


  /**
   * Navigates to the property cronJob so that assertions can be done on it
   */
  public CronJobAssert cronJob()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CronJobAssert) assertThat(actual.getCronJob()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cronJob"));
  }


  /**
   * Navigates to the property cronJobList so that assertions can be done on it
   */
  public CronJobListAssert cronJobList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CronJobListAssert) assertThat(actual.getCronJobList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cronJobList"));
  }


  /**
   * Navigates to the property daemonSet so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.DaemonSetAssert daemonSet()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.DaemonSetAssert) assertThat(actual.getDaemonSet()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "daemonSet"));
  }


  /**
   * Navigates to the property daemonSetList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.DaemonSetListAssert daemonSetList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.DaemonSetListAssert) assertThat(actual.getDaemonSetList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "daemonSetList"));
  }


  /**
   * Navigates to the property deleteOptions so that assertions can be done on it
   */
  public DeleteOptionsAssert deleteOptions()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DeleteOptionsAssert) assertThat(actual.getDeleteOptions()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deleteOptions"));
  }


  /**
   * Navigates to the property deployment so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.DeploymentAssert deployment()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.DeploymentAssert) assertThat(actual.getDeployment()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deployment"));
  }


  /**
   * Navigates to the property deploymentConfigList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.DeploymentConfigListAssert deploymentConfigList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.DeploymentConfigListAssert) assertThat(actual.getDeploymentConfigList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deploymentConfigList"));
  }


  /**
   * Navigates to the property deploymentList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.DeploymentListAssert deploymentList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.DeploymentListAssert) assertThat(actual.getDeploymentList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deploymentList"));
  }


  /**
   * Navigates to the property deploymentRollback so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackAssert deploymentRollback()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackAssert) assertThat(actual.getDeploymentRollback()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deploymentRollback"));
  }


  /**
   * Navigates to the property endpoints so that assertions can be done on it
   */
  public EndpointsAssert endpoints()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (EndpointsAssert) assertThat(actual.getEndpoints()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "endpoints"));
  }


  /**
   * Navigates to the property endpointsList so that assertions can be done on it
   */
  public EndpointsListAssert endpointsList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (EndpointsListAssert) assertThat(actual.getEndpointsList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "endpointsList"));
  }


  /**
   * Navigates to the property envVar so that assertions can be done on it
   */
  public EnvVarAssert envVar()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (EnvVarAssert) assertThat(actual.getEnvVar()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "envVar"));
  }


  /**
   * Navigates to the property eventList so that assertions can be done on it
   */
  public EventListAssert eventList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (EventListAssert) assertThat(actual.getEventList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "eventList"));
  }


  /**
   * Navigates to the property group so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.GroupAssert group()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.GroupAssert) assertThat(actual.getGroup()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "group"));
  }


  /**
   * Navigates to the property groupList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.GroupListAssert groupList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.GroupListAssert) assertThat(actual.getGroupList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "groupList"));
  }


  /**
   * Navigates to the property horizontalPodAutoscaler so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerAssert horizontalPodAutoscaler()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerAssert) assertThat(actual.getHorizontalPodAutoscaler()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "horizontalPodAutoscaler"));
  }


  /**
   * Navigates to the property horizontalPodAutoscalerList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerListAssert horizontalPodAutoscalerList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerListAssert) assertThat(actual.getHorizontalPodAutoscalerList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "horizontalPodAutoscalerList"));
  }


  /**
   * Navigates to the property identity so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.IdentityAssert identity()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.IdentityAssert) assertThat(actual.getIdentity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "identity"));
  }


  /**
   * Navigates to the property identityList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.IdentityListAssert identityList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.IdentityListAssert) assertThat(actual.getIdentityList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "identityList"));
  }


  /**
   * Navigates to the property imageList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ImageListAssert imageList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ImageListAssert) assertThat(actual.getImageList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageList"));
  }


  /**
   * Navigates to the property imageStreamList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ImageStreamListAssert imageStreamList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ImageStreamListAssert) assertThat(actual.getImageStreamList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageStreamList"));
  }


  /**
   * Navigates to the property imageStreamTagList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ImageStreamTagListAssert imageStreamTagList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ImageStreamTagListAssert) assertThat(actual.getImageStreamTagList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageStreamTagList"));
  }


  /**
   * Navigates to the property ingress so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.IngressAssert ingress()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.IngressAssert) assertThat(actual.getIngress()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ingress"));
  }


  /**
   * Navigates to the property ingressList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.IngressListAssert ingressList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.IngressListAssert) assertThat(actual.getIngressList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ingressList"));
  }


  /**
   * Navigates to the property job so that assertions can be done on it
   */
  public JobAssert job()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (JobAssert) assertThat(actual.getJob()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "job"));
  }


  /**
   * Navigates to the property jobList so that assertions can be done on it
   */
  public JobListAssert jobList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (JobListAssert) assertThat(actual.getJobList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "jobList"));
  }


  /**
   * Navigates to the property limitRangeList so that assertions can be done on it
   */
  public LimitRangeListAssert limitRangeList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LimitRangeListAssert) assertThat(actual.getLimitRangeList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "limitRangeList"));
  }


  /**
   * Navigates to the property listMeta so that assertions can be done on it
   */
  public ListMetaAssert listMeta()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ListMetaAssert) assertThat(actual.getListMeta()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "listMeta"));
  }


  /**
   * Navigates to the property localSubjectAccessReview so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.LocalSubjectAccessReviewAssert localSubjectAccessReview()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.LocalSubjectAccessReviewAssert) assertThat(actual.getLocalSubjectAccessReview()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "localSubjectAccessReview"));
  }


  /**
   * Navigates to the property namespace so that assertions can be done on it
   */
  public NamespaceAssert namespace()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NamespaceAssert) assertThat(actual.getNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespace"));
  }


  /**
   * Navigates to the property namespaceList so that assertions can be done on it
   */
  public NamespaceListAssert namespaceList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NamespaceListAssert) assertThat(actual.getNamespaceList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespaceList"));
  }


  /**
   * Navigates to the property node so that assertions can be done on it
   */
  public NodeAssert node()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeAssert) assertThat(actual.getNode()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "node"));
  }


  /**
   * Navigates to the property nodeList so that assertions can be done on it
   */
  public NodeListAssert nodeList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NodeListAssert) assertThat(actual.getNodeList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeList"));
  }


  /**
   * Navigates to the property oAuthAccessToken so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthAccessTokenAssert oAuthAccessToken()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthAccessTokenAssert) assertThat(actual.getOAuthAccessToken()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthAccessToken"));
  }


  /**
   * Navigates to the property oAuthAccessTokenList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthAccessTokenListAssert oAuthAccessTokenList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthAccessTokenListAssert) assertThat(actual.getOAuthAccessTokenList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthAccessTokenList"));
  }


  /**
   * Navigates to the property oAuthAuthorizeToken so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthAuthorizeTokenAssert oAuthAuthorizeToken()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthAuthorizeTokenAssert) assertThat(actual.getOAuthAuthorizeToken()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthAuthorizeToken"));
  }


  /**
   * Navigates to the property oAuthAuthorizeTokenList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthAuthorizeTokenListAssert oAuthAuthorizeTokenList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthAuthorizeTokenListAssert) assertThat(actual.getOAuthAuthorizeTokenList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthAuthorizeTokenList"));
  }


  /**
   * Navigates to the property oAuthClient so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthClientAssert oAuthClient()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthClientAssert) assertThat(actual.getOAuthClient()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthClient"));
  }


  /**
   * Navigates to the property oAuthClientAuthorization so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthClientAuthorizationAssert oAuthClientAuthorization()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthClientAuthorizationAssert) assertThat(actual.getOAuthClientAuthorization()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthClientAuthorization"));
  }


  /**
   * Navigates to the property oAuthClientAuthorizationList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthClientAuthorizationListAssert oAuthClientAuthorizationList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthClientAuthorizationListAssert) assertThat(actual.getOAuthClientAuthorizationList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthClientAuthorizationList"));
  }


  /**
   * Navigates to the property oAuthClientList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.OAuthClientListAssert oAuthClientList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.OAuthClientListAssert) assertThat(actual.getOAuthClientList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "oAuthClientList"));
  }


  /**
   * Navigates to the property objectMeta so that assertions can be done on it
   */
  public ObjectMetaAssert objectMeta()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectMetaAssert) assertThat(actual.getObjectMeta()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "objectMeta"));
  }


  /**
   * Navigates to the property patch so that assertions can be done on it
   */
  public PatchAssert patch()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PatchAssert) assertThat(actual.getPatch()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "patch"));
  }


  /**
   * Navigates to the property persistentVolume so that assertions can be done on it
   */
  public PersistentVolumeAssert persistentVolume()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PersistentVolumeAssert) assertThat(actual.getPersistentVolume()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "persistentVolume"));
  }


  /**
   * Navigates to the property persistentVolumeClaim so that assertions can be done on it
   */
  public PersistentVolumeClaimAssert persistentVolumeClaim()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PersistentVolumeClaimAssert) assertThat(actual.getPersistentVolumeClaim()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "persistentVolumeClaim"));
  }


  /**
   * Navigates to the property persistentVolumeClaimList so that assertions can be done on it
   */
  public PersistentVolumeClaimListAssert persistentVolumeClaimList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PersistentVolumeClaimListAssert) assertThat(actual.getPersistentVolumeClaimList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "persistentVolumeClaimList"));
  }


  /**
   * Navigates to the property persistentVolumeList so that assertions can be done on it
   */
  public PersistentVolumeListAssert persistentVolumeList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PersistentVolumeListAssert) assertThat(actual.getPersistentVolumeList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "persistentVolumeList"));
  }


  /**
   * Navigates to the property podList so that assertions can be done on it
   */
  public PodListAssert podList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PodListAssert) assertThat(actual.getPodList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podList"));
  }


  /**
   * Navigates to the property podTemplateList so that assertions can be done on it
   */
  public PodTemplateListAssert podTemplateList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (PodTemplateListAssert) assertThat(actual.getPodTemplateList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "podTemplateList"));
  }


  /**
   * Navigates to the property policy so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.PolicyAssert policy()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.PolicyAssert) assertThat(actual.getPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "policy"));
  }


  /**
   * Navigates to the property policyBinding so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.PolicyBindingAssert policyBinding()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.PolicyBindingAssert) assertThat(actual.getPolicyBinding()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "policyBinding"));
  }


  /**
   * Navigates to the property policyBindingList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.PolicyBindingListAssert policyBindingList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.PolicyBindingListAssert) assertThat(actual.getPolicyBindingList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "policyBindingList"));
  }


  /**
   * Navigates to the property policyList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.PolicyListAssert policyList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.PolicyListAssert) assertThat(actual.getPolicyList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "policyList"));
  }


  /**
   * Navigates to the property project so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ProjectAssert project()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ProjectAssert) assertThat(actual.getProject()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "project"));
  }


  /**
   * Navigates to the property projectList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ProjectListAssert projectList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ProjectListAssert) assertThat(actual.getProjectList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "projectList"));
  }


  /**
   * Navigates to the property projectRequest so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.ProjectRequestAssert projectRequest()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.ProjectRequestAssert) assertThat(actual.getProjectRequest()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "projectRequest"));
  }


  /**
   * Navigates to the property quantity so that assertions can be done on it
   */
  public QuantityAssert quantity()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (QuantityAssert) assertThat(actual.getQuantity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "quantity"));
  }


  /**
   * Navigates to the property replicaSet so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.ReplicaSetAssert replicaSet()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.ReplicaSetAssert) assertThat(actual.getReplicaSet()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "replicaSet"));
  }


  /**
   * Navigates to the property replicaSetList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.ReplicaSetListAssert replicaSetList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.ReplicaSetListAssert) assertThat(actual.getReplicaSetList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "replicaSetList"));
  }


  /**
   * Navigates to the property replicationControllerList so that assertions can be done on it
   */
  public ReplicationControllerListAssert replicationControllerList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ReplicationControllerListAssert) assertThat(actual.getReplicationControllerList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "replicationControllerList"));
  }


  /**
   * Navigates to the property resourceQuota so that assertions can be done on it
   */
  public ResourceQuotaAssert resourceQuota()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ResourceQuotaAssert) assertThat(actual.getResourceQuota()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceQuota"));
  }


  /**
   * Navigates to the property resourceQuotaList so that assertions can be done on it
   */
  public ResourceQuotaListAssert resourceQuotaList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ResourceQuotaListAssert) assertThat(actual.getResourceQuotaList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceQuotaList"));
  }


  /**
   * Navigates to the property role so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.RoleAssert role()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.RoleAssert) assertThat(actual.getRole()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "role"));
  }


  /**
   * Navigates to the property roleBinding so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.RoleBindingAssert roleBinding()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.RoleBindingAssert) assertThat(actual.getRoleBinding()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "roleBinding"));
  }


  /**
   * Navigates to the property roleBindingList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.RoleBindingListAssert roleBindingList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.RoleBindingListAssert) assertThat(actual.getRoleBindingList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "roleBindingList"));
  }


  /**
   * Navigates to the property roleBindingRestriction so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.RoleBindingRestrictionAssert roleBindingRestriction()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.RoleBindingRestrictionAssert) assertThat(actual.getRoleBindingRestriction()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "roleBindingRestriction"));
  }


  /**
   * Navigates to the property roleList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.RoleListAssert roleList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.RoleListAssert) assertThat(actual.getRoleList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "roleList"));
  }


  /**
   * Navigates to the property rootPaths so that assertions can be done on it
   */
  public RootPathsAssert rootPaths()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RootPathsAssert) assertThat(actual.getRootPaths()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rootPaths"));
  }


  /**
   * Navigates to the property routeList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.RouteListAssert routeList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.RouteListAssert) assertThat(actual.getRouteList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "routeList"));
  }


  /**
   * Navigates to the property scale so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.ScaleAssert scale()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.ScaleAssert) assertThat(actual.getScale()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scale"));
  }


  /**
   * Navigates to the property secret so that assertions can be done on it
   */
  public SecretAssert secret()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SecretAssert) assertThat(actual.getSecret()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secret"));
  }


  /**
   * Navigates to the property secretList so that assertions can be done on it
   */
  public SecretListAssert secretList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SecretListAssert) assertThat(actual.getSecretList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secretList"));
  }


  /**
   * Navigates to the property securityContextConstraints so that assertions can be done on it
   */
  public SecurityContextConstraintsAssert securityContextConstraints()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SecurityContextConstraintsAssert) assertThat(actual.getSecurityContextConstraints()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "securityContextConstraints"));
  }


  /**
   * Navigates to the property securityContextConstraintsList so that assertions can be done on it
   */
  public SecurityContextConstraintsListAssert securityContextConstraintsList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SecurityContextConstraintsListAssert) assertThat(actual.getSecurityContextConstraintsList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "securityContextConstraintsList"));
  }


  /**
   * Navigates to the property serviceAccount so that assertions can be done on it
   */
  public ServiceAccountAssert serviceAccount()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ServiceAccountAssert) assertThat(actual.getServiceAccount()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceAccount"));
  }


  /**
   * Navigates to the property serviceAccountList so that assertions can be done on it
   */
  public ServiceAccountListAssert serviceAccountList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ServiceAccountListAssert) assertThat(actual.getServiceAccountList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceAccountList"));
  }


  /**
   * Navigates to the property serviceList so that assertions can be done on it
   */
  public ServiceListAssert serviceList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ServiceListAssert) assertThat(actual.getServiceList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceList"));
  }


  /**
   * Navigates to the property statefulSet so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.StatefulSetAssert statefulSet()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.StatefulSetAssert) assertThat(actual.getStatefulSet()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "statefulSet"));
  }


  /**
   * Navigates to the property statefulSetList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.StatefulSetListAssert statefulSetList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.StatefulSetListAssert) assertThat(actual.getStatefulSetList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "statefulSetList"));
  }


  /**
   * Navigates to the property status so that assertions can be done on it
   */
  public StatusAssert status()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (StatusAssert) assertThat(actual.getStatus()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "status"));
  }


  /**
   * Navigates to the property subjectAccessReview so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.SubjectAccessReviewAssert subjectAccessReview()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.SubjectAccessReviewAssert) assertThat(actual.getSubjectAccessReview()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subjectAccessReview"));
  }


  /**
   * Navigates to the property subjectAccessReviewResponse so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.SubjectAccessReviewResponseAssert subjectAccessReviewResponse()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.SubjectAccessReviewResponseAssert) assertThat(actual.getSubjectAccessReviewResponse()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subjectAccessReviewResponse"));
  }


  /**
   * Navigates to the property tagEvent so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.TagEventAssert tagEvent()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.TagEventAssert) assertThat(actual.getTagEvent()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tagEvent"));
  }


  /**
   * Navigates to the property template so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.TemplateAssert template()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.TemplateAssert) assertThat(actual.getTemplate()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "template"));
  }


  /**
   * Navigates to the property templateList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.TemplateListAssert templateList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.TemplateListAssert) assertThat(actual.getTemplateList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "templateList"));
  }


  /**
   * Navigates to the property thirdPartyResource so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceAssert thirdPartyResource()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceAssert) assertThat(actual.getThirdPartyResource()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "thirdPartyResource"));
  }


  /**
   * Navigates to the property thirdPartyResourceList so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceListAssert thirdPartyResourceList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceListAssert) assertThat(actual.getThirdPartyResourceList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "thirdPartyResourceList"));
  }


  /**
   * Navigates to the property user so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.UserAssert user()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.UserAssert) assertThat(actual.getUser()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "user"));
  }


  /**
   * Navigates to the property userList so that assertions can be done on it
   */
  public io.fabric8.openshift.api.model.UserListAssert userList()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.openshift.api.model.UserListAssert) assertThat(actual.getUserList()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "userList"));
  }


  /**
   * Navigates to the property watchEvent so that assertions can be done on it
   */
  public WatchEventAssert watchEvent()  {
    // check that actual KubeSchema we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (WatchEventAssert) assertThat(actual.getWatchEvent()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "watchEvent"));
  }


}
