/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableParameter;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.ParameterFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ParameterBuilder
extends ParameterFluent<ParameterBuilder>
implements VisitableBuilder<Parameter, ParameterBuilder> {
    ParameterFluent<?> fluent;

    public ParameterBuilder() {
        this(new Parameter());
    }

    public ParameterBuilder(ParameterFluent<?> fluent) {
        this(fluent, new Parameter());
    }

    public ParameterBuilder(ParameterFluent<?> fluent, Parameter instance) {
        this.fluent = fluent;
        fluent.withDescription(instance.getDescription());
        fluent.withFrom(instance.getFrom());
        fluent.withGenerate(instance.getGenerate());
        fluent.withName(instance.getName());
        fluent.withValue(instance.getValue());
    }

    public ParameterBuilder(Parameter instance) {
        this.fluent = this;
        this.withDescription(instance.getDescription());
        this.withFrom(instance.getFrom());
        this.withGenerate(instance.getGenerate());
        this.withName(instance.getName());
        this.withValue(instance.getValue());
    }

    public EditableParameter build() {
        EditableParameter buildable = new EditableParameter(this.fluent.getDescription(), this.fluent.getFrom(), this.fluent.getGenerate(), this.fluent.getName(), this.fluent.getValue());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterBuilder that = (ParameterBuilder)((Object)o);
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

