/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "redirectURIs", "respondWithChallenges", "secret"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class OAuthClient
implements HasMetadata {
    @JsonProperty(value="apiVersion")
    @NotNull
    private ApiVersion apiVersion = ApiVersion.fromValue("v1");
    @JsonProperty(value="kind")
    @NotNull
    private String kind = "OAuthClient";
    @JsonProperty(value="metadata")
    @Valid
    private ObjectMeta metadata;
    @JsonProperty(value="redirectURIs")
    @Valid
    private List<String> redirectURIs = new ArrayList<String>();
    @JsonProperty(value="respondWithChallenges")
    private Boolean respondWithChallenges;
    @JsonProperty(value="secret")
    private String secret;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public OAuthClient() {
    }

    public OAuthClient(ApiVersion apiVersion, String kind, ObjectMeta metadata, List<String> redirectURIs, Boolean respondWithChallenges, String secret) {
        this.apiVersion = apiVersion;
        this.kind = kind;
        this.metadata = metadata;
        this.redirectURIs = redirectURIs;
        this.respondWithChallenges = respondWithChallenges;
        this.secret = secret;
    }

    @JsonProperty(value="apiVersion")
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="redirectURIs")
    public List<String> getRedirectURIs() {
        return this.redirectURIs;
    }

    @JsonProperty(value="redirectURIs")
    public void setRedirectURIs(List<String> redirectURIs) {
        this.redirectURIs = redirectURIs;
    }

    @JsonProperty(value="respondWithChallenges")
    public Boolean getRespondWithChallenges() {
        return this.respondWithChallenges;
    }

    @JsonProperty(value="respondWithChallenges")
    public void setRespondWithChallenges(Boolean respondWithChallenges) {
        this.respondWithChallenges = respondWithChallenges;
    }

    @JsonProperty(value="secret")
    public String getSecret() {
        return this.secret;
    }

    @JsonProperty(value="secret")
    public void setSecret(String secret) {
        this.secret = secret;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "OAuthClient(apiVersion=" + (Object)((Object)this.getApiVersion()) + ", kind=" + this.getKind() + ", metadata=" + this.getMetadata() + ", redirectURIs=" + this.getRedirectURIs() + ", respondWithChallenges=" + this.getRespondWithChallenges() + ", secret=" + this.getSecret() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuthClient)) {
            return false;
        }
        OAuthClient other = (OAuthClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApiVersion this$apiVersion = this.getApiVersion();
        ApiVersion other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !((Object)((Object)this$apiVersion)).equals((Object)other$apiVersion)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<String> this$redirectURIs = this.getRedirectURIs();
        List<String> other$redirectURIs = other.getRedirectURIs();
        if (this$redirectURIs == null ? other$redirectURIs != null : !((Object)this$redirectURIs).equals(other$redirectURIs)) {
            return false;
        }
        Boolean this$respondWithChallenges = this.getRespondWithChallenges();
        Boolean other$respondWithChallenges = other.getRespondWithChallenges();
        if (this$respondWithChallenges == null ? other$respondWithChallenges != null : !((Object)this$respondWithChallenges).equals(other$respondWithChallenges)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuthClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApiVersion $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 0 : ((Object)((Object)$apiVersion)).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 0 : $kind.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 0 : ((Object)$metadata).hashCode());
        List<String> $redirectURIs = this.getRedirectURIs();
        result = result * 59 + ($redirectURIs == null ? 0 : ((Object)$redirectURIs).hashCode());
        Boolean $respondWithChallenges = this.getRespondWithChallenges();
        result = result * 59 + ($respondWithChallenges == null ? 0 : ((Object)$respondWithChallenges).hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 0 : $secret.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 0 : ((Object)$additionalProperties).hashCode());
        return result;
    }

    public static enum ApiVersion {
        V_1("v1");

        private final String value;
        private static Map<String, ApiVersion> constants;

        private ApiVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ApiVersion fromValue(String value) {
            ApiVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, ApiVersion>();
            for (ApiVersion c : ApiVersion.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

