package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link HorizontalPodAutoscalerSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractHorizontalPodAutoscalerSpecAssert<S extends AbstractHorizontalPodAutoscalerSpecAssert<S, A>, A extends HorizontalPodAutoscalerSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractHorizontalPodAutoscalerSpecAssert}</code> to make assertions on actual HorizontalPodAutoscalerSpec.
   * @param actual the HorizontalPodAutoscalerSpec we want to make assertions on.
   */
  protected AbstractHorizontalPodAutoscalerSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual HorizontalPodAutoscalerSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property cpuUtilization so that assertions can be done on it
   */
  public CPUTargetUtilizationAssert cpuUtilization()  {
    // check that actual HorizontalPodAutoscalerSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CPUTargetUtilizationAssert) assertThat(actual.getCpuUtilization()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cpuUtilization"));
  }


  /**
   * Verifies that the actual HorizontalPodAutoscalerSpec's maxReplicas is equal to the given one.
   * @param maxReplicas the given maxReplicas to compare the actual HorizontalPodAutoscalerSpec's maxReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HorizontalPodAutoscalerSpec's maxReplicas is not equal to the given one.
   */
  public S hasMaxReplicas(Integer maxReplicas) {
    // check that actual HorizontalPodAutoscalerSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting maxReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualMaxReplicas = actual.getMaxReplicas();
    if (!Objects.areEqual(actualMaxReplicas, maxReplicas)) {
      failWithMessage(assertjErrorMessage, actual, maxReplicas, actualMaxReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual HorizontalPodAutoscalerSpec's minReplicas is equal to the given one.
   * @param minReplicas the given minReplicas to compare the actual HorizontalPodAutoscalerSpec's minReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual HorizontalPodAutoscalerSpec's minReplicas is not equal to the given one.
   */
  public S hasMinReplicas(Integer minReplicas) {
    // check that actual HorizontalPodAutoscalerSpec we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting minReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualMinReplicas = actual.getMinReplicas();
    if (!Objects.areEqual(actualMinReplicas, minReplicas)) {
      failWithMessage(assertjErrorMessage, actual, minReplicas, actualMinReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property scaleRef so that assertions can be done on it
   */
  public SubresourceReferenceAssert scaleRef()  {
    // check that actual HorizontalPodAutoscalerSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SubresourceReferenceAssert) assertThat(actual.getScaleRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scaleRef"));
  }


}
