package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link FlockerVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractFlockerVolumeSourceAssert<S extends AbstractFlockerVolumeSourceAssert<S, A>, A extends FlockerVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractFlockerVolumeSourceAssert}</code> to make assertions on actual FlockerVolumeSource.
   * @param actual the FlockerVolumeSource we want to make assertions on.
   */
  protected AbstractFlockerVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual FlockerVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property datasetName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert datasetName()  {
    // check that actual FlockerVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDatasetName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "datasetName"));
  }


  /**
   * Navigates to the property datasetUUID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert datasetUUID()  {
    // check that actual FlockerVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDatasetUUID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "datasetUUID"));
  }


}
