/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ImageLayer;
import io.fabric8.openshift.api.model.ImageLayerFluent;
import io.fabric8.openshift.api.model.ImageLayerFluentImpl;

public class ImageLayerBuilder
extends ImageLayerFluentImpl<ImageLayerBuilder>
implements VisitableBuilder<ImageLayer, ImageLayerBuilder> {
    ImageLayerFluent<?> fluent;
    Boolean validationEnabled;

    public ImageLayerBuilder() {
        this(true);
    }

    public ImageLayerBuilder(Boolean validationEnabled) {
        this(new ImageLayer(), validationEnabled);
    }

    public ImageLayerBuilder(ImageLayerFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageLayerBuilder(ImageLayerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageLayer(), validationEnabled);
    }

    public ImageLayerBuilder(ImageLayerFluent<?> fluent, ImageLayer instance) {
        this(fluent, instance, true);
    }

    public ImageLayerBuilder(ImageLayerFluent<?> fluent, ImageLayer instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMediaType(instance.getMediaType());
        fluent.withName(instance.getName());
        fluent.withSize(instance.getSize());
        this.validationEnabled = validationEnabled;
    }

    public ImageLayerBuilder(ImageLayer instance) {
        this(instance, (Boolean)true);
    }

    public ImageLayerBuilder(ImageLayer instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMediaType(instance.getMediaType());
        this.withName(instance.getName());
        this.withSize(instance.getSize());
        this.validationEnabled = validationEnabled;
    }

    public ImageLayer build() {
        ImageLayer buildable = new ImageLayer(this.fluent.getMediaType(), this.fluent.getName(), this.fluent.getSize());
        ValidationUtils.validate((Object)buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageLayerBuilder that = (ImageLayerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

