package io.fabric8.kubernetes.assertions.internal;

/**
 * Entry point for assertions of different data types. Each method in this class is a static factory for the
 * type-specific assertion objects.
 */
public class Assertions {

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.AWSElasticBlockStoreVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AttachedVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AttachedVolumeAssert assertThat(io.fabric8.kubernetes.api.model.AttachedVolume actual) {
    return new io.fabric8.kubernetes.api.model.AttachedVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AuthInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AuthInfoAssert assertThat(io.fabric8.kubernetes.api.model.AuthInfo actual) {
    return new io.fabric8.kubernetes.api.model.AuthInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AuthProviderConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AuthProviderConfigAssert assertThat(io.fabric8.kubernetes.api.model.AuthProviderConfig actual) {
    return new io.fabric8.kubernetes.api.model.AuthProviderConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.AzureDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.AzureDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.AzureFileVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.AzureFileVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.AzureFileVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.AzureFileVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.BaseKubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.BaseKubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.BaseKubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.BaseKubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.BindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.BindingAssert assertThat(io.fabric8.kubernetes.api.model.Binding actual) {
    return new io.fabric8.kubernetes.api.model.BindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CapabilitiesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CapabilitiesAssert assertThat(io.fabric8.kubernetes.api.model.Capabilities actual) {
    return new io.fabric8.kubernetes.api.model.CapabilitiesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CephFSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CephFSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.CephFSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.CephFSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CinderVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CinderVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.CinderVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.CinderVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ClusterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ClusterAssert assertThat(io.fabric8.kubernetes.api.model.Cluster actual) {
    return new io.fabric8.kubernetes.api.model.ClusterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ComponentConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ComponentConditionAssert assertThat(io.fabric8.kubernetes.api.model.ComponentCondition actual) {
    return new io.fabric8.kubernetes.api.model.ComponentConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ComponentStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ComponentStatusAssert assertThat(io.fabric8.kubernetes.api.model.ComponentStatus actual) {
    return new io.fabric8.kubernetes.api.model.ComponentStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ComponentStatusListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ComponentStatusListAssert assertThat(io.fabric8.kubernetes.api.model.ComponentStatusList actual) {
    return new io.fabric8.kubernetes.api.model.ComponentStatusListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigAssert assertThat(io.fabric8.kubernetes.api.model.Config actual) {
    return new io.fabric8.kubernetes.api.model.ConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigMapAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigMapAssert assertThat(io.fabric8.kubernetes.api.model.ConfigMap actual) {
    return new io.fabric8.kubernetes.api.model.ConfigMapAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigMapKeySelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigMapKeySelectorAssert assertThat(io.fabric8.kubernetes.api.model.ConfigMapKeySelector actual) {
    return new io.fabric8.kubernetes.api.model.ConfigMapKeySelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigMapListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigMapListAssert assertThat(io.fabric8.kubernetes.api.model.ConfigMapList actual) {
    return new io.fabric8.kubernetes.api.model.ConfigMapListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.ConfigMapVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerAssert assertThat(io.fabric8.kubernetes.api.model.Container actual) {
    return new io.fabric8.kubernetes.api.model.ContainerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerImageAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerImageAssert assertThat(io.fabric8.kubernetes.api.model.ContainerImage actual) {
    return new io.fabric8.kubernetes.api.model.ContainerImageAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerPortAssert assertThat(io.fabric8.kubernetes.api.model.ContainerPort actual) {
    return new io.fabric8.kubernetes.api.model.ContainerPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateAssert assertThat(io.fabric8.kubernetes.api.model.ContainerState actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateRunningAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateRunningAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateRunning actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateRunningAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateTerminated actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateTerminatedAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStateWaiting actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStateWaitingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContainerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContainerStatusAssert assertThat(io.fabric8.kubernetes.api.model.ContainerStatus actual) {
    return new io.fabric8.kubernetes.api.model.ContainerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ContextAssert assertThat(io.fabric8.kubernetes.api.model.Context actual) {
    return new io.fabric8.kubernetes.api.model.ContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CronJobAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CronJobAssert assertThat(io.fabric8.kubernetes.api.model.CronJob actual) {
    return new io.fabric8.kubernetes.api.model.CronJobAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CronJobListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CronJobListAssert assertThat(io.fabric8.kubernetes.api.model.CronJobList actual) {
    return new io.fabric8.kubernetes.api.model.CronJobListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CronJobSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CronJobSpecAssert assertThat(io.fabric8.kubernetes.api.model.CronJobSpec actual) {
    return new io.fabric8.kubernetes.api.model.CronJobSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.CronJobStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.CronJobStatusAssert assertThat(io.fabric8.kubernetes.api.model.CronJobStatus actual) {
    return new io.fabric8.kubernetes.api.model.CronJobStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DaemonEndpointAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DaemonEndpointAssert assertThat(io.fabric8.kubernetes.api.model.DaemonEndpoint actual) {
    return new io.fabric8.kubernetes.api.model.DaemonEndpointAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DeleteOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DeleteOptionsAssert assertThat(io.fabric8.kubernetes.api.model.DeleteOptions actual) {
    return new io.fabric8.kubernetes.api.model.DeleteOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DeprecatedDownwardAPIVolumeFileAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DeprecatedDownwardAPIVolumeFileAssert assertThat(io.fabric8.kubernetes.api.model.DeprecatedDownwardAPIVolumeFile actual) {
    return new io.fabric8.kubernetes.api.model.DeprecatedDownwardAPIVolumeFileAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DeprecatedDownwardAPIVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DeprecatedDownwardAPIVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DeprecatedDownwardAPIVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DeprecatedDownwardAPIVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileAssert assertThat(io.fabric8.kubernetes.api.model.DownwardAPIVolumeFile actual) {
    return new io.fabric8.kubernetes.api.model.DownwardAPIVolumeFileAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.DownwardAPIVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.EmptyDirVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointAddressAssert assertThat(io.fabric8.kubernetes.api.model.EndpointAddress actual) {
    return new io.fabric8.kubernetes.api.model.EndpointAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointPortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointPortAssert assertThat(io.fabric8.kubernetes.api.model.EndpointPort actual) {
    return new io.fabric8.kubernetes.api.model.EndpointPortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointSubsetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointSubsetAssert assertThat(io.fabric8.kubernetes.api.model.EndpointSubset actual) {
    return new io.fabric8.kubernetes.api.model.EndpointSubsetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsAssert assertThat(io.fabric8.kubernetes.api.model.Endpoints actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EndpointsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EndpointsListAssert assertThat(io.fabric8.kubernetes.api.model.EndpointsList actual) {
    return new io.fabric8.kubernetes.api.model.EndpointsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarAssert assertThat(io.fabric8.kubernetes.api.model.EnvVar actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EnvVarSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EnvVarSourceAssert assertThat(io.fabric8.kubernetes.api.model.EnvVarSource actual) {
    return new io.fabric8.kubernetes.api.model.EnvVarSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventAssert assertThat(io.fabric8.kubernetes.api.model.Event actual) {
    return new io.fabric8.kubernetes.api.model.EventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventListAssert assertThat(io.fabric8.kubernetes.api.model.EventList actual) {
    return new io.fabric8.kubernetes.api.model.EventListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.EventSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.EventSourceAssert assertThat(io.fabric8.kubernetes.api.model.EventSource actual) {
    return new io.fabric8.kubernetes.api.model.EventSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ExecActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ExecActionAssert assertThat(io.fabric8.kubernetes.api.model.ExecAction actual) {
    return new io.fabric8.kubernetes.api.model.ExecActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.FCVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.FCVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.FCVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.FCVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.FSGroupStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.FSGroupStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.FSGroupStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.FSGroupStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.FlexVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.FlexVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.FlexVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.FlexVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.FlockerVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.FlockerVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.FlockerVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.FlockerVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GCEPersistentDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GitRepoVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GitRepoVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.GlusterfsVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPGetActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPGetActionAssert assertThat(io.fabric8.kubernetes.api.model.HTTPGetAction actual) {
    return new io.fabric8.kubernetes.api.model.HTTPGetActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HTTPHeaderAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HTTPHeaderAssert assertThat(io.fabric8.kubernetes.api.model.HTTPHeader actual) {
    return new io.fabric8.kubernetes.api.model.HTTPHeaderAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HandlerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HandlerAssert assertThat(io.fabric8.kubernetes.api.model.Handler actual) {
    return new io.fabric8.kubernetes.api.model.HandlerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HasMetadataAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HasMetadataAssert assertThat(io.fabric8.kubernetes.api.model.HasMetadata actual) {
    return new io.fabric8.kubernetes.api.model.HasMetadataAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.HostPathVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.HostPathVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.IDRangeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.IDRangeAssert assertThat(io.fabric8.kubernetes.api.model.IDRange actual) {
    return new io.fabric8.kubernetes.api.model.IDRangeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.ISCSIVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.ISCSIVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.IntOrStringAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.IntOrStringAssert assertThat(io.fabric8.kubernetes.api.model.IntOrString actual) {
    return new io.fabric8.kubernetes.api.model.IntOrStringAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.JobAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.JobAssert assertThat(io.fabric8.kubernetes.api.model.Job actual) {
    return new io.fabric8.kubernetes.api.model.JobAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.JobConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.JobConditionAssert assertThat(io.fabric8.kubernetes.api.model.JobCondition actual) {
    return new io.fabric8.kubernetes.api.model.JobConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.JobListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.JobListAssert assertThat(io.fabric8.kubernetes.api.model.JobList actual) {
    return new io.fabric8.kubernetes.api.model.JobListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.JobSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.JobSpecAssert assertThat(io.fabric8.kubernetes.api.model.JobSpec actual) {
    return new io.fabric8.kubernetes.api.model.JobSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.JobStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.JobStatusAssert assertThat(io.fabric8.kubernetes.api.model.JobStatus actual) {
    return new io.fabric8.kubernetes.api.model.JobStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.JobTemplateSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.JobTemplateSpecAssert assertThat(io.fabric8.kubernetes.api.model.JobTemplateSpec actual) {
    return new io.fabric8.kubernetes.api.model.JobTemplateSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KeyToPathAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KeyToPathAssert assertThat(io.fabric8.kubernetes.api.model.KeyToPath actual) {
    return new io.fabric8.kubernetes.api.model.KeyToPathAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubeSchemaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubeSchemaAssert assertThat(io.fabric8.kubernetes.api.model.KubeSchema actual) {
    return new io.fabric8.kubernetes.api.model.KubeSchemaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesKindAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesKindAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesKind actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesKindAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesListAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesList actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesResourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesResourceAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesResource actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesResourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.KubernetesResourceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.KubernetesResourceListAssert assertThat(io.fabric8.kubernetes.api.model.KubernetesResourceList actual) {
    return new io.fabric8.kubernetes.api.model.KubernetesResourceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LabelSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LabelSelectorAssert assertThat(io.fabric8.kubernetes.api.model.LabelSelector actual) {
    return new io.fabric8.kubernetes.api.model.LabelSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LabelSelectorRequirementAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LabelSelectorRequirementAssert assertThat(io.fabric8.kubernetes.api.model.LabelSelectorRequirement actual) {
    return new io.fabric8.kubernetes.api.model.LabelSelectorRequirementAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LifecycleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LifecycleAssert assertThat(io.fabric8.kubernetes.api.model.Lifecycle actual) {
    return new io.fabric8.kubernetes.api.model.LifecycleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LimitRangeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LimitRangeAssert assertThat(io.fabric8.kubernetes.api.model.LimitRange actual) {
    return new io.fabric8.kubernetes.api.model.LimitRangeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LimitRangeItemAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LimitRangeItemAssert assertThat(io.fabric8.kubernetes.api.model.LimitRangeItem actual) {
    return new io.fabric8.kubernetes.api.model.LimitRangeItemAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LimitRangeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LimitRangeListAssert assertThat(io.fabric8.kubernetes.api.model.LimitRangeList actual) {
    return new io.fabric8.kubernetes.api.model.LimitRangeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LimitRangeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LimitRangeSpecAssert assertThat(io.fabric8.kubernetes.api.model.LimitRangeSpec actual) {
    return new io.fabric8.kubernetes.api.model.LimitRangeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ListMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ListMetaAssert assertThat(io.fabric8.kubernetes.api.model.ListMeta actual) {
    return new io.fabric8.kubernetes.api.model.ListMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert assertThat(io.fabric8.kubernetes.api.model.LoadBalancerIngress actual) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerIngressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert assertThat(io.fabric8.kubernetes.api.model.LoadBalancerStatus actual) {
    return new io.fabric8.kubernetes.api.model.LoadBalancerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.LocalObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.NFSVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.NFSVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedAuthInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedAuthInfoAssert assertThat(io.fabric8.kubernetes.api.model.NamedAuthInfo actual) {
    return new io.fabric8.kubernetes.api.model.NamedAuthInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedClusterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedClusterAssert assertThat(io.fabric8.kubernetes.api.model.NamedCluster actual) {
    return new io.fabric8.kubernetes.api.model.NamedClusterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedContextAssert assertThat(io.fabric8.kubernetes.api.model.NamedContext actual) {
    return new io.fabric8.kubernetes.api.model.NamedContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamedExtensionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamedExtensionAssert assertThat(io.fabric8.kubernetes.api.model.NamedExtension actual) {
    return new io.fabric8.kubernetes.api.model.NamedExtensionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceAssert assertThat(io.fabric8.kubernetes.api.model.Namespace actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceListAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceList actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceSpecAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceSpec actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NamespaceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NamespaceStatusAssert assertThat(io.fabric8.kubernetes.api.model.NamespaceStatus actual) {
    return new io.fabric8.kubernetes.api.model.NamespaceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAssert assertThat(io.fabric8.kubernetes.api.model.Node actual) {
    return new io.fabric8.kubernetes.api.model.NodeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeAddressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeAddressAssert assertThat(io.fabric8.kubernetes.api.model.NodeAddress actual) {
    return new io.fabric8.kubernetes.api.model.NodeAddressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeConditionAssert assertThat(io.fabric8.kubernetes.api.model.NodeCondition actual) {
    return new io.fabric8.kubernetes.api.model.NodeConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeDaemonEndpointsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeDaemonEndpointsAssert assertThat(io.fabric8.kubernetes.api.model.NodeDaemonEndpoints actual) {
    return new io.fabric8.kubernetes.api.model.NodeDaemonEndpointsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeListAssert assertThat(io.fabric8.kubernetes.api.model.NodeList actual) {
    return new io.fabric8.kubernetes.api.model.NodeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSpecAssert assertThat(io.fabric8.kubernetes.api.model.NodeSpec actual) {
    return new io.fabric8.kubernetes.api.model.NodeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeStatusAssert assertThat(io.fabric8.kubernetes.api.model.NodeStatus actual) {
    return new io.fabric8.kubernetes.api.model.NodeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.NodeSystemInfoAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.NodeSystemInfoAssert assertThat(io.fabric8.kubernetes.api.model.NodeSystemInfo actual) {
    return new io.fabric8.kubernetes.api.model.NodeSystemInfoAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert assertThat(io.fabric8.kubernetes.api.model.ObjectFieldSelector actual) {
    return new io.fabric8.kubernetes.api.model.ObjectFieldSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectMetaAssert assertThat(io.fabric8.kubernetes.api.model.ObjectMeta actual) {
    return new io.fabric8.kubernetes.api.model.ObjectMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ObjectReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ObjectReferenceAssert assertThat(io.fabric8.kubernetes.api.model.ObjectReference actual) {
    return new io.fabric8.kubernetes.api.model.ObjectReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.OwnerReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.OwnerReferenceAssert assertThat(io.fabric8.kubernetes.api.model.OwnerReference actual) {
    return new io.fabric8.kubernetes.api.model.OwnerReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PatchAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PatchAssert assertThat(io.fabric8.kubernetes.api.model.Patch actual) {
    return new io.fabric8.kubernetes.api.model.PatchAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolume actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaim actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimListAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimList actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatus actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeListAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeList actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeSpecAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeSpec actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PersistentVolumeStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PersistentVolumeStatusAssert assertThat(io.fabric8.kubernetes.api.model.PersistentVolumeStatus actual) {
    return new io.fabric8.kubernetes.api.model.PersistentVolumeStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.PhotonPersistentDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodAssert assertThat(io.fabric8.kubernetes.api.model.Pod actual) {
    return new io.fabric8.kubernetes.api.model.PodAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodConditionAssert assertThat(io.fabric8.kubernetes.api.model.PodCondition actual) {
    return new io.fabric8.kubernetes.api.model.PodConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodListAssert assertThat(io.fabric8.kubernetes.api.model.PodList actual) {
    return new io.fabric8.kubernetes.api.model.PodListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodSecurityContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodSecurityContextAssert assertThat(io.fabric8.kubernetes.api.model.PodSecurityContext actual) {
    return new io.fabric8.kubernetes.api.model.PodSecurityContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodSpecAssert assertThat(io.fabric8.kubernetes.api.model.PodSpec actual) {
    return new io.fabric8.kubernetes.api.model.PodSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodStatusAssert assertThat(io.fabric8.kubernetes.api.model.PodStatus actual) {
    return new io.fabric8.kubernetes.api.model.PodStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplate actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateListAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateList actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PodTemplateSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PodTemplateSpecAssert assertThat(io.fabric8.kubernetes.api.model.PodTemplateSpec actual) {
    return new io.fabric8.kubernetes.api.model.PodTemplateSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PreconditionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PreconditionsAssert assertThat(io.fabric8.kubernetes.api.model.Preconditions actual) {
    return new io.fabric8.kubernetes.api.model.PreconditionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.PreferencesAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.PreferencesAssert assertThat(io.fabric8.kubernetes.api.model.Preferences actual) {
    return new io.fabric8.kubernetes.api.model.PreferencesAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ProbeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ProbeAssert assertThat(io.fabric8.kubernetes.api.model.Probe actual) {
    return new io.fabric8.kubernetes.api.model.ProbeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.QuantityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.QuantityAssert assertThat(io.fabric8.kubernetes.api.model.Quantity actual) {
    return new io.fabric8.kubernetes.api.model.QuantityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.QuobyteVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.QuobyteVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.QuobyteVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.QuobyteVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.RBDVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.RBDVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationController actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerConditionAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerCondition actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerListAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerList actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerSpec actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert assertThat(io.fabric8.kubernetes.api.model.ReplicationControllerStatus actual) {
    return new io.fabric8.kubernetes.api.model.ReplicationControllerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceFieldSelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceFieldSelectorAssert assertThat(io.fabric8.kubernetes.api.model.ResourceFieldSelector actual) {
    return new io.fabric8.kubernetes.api.model.ResourceFieldSelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuota actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaListAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaList actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaSpecAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaSpec actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceQuotaStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceQuotaStatusAssert assertThat(io.fabric8.kubernetes.api.model.ResourceQuotaStatus actual) {
    return new io.fabric8.kubernetes.api.model.ResourceQuotaStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ResourceRequirementsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ResourceRequirementsAssert assertThat(io.fabric8.kubernetes.api.model.ResourceRequirements actual) {
    return new io.fabric8.kubernetes.api.model.ResourceRequirementsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RootPathsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RootPathsAssert assertThat(io.fabric8.kubernetes.api.model.RootPaths actual) {
    return new io.fabric8.kubernetes.api.model.RootPathsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.RunAsUserStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.RunAsUserStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.SELinuxContextStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SELinuxOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SELinuxOptionsAssert assertThat(io.fabric8.kubernetes.api.model.SELinuxOptions actual) {
    return new io.fabric8.kubernetes.api.model.SELinuxOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretAssert assertThat(io.fabric8.kubernetes.api.model.Secret actual) {
    return new io.fabric8.kubernetes.api.model.SecretAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretKeySelectorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretKeySelectorAssert assertThat(io.fabric8.kubernetes.api.model.SecretKeySelector actual) {
    return new io.fabric8.kubernetes.api.model.SecretKeySelectorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretListAssert assertThat(io.fabric8.kubernetes.api.model.SecretList actual) {
    return new io.fabric8.kubernetes.api.model.SecretListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.SecretVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.SecretVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContext actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextConstraintsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextConstraintsAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContextConstraints actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextConstraintsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SecurityContextConstraintsListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SecurityContextConstraintsListAssert assertThat(io.fabric8.kubernetes.api.model.SecurityContextConstraintsList actual) {
    return new io.fabric8.kubernetes.api.model.SecurityContextConstraintsListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAssert assertThat(io.fabric8.kubernetes.api.model.Service actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccount actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceAccountListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceAccountListAssert assertThat(io.fabric8.kubernetes.api.model.ServiceAccountList actual) {
    return new io.fabric8.kubernetes.api.model.ServiceAccountListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceListAssert assertThat(io.fabric8.kubernetes.api.model.ServiceList actual) {
    return new io.fabric8.kubernetes.api.model.ServiceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServicePortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServicePortAssert assertThat(io.fabric8.kubernetes.api.model.ServicePort actual) {
    return new io.fabric8.kubernetes.api.model.ServicePortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceSpecAssert assertThat(io.fabric8.kubernetes.api.model.ServiceSpec actual) {
    return new io.fabric8.kubernetes.api.model.ServiceSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.ServiceStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.ServiceStatusAssert assertThat(io.fabric8.kubernetes.api.model.ServiceStatus actual) {
    return new io.fabric8.kubernetes.api.model.ServiceStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusAssert assertThat(io.fabric8.kubernetes.api.model.Status actual) {
    return new io.fabric8.kubernetes.api.model.StatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusCauseAssert assertThat(io.fabric8.kubernetes.api.model.StatusCause actual) {
    return new io.fabric8.kubernetes.api.model.StatusCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.StatusDetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.StatusDetailsAssert assertThat(io.fabric8.kubernetes.api.model.StatusDetails actual) {
    return new io.fabric8.kubernetes.api.model.StatusDetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.SupplementalGroupsStrategyOptionsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.SupplementalGroupsStrategyOptionsAssert assertThat(io.fabric8.kubernetes.api.model.SupplementalGroupsStrategyOptions actual) {
    return new io.fabric8.kubernetes.api.model.SupplementalGroupsStrategyOptionsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.TCPSocketActionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.TCPSocketActionAssert assertThat(io.fabric8.kubernetes.api.model.TCPSocketAction actual) {
    return new io.fabric8.kubernetes.api.model.TCPSocketActionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeAssert assertThat(io.fabric8.kubernetes.api.model.Volume actual) {
    return new io.fabric8.kubernetes.api.model.VolumeAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VolumeMountAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VolumeMountAssert assertThat(io.fabric8.kubernetes.api.model.VolumeMount actual) {
    return new io.fabric8.kubernetes.api.model.VolumeMountAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceAssert assertThat(io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSource actual) {
    return new io.fabric8.kubernetes.api.model.VsphereVirtualDiskVolumeSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.WatchEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.WatchEventAssert assertThat(io.fabric8.kubernetes.api.model.WatchEvent actual) {
    return new io.fabric8.kubernetes.api.model.WatchEventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.APIVersionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.APIVersionAssert assertThat(io.fabric8.kubernetes.api.model.extensions.APIVersion actual) {
    return new io.fabric8.kubernetes.api.model.extensions.APIVersionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.CPUTargetUtilizationAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.CPUTargetUtilizationAssert assertThat(io.fabric8.kubernetes.api.model.extensions.CPUTargetUtilization actual) {
    return new io.fabric8.kubernetes.api.model.extensions.CPUTargetUtilizationAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.DaemonSetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.DaemonSetAssert assertThat(io.fabric8.kubernetes.api.model.extensions.DaemonSet actual) {
    return new io.fabric8.kubernetes.api.model.extensions.DaemonSetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.DaemonSetListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.DaemonSetListAssert assertThat(io.fabric8.kubernetes.api.model.extensions.DaemonSetList actual) {
    return new io.fabric8.kubernetes.api.model.extensions.DaemonSetListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecAssert assertThat(io.fabric8.kubernetes.api.model.extensions.DaemonSetSpec actual) {
    return new io.fabric8.kubernetes.api.model.extensions.DaemonSetSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusAssert assertThat(io.fabric8.kubernetes.api.model.extensions.DaemonSetStatus actual) {
    return new io.fabric8.kubernetes.api.model.extensions.DaemonSetStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.DeploymentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.DeploymentAssert assertThat(io.fabric8.kubernetes.api.model.extensions.Deployment actual) {
    return new io.fabric8.kubernetes.api.model.extensions.DeploymentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.DeploymentConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.DeploymentConditionAssert assertThat(io.fabric8.kubernetes.api.model.extensions.DeploymentCondition actual) {
    return new io.fabric8.kubernetes.api.model.extensions.DeploymentConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.DeploymentListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.DeploymentListAssert assertThat(io.fabric8.kubernetes.api.model.extensions.DeploymentList actual) {
    return new io.fabric8.kubernetes.api.model.extensions.DeploymentListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackAssert assertThat(io.fabric8.kubernetes.api.model.extensions.DeploymentRollback actual) {
    return new io.fabric8.kubernetes.api.model.extensions.DeploymentRollbackAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.DeploymentSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.DeploymentSpecAssert assertThat(io.fabric8.kubernetes.api.model.extensions.DeploymentSpec actual) {
    return new io.fabric8.kubernetes.api.model.extensions.DeploymentSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.DeploymentStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.DeploymentStatusAssert assertThat(io.fabric8.kubernetes.api.model.extensions.DeploymentStatus actual) {
    return new io.fabric8.kubernetes.api.model.extensions.DeploymentStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.DeploymentStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.DeploymentStrategyAssert assertThat(io.fabric8.kubernetes.api.model.extensions.DeploymentStrategy actual) {
    return new io.fabric8.kubernetes.api.model.extensions.DeploymentStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathAssert assertThat(io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath actual) {
    return new io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueAssert assertThat(io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValue actual) {
    return new io.fabric8.kubernetes.api.model.extensions.HTTPIngressRuleValueAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerAssert assertThat(io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler actual) {
    return new io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerListAssert assertThat(io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerList actual) {
    return new io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpecAssert assertThat(io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpec actual) {
    return new io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerStatusAssert assertThat(io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerStatus actual) {
    return new io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.IngressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.IngressAssert assertThat(io.fabric8.kubernetes.api.model.extensions.Ingress actual) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.IngressBackendAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.IngressBackendAssert assertThat(io.fabric8.kubernetes.api.model.extensions.IngressBackend actual) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressBackendAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.IngressListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.IngressListAssert assertThat(io.fabric8.kubernetes.api.model.extensions.IngressList actual) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.IngressRuleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.IngressRuleAssert assertThat(io.fabric8.kubernetes.api.model.extensions.IngressRule actual) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressRuleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.IngressSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.IngressSpecAssert assertThat(io.fabric8.kubernetes.api.model.extensions.IngressSpec actual) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.IngressStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.IngressStatusAssert assertThat(io.fabric8.kubernetes.api.model.extensions.IngressStatus actual) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.IngressTLSAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.IngressTLSAssert assertThat(io.fabric8.kubernetes.api.model.extensions.IngressTLS actual) {
    return new io.fabric8.kubernetes.api.model.extensions.IngressTLSAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.ReplicaSetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.ReplicaSetAssert assertThat(io.fabric8.kubernetes.api.model.extensions.ReplicaSet actual) {
    return new io.fabric8.kubernetes.api.model.extensions.ReplicaSetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.ReplicaSetConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.ReplicaSetConditionAssert assertThat(io.fabric8.kubernetes.api.model.extensions.ReplicaSetCondition actual) {
    return new io.fabric8.kubernetes.api.model.extensions.ReplicaSetConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.ReplicaSetListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.ReplicaSetListAssert assertThat(io.fabric8.kubernetes.api.model.extensions.ReplicaSetList actual) {
    return new io.fabric8.kubernetes.api.model.extensions.ReplicaSetListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecAssert assertThat(io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpec actual) {
    return new io.fabric8.kubernetes.api.model.extensions.ReplicaSetSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusAssert assertThat(io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatus actual) {
    return new io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.RollbackConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.RollbackConfigAssert assertThat(io.fabric8.kubernetes.api.model.extensions.RollbackConfig actual) {
    return new io.fabric8.kubernetes.api.model.extensions.RollbackConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeploymentAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeploymentAssert assertThat(io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeployment actual) {
    return new io.fabric8.kubernetes.api.model.extensions.RollingUpdateDeploymentAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.ScaleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.ScaleAssert assertThat(io.fabric8.kubernetes.api.model.extensions.Scale actual) {
    return new io.fabric8.kubernetes.api.model.extensions.ScaleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.ScaleSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.ScaleSpecAssert assertThat(io.fabric8.kubernetes.api.model.extensions.ScaleSpec actual) {
    return new io.fabric8.kubernetes.api.model.extensions.ScaleSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.ScaleStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.ScaleStatusAssert assertThat(io.fabric8.kubernetes.api.model.extensions.ScaleStatus actual) {
    return new io.fabric8.kubernetes.api.model.extensions.ScaleStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.StatefulSetAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.StatefulSetAssert assertThat(io.fabric8.kubernetes.api.model.extensions.StatefulSet actual) {
    return new io.fabric8.kubernetes.api.model.extensions.StatefulSetAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.StatefulSetListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.StatefulSetListAssert assertThat(io.fabric8.kubernetes.api.model.extensions.StatefulSetList actual) {
    return new io.fabric8.kubernetes.api.model.extensions.StatefulSetListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.StatefulSetSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.StatefulSetSpecAssert assertThat(io.fabric8.kubernetes.api.model.extensions.StatefulSetSpec actual) {
    return new io.fabric8.kubernetes.api.model.extensions.StatefulSetSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.StatefulSetStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.StatefulSetStatusAssert assertThat(io.fabric8.kubernetes.api.model.extensions.StatefulSetStatus actual) {
    return new io.fabric8.kubernetes.api.model.extensions.StatefulSetStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.SubresourceReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.SubresourceReferenceAssert assertThat(io.fabric8.kubernetes.api.model.extensions.SubresourceReference actual) {
    return new io.fabric8.kubernetes.api.model.extensions.SubresourceReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceAssert assertThat(io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource actual) {
    return new io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceListAssert assertThat(io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceList actual) {
    return new io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.validators.CheckObjectMetaAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.validators.CheckObjectMetaAssert assertThat(io.fabric8.kubernetes.api.model.validators.CheckObjectMeta actual) {
    return new io.fabric8.kubernetes.api.model.validators.CheckObjectMetaAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.kubernetes.api.model.validators.ObjectMetaValidatorAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.kubernetes.api.model.validators.ObjectMetaValidatorAssert assertThat(io.fabric8.kubernetes.api.model.validators.ObjectMetaValidator actual) {
    return new io.fabric8.kubernetes.api.model.validators.ObjectMetaValidatorAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BinaryBuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BinaryBuildSourceAssert assertThat(io.fabric8.openshift.api.model.BinaryBuildSource actual) {
    return new io.fabric8.openshift.api.model.BinaryBuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildAssert assertThat(io.fabric8.openshift.api.model.Build actual) {
    return new io.fabric8.openshift.api.model.BuildAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigAssert assertThat(io.fabric8.openshift.api.model.BuildConfig actual) {
    return new io.fabric8.openshift.api.model.BuildConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigListAssert assertThat(io.fabric8.openshift.api.model.BuildConfigList actual) {
    return new io.fabric8.openshift.api.model.BuildConfigListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigSpecAssert assertThat(io.fabric8.openshift.api.model.BuildConfigSpec actual) {
    return new io.fabric8.openshift.api.model.BuildConfigSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildConfigStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildConfigStatusAssert assertThat(io.fabric8.openshift.api.model.BuildConfigStatus actual) {
    return new io.fabric8.openshift.api.model.BuildConfigStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildListAssert assertThat(io.fabric8.openshift.api.model.BuildList actual) {
    return new io.fabric8.openshift.api.model.BuildListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildOutputAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildOutputAssert assertThat(io.fabric8.openshift.api.model.BuildOutput actual) {
    return new io.fabric8.openshift.api.model.BuildOutputAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildPostCommitSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildPostCommitSpecAssert assertThat(io.fabric8.openshift.api.model.BuildPostCommitSpec actual) {
    return new io.fabric8.openshift.api.model.BuildPostCommitSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildRequestAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildRequestAssert assertThat(io.fabric8.openshift.api.model.BuildRequest actual) {
    return new io.fabric8.openshift.api.model.BuildRequestAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildSourceAssert assertThat(io.fabric8.openshift.api.model.BuildSource actual) {
    return new io.fabric8.openshift.api.model.BuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildSpecAssert assertThat(io.fabric8.openshift.api.model.BuildSpec actual) {
    return new io.fabric8.openshift.api.model.BuildSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildStatusAssert assertThat(io.fabric8.openshift.api.model.BuildStatus actual) {
    return new io.fabric8.openshift.api.model.BuildStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildStatusOutputAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildStatusOutputAssert assertThat(io.fabric8.openshift.api.model.BuildStatusOutput actual) {
    return new io.fabric8.openshift.api.model.BuildStatusOutputAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildStatusOutputToAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildStatusOutputToAssert assertThat(io.fabric8.openshift.api.model.BuildStatusOutputTo actual) {
    return new io.fabric8.openshift.api.model.BuildStatusOutputToAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildStrategyAssert assertThat(io.fabric8.openshift.api.model.BuildStrategy actual) {
    return new io.fabric8.openshift.api.model.BuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildTriggerCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildTriggerCauseAssert assertThat(io.fabric8.openshift.api.model.BuildTriggerCause actual) {
    return new io.fabric8.openshift.api.model.BuildTriggerCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.BuildTriggerPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.BuildTriggerPolicyAssert assertThat(io.fabric8.openshift.api.model.BuildTriggerPolicy actual) {
    return new io.fabric8.openshift.api.model.BuildTriggerPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicy actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyBindingAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicyBinding actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyBindingListAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicyBindingList actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterPolicyListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterPolicyListAssert assertThat(io.fabric8.openshift.api.model.ClusterPolicyList actual) {
    return new io.fabric8.openshift.api.model.ClusterPolicyListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterRoleAssert assertThat(io.fabric8.openshift.api.model.ClusterRole actual) {
    return new io.fabric8.openshift.api.model.ClusterRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterRoleBindingAssert assertThat(io.fabric8.openshift.api.model.ClusterRoleBinding actual) {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterRoleBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterRoleBindingListAssert assertThat(io.fabric8.openshift.api.model.ClusterRoleBindingList actual) {
    return new io.fabric8.openshift.api.model.ClusterRoleBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ClusterRoleScopeRestrictionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ClusterRoleScopeRestrictionAssert assertThat(io.fabric8.openshift.api.model.ClusterRoleScopeRestriction actual) {
    return new io.fabric8.openshift.api.model.ClusterRoleScopeRestrictionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.CustomBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.CustomBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.CustomBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.CustomBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.CustomDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.CustomDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentCauseAssert assertThat(io.fabric8.openshift.api.model.DeploymentCause actual) {
    return new io.fabric8.openshift.api.model.DeploymentCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentCauseImageTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentCauseImageTriggerAssert assertThat(io.fabric8.openshift.api.model.DeploymentCauseImageTrigger actual) {
    return new io.fabric8.openshift.api.model.DeploymentCauseImageTriggerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConditionAssert assertThat(io.fabric8.openshift.api.model.DeploymentCondition actual) {
    return new io.fabric8.openshift.api.model.DeploymentConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfig actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigListAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigList actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigSpecAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigSpec actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentConfigStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentConfigStatusAssert assertThat(io.fabric8.openshift.api.model.DeploymentConfigStatus actual) {
    return new io.fabric8.openshift.api.model.DeploymentConfigStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentDetailsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentDetailsAssert assertThat(io.fabric8.openshift.api.model.DeploymentDetails actual) {
    return new io.fabric8.openshift.api.model.DeploymentDetailsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentStrategyAssert assertThat(io.fabric8.openshift.api.model.DeploymentStrategy actual) {
    return new io.fabric8.openshift.api.model.DeploymentStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsAssert assertThat(io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParams actual) {
    return new io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DeploymentTriggerPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DeploymentTriggerPolicyAssert assertThat(io.fabric8.openshift.api.model.DeploymentTriggerPolicy actual) {
    return new io.fabric8.openshift.api.model.DeploymentTriggerPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.DockerBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.DockerBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.DockerBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.DockerBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ExecNewPodHookAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ExecNewPodHookAssert assertThat(io.fabric8.openshift.api.model.ExecNewPodHook actual) {
    return new io.fabric8.openshift.api.model.ExecNewPodHookAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GenericWebHookCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GenericWebHookCauseAssert assertThat(io.fabric8.openshift.api.model.GenericWebHookCause actual) {
    return new io.fabric8.openshift.api.model.GenericWebHookCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GitBuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GitBuildSourceAssert assertThat(io.fabric8.openshift.api.model.GitBuildSource actual) {
    return new io.fabric8.openshift.api.model.GitBuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GitHubWebHookCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GitHubWebHookCauseAssert assertThat(io.fabric8.openshift.api.model.GitHubWebHookCause actual) {
    return new io.fabric8.openshift.api.model.GitHubWebHookCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GitSourceRevisionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GitSourceRevisionAssert assertThat(io.fabric8.openshift.api.model.GitSourceRevision actual) {
    return new io.fabric8.openshift.api.model.GitSourceRevisionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GroupAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GroupAssert assertThat(io.fabric8.openshift.api.model.Group actual) {
    return new io.fabric8.openshift.api.model.GroupAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.GroupListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.GroupListAssert assertThat(io.fabric8.openshift.api.model.GroupList actual) {
    return new io.fabric8.openshift.api.model.GroupListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.IdentityAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.IdentityAssert assertThat(io.fabric8.openshift.api.model.Identity actual) {
    return new io.fabric8.openshift.api.model.IdentityAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.IdentityListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.IdentityListAssert assertThat(io.fabric8.openshift.api.model.IdentityList actual) {
    return new io.fabric8.openshift.api.model.IdentityListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageAssert assertThat(io.fabric8.openshift.api.model.Image actual) {
    return new io.fabric8.openshift.api.model.ImageAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageChangeCauseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageChangeCauseAssert assertThat(io.fabric8.openshift.api.model.ImageChangeCause actual) {
    return new io.fabric8.openshift.api.model.ImageChangeCauseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageChangeTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageChangeTriggerAssert assertThat(io.fabric8.openshift.api.model.ImageChangeTrigger actual) {
    return new io.fabric8.openshift.api.model.ImageChangeTriggerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageLabelAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageLabelAssert assertThat(io.fabric8.openshift.api.model.ImageLabel actual) {
    return new io.fabric8.openshift.api.model.ImageLabelAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageLayerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageLayerAssert assertThat(io.fabric8.openshift.api.model.ImageLayer actual) {
    return new io.fabric8.openshift.api.model.ImageLayerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageListAssert assertThat(io.fabric8.openshift.api.model.ImageList actual) {
    return new io.fabric8.openshift.api.model.ImageListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageSignatureAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageSignatureAssert assertThat(io.fabric8.openshift.api.model.ImageSignature actual) {
    return new io.fabric8.openshift.api.model.ImageSignatureAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageSourceAssert assertThat(io.fabric8.openshift.api.model.ImageSource actual) {
    return new io.fabric8.openshift.api.model.ImageSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageSourcePathAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageSourcePathAssert assertThat(io.fabric8.openshift.api.model.ImageSourcePath actual) {
    return new io.fabric8.openshift.api.model.ImageSourcePathAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamAssert assertThat(io.fabric8.openshift.api.model.ImageStream actual) {
    return new io.fabric8.openshift.api.model.ImageStreamAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamListAssert assertThat(io.fabric8.openshift.api.model.ImageStreamList actual) {
    return new io.fabric8.openshift.api.model.ImageStreamListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamSpecAssert assertThat(io.fabric8.openshift.api.model.ImageStreamSpec actual) {
    return new io.fabric8.openshift.api.model.ImageStreamSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamStatusAssert assertThat(io.fabric8.openshift.api.model.ImageStreamStatus actual) {
    return new io.fabric8.openshift.api.model.ImageStreamStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamTagAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamTagAssert assertThat(io.fabric8.openshift.api.model.ImageStreamTag actual) {
    return new io.fabric8.openshift.api.model.ImageStreamTagAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ImageStreamTagListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ImageStreamTagListAssert assertThat(io.fabric8.openshift.api.model.ImageStreamTagList actual) {
    return new io.fabric8.openshift.api.model.ImageStreamTagListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.JenkinsPipelineBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.JenkinsPipelineBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.JenkinsPipelineBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.JenkinsPipelineBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.LifecycleHookAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.LifecycleHookAssert assertThat(io.fabric8.openshift.api.model.LifecycleHook actual) {
    return new io.fabric8.openshift.api.model.LifecycleHookAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.LocalSubjectAccessReviewAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.LocalSubjectAccessReviewAssert assertThat(io.fabric8.openshift.api.model.LocalSubjectAccessReview actual) {
    return new io.fabric8.openshift.api.model.LocalSubjectAccessReviewAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedClusterRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedClusterRoleAssert assertThat(io.fabric8.openshift.api.model.NamedClusterRole actual) {
    return new io.fabric8.openshift.api.model.NamedClusterRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedClusterRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedClusterRoleBindingAssert assertThat(io.fabric8.openshift.api.model.NamedClusterRoleBinding actual) {
    return new io.fabric8.openshift.api.model.NamedClusterRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedRoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedRoleAssert assertThat(io.fabric8.openshift.api.model.NamedRole actual) {
    return new io.fabric8.openshift.api.model.NamedRoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedRoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedRoleBindingAssert assertThat(io.fabric8.openshift.api.model.NamedRoleBinding actual) {
    return new io.fabric8.openshift.api.model.NamedRoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.NamedTagEventListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.NamedTagEventListAssert assertThat(io.fabric8.openshift.api.model.NamedTagEventList actual) {
    return new io.fabric8.openshift.api.model.NamedTagEventListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAccessTokenAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAccessTokenAssert assertThat(io.fabric8.openshift.api.model.OAuthAccessToken actual) {
    return new io.fabric8.openshift.api.model.OAuthAccessTokenAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAccessTokenListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAccessTokenListAssert assertThat(io.fabric8.openshift.api.model.OAuthAccessTokenList actual) {
    return new io.fabric8.openshift.api.model.OAuthAccessTokenListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAuthorizeTokenAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAuthorizeTokenAssert assertThat(io.fabric8.openshift.api.model.OAuthAuthorizeToken actual) {
    return new io.fabric8.openshift.api.model.OAuthAuthorizeTokenAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthAuthorizeTokenListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthAuthorizeTokenListAssert assertThat(io.fabric8.openshift.api.model.OAuthAuthorizeTokenList actual) {
    return new io.fabric8.openshift.api.model.OAuthAuthorizeTokenListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientAssert assertThat(io.fabric8.openshift.api.model.OAuthClient actual) {
    return new io.fabric8.openshift.api.model.OAuthClientAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientAuthorizationAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientAuthorizationAssert assertThat(io.fabric8.openshift.api.model.OAuthClientAuthorization actual) {
    return new io.fabric8.openshift.api.model.OAuthClientAuthorizationAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientAuthorizationListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientAuthorizationListAssert assertThat(io.fabric8.openshift.api.model.OAuthClientAuthorizationList actual) {
    return new io.fabric8.openshift.api.model.OAuthClientAuthorizationListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.OAuthClientListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.OAuthClientListAssert assertThat(io.fabric8.openshift.api.model.OAuthClientList actual) {
    return new io.fabric8.openshift.api.model.OAuthClientListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ParameterAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ParameterAssert assertThat(io.fabric8.openshift.api.model.Parameter actual) {
    return new io.fabric8.openshift.api.model.ParameterAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyAssert assertThat(io.fabric8.openshift.api.model.Policy actual) {
    return new io.fabric8.openshift.api.model.PolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyBindingAssert assertThat(io.fabric8.openshift.api.model.PolicyBinding actual) {
    return new io.fabric8.openshift.api.model.PolicyBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyBindingListAssert assertThat(io.fabric8.openshift.api.model.PolicyBindingList actual) {
    return new io.fabric8.openshift.api.model.PolicyBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyListAssert assertThat(io.fabric8.openshift.api.model.PolicyList actual) {
    return new io.fabric8.openshift.api.model.PolicyListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.PolicyRuleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.PolicyRuleAssert assertThat(io.fabric8.openshift.api.model.PolicyRule actual) {
    return new io.fabric8.openshift.api.model.PolicyRuleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ProjectAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ProjectAssert assertThat(io.fabric8.openshift.api.model.Project actual) {
    return new io.fabric8.openshift.api.model.ProjectAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ProjectListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ProjectListAssert assertThat(io.fabric8.openshift.api.model.ProjectList actual) {
    return new io.fabric8.openshift.api.model.ProjectListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ProjectRequestAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ProjectRequestAssert assertThat(io.fabric8.openshift.api.model.ProjectRequest actual) {
    return new io.fabric8.openshift.api.model.ProjectRequestAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ProjectSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ProjectSpecAssert assertThat(io.fabric8.openshift.api.model.ProjectSpec actual) {
    return new io.fabric8.openshift.api.model.ProjectSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ProjectStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ProjectStatusAssert assertThat(io.fabric8.openshift.api.model.ProjectStatus actual) {
    return new io.fabric8.openshift.api.model.ProjectStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.RecreateDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.RecreateDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleAssert assertThat(io.fabric8.openshift.api.model.Role actual) {
    return new io.fabric8.openshift.api.model.RoleAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleBindingAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleBindingAssert assertThat(io.fabric8.openshift.api.model.RoleBinding actual) {
    return new io.fabric8.openshift.api.model.RoleBindingAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleBindingListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleBindingListAssert assertThat(io.fabric8.openshift.api.model.RoleBindingList actual) {
    return new io.fabric8.openshift.api.model.RoleBindingListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoleListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoleListAssert assertThat(io.fabric8.openshift.api.model.RoleList actual) {
    return new io.fabric8.openshift.api.model.RoleListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsAssert assertThat(io.fabric8.openshift.api.model.RollingDeploymentStrategyParams actual) {
    return new io.fabric8.openshift.api.model.RollingDeploymentStrategyParamsAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteAssert assertThat(io.fabric8.openshift.api.model.Route actual) {
    return new io.fabric8.openshift.api.model.RouteAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteIngressAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteIngressAssert assertThat(io.fabric8.openshift.api.model.RouteIngress actual) {
    return new io.fabric8.openshift.api.model.RouteIngressAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteIngressConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteIngressConditionAssert assertThat(io.fabric8.openshift.api.model.RouteIngressCondition actual) {
    return new io.fabric8.openshift.api.model.RouteIngressConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteListAssert assertThat(io.fabric8.openshift.api.model.RouteList actual) {
    return new io.fabric8.openshift.api.model.RouteListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RoutePortAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RoutePortAssert assertThat(io.fabric8.openshift.api.model.RoutePort actual) {
    return new io.fabric8.openshift.api.model.RoutePortAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteSpecAssert assertThat(io.fabric8.openshift.api.model.RouteSpec actual) {
    return new io.fabric8.openshift.api.model.RouteSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteStatusAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteStatusAssert assertThat(io.fabric8.openshift.api.model.RouteStatus actual) {
    return new io.fabric8.openshift.api.model.RouteStatusAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.RouteTargetReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.RouteTargetReferenceAssert assertThat(io.fabric8.openshift.api.model.RouteTargetReference actual) {
    return new io.fabric8.openshift.api.model.RouteTargetReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.ScopeRestrictionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.ScopeRestrictionAssert assertThat(io.fabric8.openshift.api.model.ScopeRestriction actual) {
    return new io.fabric8.openshift.api.model.ScopeRestrictionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SecretBuildSourceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SecretBuildSourceAssert assertThat(io.fabric8.openshift.api.model.SecretBuildSource actual) {
    return new io.fabric8.openshift.api.model.SecretBuildSourceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SecretSpecAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SecretSpecAssert assertThat(io.fabric8.openshift.api.model.SecretSpec actual) {
    return new io.fabric8.openshift.api.model.SecretSpecAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SignatureConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SignatureConditionAssert assertThat(io.fabric8.openshift.api.model.SignatureCondition actual) {
    return new io.fabric8.openshift.api.model.SignatureConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SignatureIssuerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SignatureIssuerAssert assertThat(io.fabric8.openshift.api.model.SignatureIssuer actual) {
    return new io.fabric8.openshift.api.model.SignatureIssuerAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SignatureSubjectAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SignatureSubjectAssert assertThat(io.fabric8.openshift.api.model.SignatureSubject actual) {
    return new io.fabric8.openshift.api.model.SignatureSubjectAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceBuildStrategyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceBuildStrategyAssert assertThat(io.fabric8.openshift.api.model.SourceBuildStrategy actual) {
    return new io.fabric8.openshift.api.model.SourceBuildStrategyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceControlUserAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceControlUserAssert assertThat(io.fabric8.openshift.api.model.SourceControlUser actual) {
    return new io.fabric8.openshift.api.model.SourceControlUserAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SourceRevisionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SourceRevisionAssert assertThat(io.fabric8.openshift.api.model.SourceRevision actual) {
    return new io.fabric8.openshift.api.model.SourceRevisionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SubjectAccessReviewAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SubjectAccessReviewAssert assertThat(io.fabric8.openshift.api.model.SubjectAccessReview actual) {
    return new io.fabric8.openshift.api.model.SubjectAccessReviewAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.SubjectAccessReviewResponseAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.SubjectAccessReviewResponseAssert assertThat(io.fabric8.openshift.api.model.SubjectAccessReviewResponse actual) {
    return new io.fabric8.openshift.api.model.SubjectAccessReviewResponseAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TLSConfigAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TLSConfigAssert assertThat(io.fabric8.openshift.api.model.TLSConfig actual) {
    return new io.fabric8.openshift.api.model.TLSConfigAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagEventAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagEventAssert assertThat(io.fabric8.openshift.api.model.TagEvent actual) {
    return new io.fabric8.openshift.api.model.TagEventAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagEventConditionAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagEventConditionAssert assertThat(io.fabric8.openshift.api.model.TagEventCondition actual) {
    return new io.fabric8.openshift.api.model.TagEventConditionAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagImageHookAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagImageHookAssert assertThat(io.fabric8.openshift.api.model.TagImageHook actual) {
    return new io.fabric8.openshift.api.model.TagImageHookAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagImportPolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagImportPolicyAssert assertThat(io.fabric8.openshift.api.model.TagImportPolicy actual) {
    return new io.fabric8.openshift.api.model.TagImportPolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagReferenceAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagReferenceAssert assertThat(io.fabric8.openshift.api.model.TagReference actual) {
    return new io.fabric8.openshift.api.model.TagReferenceAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TagReferencePolicyAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TagReferencePolicyAssert assertThat(io.fabric8.openshift.api.model.TagReferencePolicy actual) {
    return new io.fabric8.openshift.api.model.TagReferencePolicyAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TemplateAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TemplateAssert assertThat(io.fabric8.openshift.api.model.Template actual) {
    return new io.fabric8.openshift.api.model.TemplateAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.TemplateListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.TemplateListAssert assertThat(io.fabric8.openshift.api.model.TemplateList actual) {
    return new io.fabric8.openshift.api.model.TemplateListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.UserAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.UserAssert assertThat(io.fabric8.openshift.api.model.User actual) {
    return new io.fabric8.openshift.api.model.UserAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.UserListAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.UserListAssert assertThat(io.fabric8.openshift.api.model.UserList actual) {
    return new io.fabric8.openshift.api.model.UserListAssert(actual);
  }

  /**
   * Creates a new instance of <code>{@link io.fabric8.openshift.api.model.WebHookTriggerAssert}</code>.
   *
   * @param actual the actual value.
   * @return the created assertion object.
   */
  public static io.fabric8.openshift.api.model.WebHookTriggerAssert assertThat(io.fabric8.openshift.api.model.WebHookTrigger actual) {
    return new io.fabric8.openshift.api.model.WebHookTriggerAssert(actual);
  }

  /**
   * Creates a new <code>{@link Assertions}</code>.
   */
  protected Assertions() {
    // empty
  }
}
