package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ImageChangeCause} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractImageChangeCauseAssert<S extends AbstractImageChangeCauseAssert<S, A>, A extends ImageChangeCause> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractImageChangeCauseAssert}</code> to make assertions on actual ImageChangeCause.
   * @param actual the ImageChangeCause we want to make assertions on.
   */
  protected AbstractImageChangeCauseAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ImageChangeCause we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property fromRef so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectReferenceAssert fromRef()  {
    // check that actual ImageChangeCause we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectReferenceAssert) assertThat(actual.getFromRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fromRef"));
  }


  /**
   * Navigates to the property imageID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert imageID()  {
    // check that actual ImageChangeCause we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getImageID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imageID"));
  }


}
