package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ResourceQuotaSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractResourceQuotaSpecAssert<S extends AbstractResourceQuotaSpecAssert<S, A>, A extends ResourceQuotaSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractResourceQuotaSpecAssert}</code> to make assertions on actual ResourceQuotaSpec.
   * @param actual the ResourceQuotaSpec we want to make assertions on.
   */
  protected AbstractResourceQuotaSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ResourceQuotaSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property hard so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert hard()  {
    // check that actual ResourceQuotaSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getHard()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hard"));
  }


  /**
   * Navigates to the property scopes so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> scopes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getScopes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "scopes"));
    return answer;
  }


}
