package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link DeploymentConfigStatus} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractDeploymentConfigStatusAssert<S extends AbstractDeploymentConfigStatusAssert<S, A>, A extends DeploymentConfigStatus> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractDeploymentConfigStatusAssert}</code> to make assertions on actual DeploymentConfigStatus.
   * @param actual the DeploymentConfigStatus we want to make assertions on.
   */
  protected AbstractDeploymentConfigStatusAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual DeploymentConfigStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Verifies that the actual DeploymentConfigStatus's availableReplicas is equal to the given one.
   * @param availableReplicas the given availableReplicas to compare the actual DeploymentConfigStatus's availableReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigStatus's availableReplicas is not equal to the given one.
   */
  public S hasAvailableReplicas(Integer availableReplicas) {
    // check that actual DeploymentConfigStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting availableReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualAvailableReplicas = actual.getAvailableReplicas();
    if (!Objects.areEqual(actualAvailableReplicas, availableReplicas)) {
      failWithMessage(assertjErrorMessage, actual, availableReplicas, actualAvailableReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property conditions so that assertions can be done on it
   */
  public NavigationListAssert<DeploymentCondition, DeploymentConditionAssert> conditions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<DeploymentCondition, DeploymentConditionAssert> assertFactory = new AssertFactory<DeploymentCondition, DeploymentConditionAssert>() {
      public DeploymentConditionAssert createAssert(DeploymentCondition t) {
        return (DeploymentConditionAssert) assertThat(t);
      }
    };
    NavigationListAssert<DeploymentCondition, DeploymentConditionAssert> answer = new NavigationListAssert<DeploymentCondition, DeploymentConditionAssert>(actual.getConditions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"));
    return answer;
  }


  /**
   * Navigates to the property details so that assertions can be done on it
   */
  public DeploymentDetailsAssert details()  {
    // check that actual DeploymentConfigStatus we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (DeploymentDetailsAssert) assertThat(actual.getDetails()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "details"));
  }


  /**
   * Verifies that the actual DeploymentConfigStatus's latestVersion is equal to the given one.
   * @param latestVersion the given latestVersion to compare the actual DeploymentConfigStatus's latestVersion to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigStatus's latestVersion is not equal to the given one.
   */
  public S hasLatestVersion(Long latestVersion) {
    // check that actual DeploymentConfigStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting latestVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualLatestVersion = actual.getLatestVersion();
    if (!Objects.areEqual(actualLatestVersion, latestVersion)) {
      failWithMessage(assertjErrorMessage, actual, latestVersion, actualLatestVersion);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigStatus's observedGeneration is equal to the given one.
   * @param observedGeneration the given observedGeneration to compare the actual DeploymentConfigStatus's observedGeneration to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigStatus's observedGeneration is not equal to the given one.
   */
  public S hasObservedGeneration(Long observedGeneration) {
    // check that actual DeploymentConfigStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting observedGeneration of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualObservedGeneration = actual.getObservedGeneration();
    if (!Objects.areEqual(actualObservedGeneration, observedGeneration)) {
      failWithMessage(assertjErrorMessage, actual, observedGeneration, actualObservedGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigStatus's readyReplicas is equal to the given one.
   * @param readyReplicas the given readyReplicas to compare the actual DeploymentConfigStatus's readyReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigStatus's readyReplicas is not equal to the given one.
   */
  public S hasReadyReplicas(Integer readyReplicas) {
    // check that actual DeploymentConfigStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting readyReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReadyReplicas = actual.getReadyReplicas();
    if (!Objects.areEqual(actualReadyReplicas, readyReplicas)) {
      failWithMessage(assertjErrorMessage, actual, readyReplicas, actualReadyReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigStatus's replicas is equal to the given one.
   * @param replicas the given replicas to compare the actual DeploymentConfigStatus's replicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigStatus's replicas is not equal to the given one.
   */
  public S hasReplicas(Integer replicas) {
    // check that actual DeploymentConfigStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting replicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualReplicas = actual.getReplicas();
    if (!Objects.areEqual(actualReplicas, replicas)) {
      failWithMessage(assertjErrorMessage, actual, replicas, actualReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigStatus's unavailableReplicas is equal to the given one.
   * @param unavailableReplicas the given unavailableReplicas to compare the actual DeploymentConfigStatus's unavailableReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigStatus's unavailableReplicas is not equal to the given one.
   */
  public S hasUnavailableReplicas(Integer unavailableReplicas) {
    // check that actual DeploymentConfigStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting unavailableReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualUnavailableReplicas = actual.getUnavailableReplicas();
    if (!Objects.areEqual(actualUnavailableReplicas, unavailableReplicas)) {
      failWithMessage(assertjErrorMessage, actual, unavailableReplicas, actualUnavailableReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual DeploymentConfigStatus's updatedReplicas is equal to the given one.
   * @param updatedReplicas the given updatedReplicas to compare the actual DeploymentConfigStatus's updatedReplicas to.
   * @return this assertion object.
   * @throws AssertionError - if the actual DeploymentConfigStatus's updatedReplicas is not equal to the given one.
   */
  public S hasUpdatedReplicas(Integer updatedReplicas) {
    // check that actual DeploymentConfigStatus we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting updatedReplicas of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Integer actualUpdatedReplicas = actual.getUpdatedReplicas();
    if (!Objects.areEqual(actualUpdatedReplicas, updatedReplicas)) {
      failWithMessage(assertjErrorMessage, actual, updatedReplicas, actualUpdatedReplicas);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
