package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link VolumeMount} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractVolumeMountAssert<S extends AbstractVolumeMountAssert<S, A>, A extends VolumeMount> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractVolumeMountAssert}</code> to make assertions on actual VolumeMount.
   * @param actual the VolumeMount we want to make assertions on.
   */
  protected AbstractVolumeMountAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual VolumeMount we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property mountPath so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert mountPath()  {
    // check that actual VolumeMount we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getMountPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "mountPath"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual VolumeMount we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property readOnly so that assertions can be done on it
   */
  public org.assertj.core.api.BooleanAssert readOnly()  {
    // check that actual VolumeMount we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.BooleanAssert) assertThat(actual.getReadOnly()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "readOnly"));
  }


  /**
   * Navigates to the property subPath so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert subPath()  {
    // check that actual VolumeMount we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSubPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subPath"));
  }


}
