/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.assertions.support.PodWatcher;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Java6Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodSelectionAssert {
    public static final String PROPERTY_ASSERT_NOT_READY_TIMEOUT_MILLIS = "fabric8.assert.notReadyTimeoutMills";
    public static final String PROPERTY_ASSERT_READY_PERIOD_MILLIS = "fabric8.assert.readyPeriodMills";
    public static final long DEFAULT_NOT_READY_TIMEOUT_MS = 300000L;
    public static final long DEFAULT_READY_PERIOD_MS = 10000L;
    private static final transient Logger LOG = LoggerFactory.getLogger(PodSelectionAssert.class);
    private final KubernetesClient client;
    private final Integer replicas;
    private final Map<String, String> matchLabels;
    private final List<LabelSelectorRequirement> matchExpressions;
    private final String description;

    public static long getDefaultReadyPeriodMs() {
        return PodSelectionAssert.parseLongValue(Systems.getEnvVarOrSystemProperty((String)PROPERTY_ASSERT_READY_PERIOD_MILLIS), 10000L);
    }

    public static long getDefaultNotReadyTimeoutMs() {
        return PodSelectionAssert.parseLongValue(Systems.getEnvVarOrSystemProperty((String)PROPERTY_ASSERT_NOT_READY_TIMEOUT_MILLIS), 300000L);
    }

    private static long parseLongValue(String text, long defaultValue) {
        if (Strings.isNotBlank((String)text)) {
            try {
                return Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                LOG.warn("Could not parse long value " + text + ": " + e, (Throwable)e);
            }
        }
        return defaultValue;
    }

    public PodSelectionAssert(KubernetesClient client, Integer replicas, Map<String, String> matchLabels, List<LabelSelectorRequirement> matchExpressions, String description) {
        this.client = client;
        this.replicas = replicas;
        this.matchLabels = matchLabels;
        this.matchExpressions = matchExpressions;
        this.description = description;
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public Map<String, String> getMatchLabels() {
        return this.matchLabels;
    }

    public List<LabelSelectorRequirement> getMatchExpressions() {
        return this.matchExpressions;
    }

    public PodSelectionAssert isPodReadyForPeriod() {
        return this.isPodReadyForPeriod(PodSelectionAssert.getDefaultNotReadyTimeoutMs(), PodSelectionAssert.getDefaultReadyPeriodMs());
    }

    public PodSelectionAssert isPodReadyForPeriod(long notReadyTimeoutMS, long readyPeriodMS) {
        if (this.replicas <= 0) {
            LOG.warn("Not that the pod selection for: " + this.description + " has no replicas defined so we cannot assert there is a pod ready");
            return this;
        }
        try (PodWatcher podWatcher = new PodWatcher(this, notReadyTimeoutMS, readyPeriodMS);
             Watch watch = (Watch)((FilterWatchListDeletable)this.client.pods().withLabels(this.matchLabels)).watch((Object)podWatcher);){
            podWatcher.loadCurrentPods();
            podWatcher.waitForPodReady();
        }
        return this;
    }

    public List<Pod> getPods() {
        PodList list = (PodList)((FilterWatchListDeletable)this.getClient().pods().withLabels(this.getMatchLabels())).list();
        ((AbstractObjectAssert)Java6Assertions.assertThat((Object)list).describedAs(this.getDescription() + " pods", new Object[0])).isNotNull();
        return list.getItems();
    }
}

