package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link PhotonPersistentDiskVolumeSource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPhotonPersistentDiskVolumeSourceAssert<S extends AbstractPhotonPersistentDiskVolumeSourceAssert<S, A>, A extends PhotonPersistentDiskVolumeSource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPhotonPersistentDiskVolumeSourceAssert}</code> to make assertions on actual PhotonPersistentDiskVolumeSource.
   * @param actual the PhotonPersistentDiskVolumeSource we want to make assertions on.
   */
  protected AbstractPhotonPersistentDiskVolumeSourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PhotonPersistentDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property fsType so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert fsType()  {
    // check that actual PhotonPersistentDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getFsType()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fsType"));
  }


  /**
   * Navigates to the property pdID so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert pdID()  {
    // check that actual PhotonPersistentDiskVolumeSource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPdID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "pdID"));
  }


}
