package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link IngressBackend} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractIngressBackendAssert<S extends AbstractIngressBackendAssert<S, A>, A extends IngressBackend> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractIngressBackendAssert}</code> to make assertions on actual IngressBackend.
   * @param actual the IngressBackend we want to make assertions on.
   */
  protected AbstractIngressBackendAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual IngressBackend we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property serviceName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert serviceName()  {
    // check that actual IngressBackend we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getServiceName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceName"));
  }


  /**
   * Navigates to the property servicePort so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.IntOrStringAssert servicePort()  {
    // check that actual IngressBackend we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.IntOrStringAssert) assertThat(actual.getServicePort()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "servicePort"));
  }


}
