package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link Endpoints} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractEndpointsAssert<S extends AbstractEndpointsAssert<S, A>, A extends Endpoints> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractEndpointsAssert}</code> to make assertions on actual Endpoints.
   * @param actual the Endpoints we want to make assertions on.
   */
  protected AbstractEndpointsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public ObjectMetaAssert metadata()  {
    // check that actual Endpoints we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property subsets so that assertions can be done on it
   */
  public NavigationListAssert<EndpointSubset, EndpointSubsetAssert> subsets()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<EndpointSubset, EndpointSubsetAssert> assertFactory = new AssertFactory<EndpointSubset, EndpointSubsetAssert>() {
      public EndpointSubsetAssert createAssert(EndpointSubset t) {
        return (EndpointSubsetAssert) assertThat(t);
      }
    };
    NavigationListAssert<EndpointSubset, EndpointSubsetAssert> answer = new NavigationListAssert<EndpointSubset, EndpointSubsetAssert>(actual.getSubsets(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subsets"));
    return answer;
  }


}
