package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link GenericWebHookCause} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractGenericWebHookCauseAssert<S extends AbstractGenericWebHookCauseAssert<S, A>, A extends GenericWebHookCause> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractGenericWebHookCauseAssert}</code> to make assertions on actual GenericWebHookCause.
   * @param actual the GenericWebHookCause we want to make assertions on.
   */
  protected AbstractGenericWebHookCauseAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual GenericWebHookCause we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property revision so that assertions can be done on it
   */
  public SourceRevisionAssert revision()  {
    // check that actual GenericWebHookCause we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (SourceRevisionAssert) assertThat(actual.getRevision()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "revision"));
  }


  /**
   * Navigates to the property secret so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert secret()  {
    // check that actual GenericWebHookCause we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSecret()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "secret"));
  }


}
