package io.fabric8.kubernetes.api.model.extensions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ThirdPartyResource} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractThirdPartyResourceAssert<S extends AbstractThirdPartyResourceAssert<S, A>, A extends ThirdPartyResource> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractThirdPartyResourceAssert}</code> to make assertions on actual ThirdPartyResource.
   * @param actual the ThirdPartyResource we want to make assertions on.
   */
  protected AbstractThirdPartyResourceAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ThirdPartyResource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property apiVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert apiVersion()  {
    // check that actual ThirdPartyResource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"));
  }


  /**
   * Navigates to the property description so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert description()  {
    // check that actual ThirdPartyResource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDescription()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "description"));
  }


  /**
   * Navigates to the property kind so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert kind()  {
    // check that actual ThirdPartyResource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"));
  }


  /**
   * Navigates to the property metadata so that assertions can be done on it
   */
  public io.fabric8.kubernetes.api.model.ObjectMetaAssert metadata()  {
    // check that actual ThirdPartyResource we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (io.fabric8.kubernetes.api.model.ObjectMetaAssert) assertThat(actual.getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"));
  }


  /**
   * Navigates to the property versions so that assertions can be done on it
   */
  public NavigationListAssert<APIVersion, APIVersionAssert> versions()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<APIVersion, APIVersionAssert> assertFactory = new AssertFactory<APIVersion, APIVersionAssert>() {
      public APIVersionAssert createAssert(APIVersion t) {
        return (APIVersionAssert) assertThat(t);
      }
    };
    NavigationListAssert<APIVersion, APIVersionAssert> answer = new NavigationListAssert<APIVersion, APIVersionAssert>(actual.getVersions(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "versions"));
    return answer;
  }


}
