/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableNamedTagEventList;
import io.fabric8.openshift.api.model.NamedTagEventList;
import io.fabric8.openshift.api.model.NamedTagEventListFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NamedTagEventListBuilder
extends NamedTagEventListFluent<NamedTagEventListBuilder>
implements VisitableBuilder<NamedTagEventList, NamedTagEventListBuilder> {
    NamedTagEventListFluent<?> fluent;

    public NamedTagEventListBuilder() {
        this(new NamedTagEventList());
    }

    public NamedTagEventListBuilder(NamedTagEventListFluent<?> fluent) {
        this(fluent, new NamedTagEventList());
    }

    public NamedTagEventListBuilder(NamedTagEventListFluent<?> fluent, NamedTagEventList instance) {
        this.fluent = fluent;
        fluent.withItems(instance.getItems());
        fluent.withTag(instance.getTag());
    }

    public NamedTagEventListBuilder(NamedTagEventList instance) {
        this.fluent = this;
        this.withItems(instance.getItems());
        this.withTag(instance.getTag());
    }

    public EditableNamedTagEventList build() {
        EditableNamedTagEventList buildable = new EditableNamedTagEventList(this.fluent.getItems(), this.fluent.getTag());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

