/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.DeploymentStrategy;
import io.fabric8.openshift.api.model.DeploymentStrategyFluent;
import io.fabric8.openshift.api.model.EditableDeploymentStrategy;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DeploymentStrategyBuilder
extends DeploymentStrategyFluent<DeploymentStrategyBuilder>
implements VisitableBuilder<DeploymentStrategy, DeploymentStrategyBuilder> {
    DeploymentStrategyFluent<?> fluent;

    public DeploymentStrategyBuilder() {
        this(new DeploymentStrategy());
    }

    public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent) {
        this(fluent, new DeploymentStrategy());
    }

    public DeploymentStrategyBuilder(DeploymentStrategyFluent<?> fluent, DeploymentStrategy instance) {
        this.fluent = fluent;
        fluent.withCustomParams(instance.getCustomParams());
        fluent.withRecreateParams(instance.getRecreateParams());
        fluent.withResources(instance.getResources());
        fluent.withRollingParams(instance.getRollingParams());
        fluent.withType(instance.getType());
    }

    public DeploymentStrategyBuilder(DeploymentStrategy instance) {
        this.fluent = this;
        this.withCustomParams(instance.getCustomParams());
        this.withRecreateParams(instance.getRecreateParams());
        this.withResources(instance.getResources());
        this.withRollingParams(instance.getRollingParams());
        this.withType(instance.getType());
    }

    public EditableDeploymentStrategy build() {
        EditableDeploymentStrategy buildable = new EditableDeploymentStrategy(this.fluent.getCustomParams(), this.fluent.getRecreateParams(), this.fluent.getResources(), this.fluent.getRollingParams(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

