/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableGitRepoVolumeSource;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSource;
import io.fabric8.kubernetes.api.model.GitRepoVolumeSourceFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class GitRepoVolumeSourceBuilder
extends GitRepoVolumeSourceFluent<GitRepoVolumeSourceBuilder>
implements VisitableBuilder<GitRepoVolumeSource, GitRepoVolumeSourceBuilder> {
    GitRepoVolumeSourceFluent<?> fluent;

    public GitRepoVolumeSourceBuilder() {
        this(new GitRepoVolumeSource());
    }

    public GitRepoVolumeSourceBuilder(GitRepoVolumeSourceFluent<?> fluent) {
        this(fluent, new GitRepoVolumeSource());
    }

    public GitRepoVolumeSourceBuilder(GitRepoVolumeSourceFluent<?> fluent, GitRepoVolumeSource instance) {
        this.fluent = fluent;
        fluent.withRepository(instance.getRepository());
        fluent.withRevision(instance.getRevision());
    }

    public GitRepoVolumeSourceBuilder(GitRepoVolumeSource instance) {
        this.fluent = this;
        this.withRepository(instance.getRepository());
        this.withRevision(instance.getRevision());
    }

    public EditableGitRepoVolumeSource build() {
        EditableGitRepoVolumeSource buildable = new EditableGitRepoVolumeSource(this.fluent.getRepository(), this.fluent.getRevision());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

