package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link CustomBuildStrategy} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractCustomBuildStrategyAssert<S extends AbstractCustomBuildStrategyAssert<S, A>, A extends CustomBuildStrategy> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractCustomBuildStrategyAssert}</code> to make assertions on actual CustomBuildStrategy.
   * @param actual the CustomBuildStrategy we want to make assertions on.
   */
  protected AbstractCustomBuildStrategyAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual CustomBuildStrategy's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual CustomBuildStrategy's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomBuildStrategy's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual CustomBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategy's env contains the given io.fabric8.kubernetes.api.model.EnvVar elements.
   * @param env the given elements that should be contained in actual CustomBuildStrategy's env.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategy's env does not contain all given io.fabric8.kubernetes.api.model.EnvVar elements.
   */
  public S hasEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    // check that actual CustomBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // check that given io.fabric8.kubernetes.api.model.EnvVar varargs is not null.
    if (env == null) throw new AssertionError("Expecting env parameter not to be null.");
    
    // check with standard error message, to set another message call: info.overridingErrorMessage("my error message");
    Iterables.instance().assertContains(info, actual.getEnv(), env);

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategy has no env.
   * @return this assertion object.
   * @throws AssertionError if the actual CustomBuildStrategy's env is not empty.
   */
  public S hasNoEnv() {
    // check that actual CustomBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // we override the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected :\n  <%s>\nnot to have env but had :\n  <%s>";
    
    // check
    if (actual.getEnv().iterator().hasNext()) {
      failWithMessage(assertjErrorMessage, actual, actual.getEnv());
    }
    
    // return the current assertion for method chaining
    return myself;
  }
  

  /**
   * Verifies that the actual CustomBuildStrategy's exposeDockerSocket is equal to the given one.
   * @param exposeDockerSocket the given exposeDockerSocket to compare the actual CustomBuildStrategy's exposeDockerSocket to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomBuildStrategy's exposeDockerSocket is not equal to the given one.
   */
  public S hasExposeDockerSocket(Boolean exposeDockerSocket) {
    // check that actual CustomBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected exposeDockerSocket of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Boolean actualExposeDockerSocket = actual.getExposeDockerSocket();
    if (!Objects.areEqual(actualExposeDockerSocket, exposeDockerSocket)) {
      failWithMessage(assertjErrorMessage, actual, exposeDockerSocket, actualExposeDockerSocket);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategy's from is equal to the given one.
   * @param from the given from to compare the actual CustomBuildStrategy's from to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomBuildStrategy's from is not equal to the given one.
   */
  public S hasFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    // check that actual CustomBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected from of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.ObjectReference actualFrom = actual.getFrom();
    if (!Objects.areEqual(actualFrom, from)) {
      failWithMessage(assertjErrorMessage, actual, from, actualFrom);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual CustomBuildStrategy's pullSecret is equal to the given one.
   * @param pullSecret the given pullSecret to compare the actual CustomBuildStrategy's pullSecret to.
   * @return this assertion object.
   * @throws AssertionError - if the actual CustomBuildStrategy's pullSecret is not equal to the given one.
   */
  public S hasPullSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pullSecret) {
    // check that actual CustomBuildStrategy we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected pullSecret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    io.fabric8.kubernetes.api.model.LocalObjectReference actualPullSecret = actual.getPullSecret();
    if (!Objects.areEqual(actualPullSecret, pullSecret)) {
      failWithMessage(assertjErrorMessage, actual, pullSecret, actualPullSecret);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
