package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link ResourceRequirements} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractResourceRequirementsAssert<S extends AbstractResourceRequirementsAssert<S, A>, A extends ResourceRequirements> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractResourceRequirementsAssert}</code> to make assertions on actual ResourceRequirements.
   * @param actual the ResourceRequirements we want to make assertions on.
   */
  protected AbstractResourceRequirementsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual ResourceRequirements's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual ResourceRequirements's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ResourceRequirements's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual ResourceRequirements we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ResourceRequirements's limits is equal to the given one.
   * @param limits the given limits to compare the actual ResourceRequirements's limits to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ResourceRequirements's limits is not equal to the given one.
   */
  public S hasLimits(java.util.Map limits) {
    // check that actual ResourceRequirements we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected limits of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualLimits = actual.getLimits();
    if (!Objects.areEqual(actualLimits, limits)) {
      failWithMessage(assertjErrorMessage, actual, limits, actualLimits);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual ResourceRequirements's requests is equal to the given one.
   * @param requests the given requests to compare the actual ResourceRequirements's requests to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ResourceRequirements's requests is not equal to the given one.
   */
  public S hasRequests(java.util.Map requests) {
    // check that actual ResourceRequirements we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected requests of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualRequests = actual.getRequests();
    if (!Objects.areEqual(actualRequests, requests)) {
      failWithMessage(assertjErrorMessage, actual, requests, actualRequests);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
