package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.util.Objects;

/**
 * Abstract base class for {@link NamedExtension} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractNamedExtensionAssert<S extends AbstractNamedExtensionAssert<S, A>, A extends NamedExtension> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractNamedExtensionAssert}</code> to make assertions on actual NamedExtension.
   * @param actual the NamedExtension we want to make assertions on.
   */
  protected AbstractNamedExtensionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }

  /**
   * Verifies that the actual NamedExtension's additionalProperties is equal to the given one.
   * @param additionalProperties the given additionalProperties to compare the actual NamedExtension's additionalProperties to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedExtension's additionalProperties is not equal to the given one.
   */
  public S hasAdditionalProperties(java.util.Map additionalProperties) {
    // check that actual NamedExtension we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    java.util.Map actualAdditionalProperties = actual.getAdditionalProperties();
    if (!Objects.areEqual(actualAdditionalProperties, additionalProperties)) {
      failWithMessage(assertjErrorMessage, actual, additionalProperties, actualAdditionalProperties);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedExtension's extension is equal to the given one.
   * @param extension the given extension to compare the actual NamedExtension's extension to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedExtension's extension is not equal to the given one.
   */
  public S hasExtension(HasMetadata extension) {
    // check that actual NamedExtension we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected extension of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    HasMetadata actualExtension = actual.getExtension();
    if (!Objects.areEqual(actualExtension, extension)) {
      failWithMessage(assertjErrorMessage, actual, extension, actualExtension);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Verifies that the actual NamedExtension's name is equal to the given one.
   * @param name the given name to compare the actual NamedExtension's name to.
   * @return this assertion object.
   * @throws AssertionError - if the actual NamedExtension's name is not equal to the given one.
   */
  public S hasName(String name) {
    // check that actual NamedExtension we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpected name of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    String actualName = actual.getName();
    if (!Objects.areEqual(actualName, name)) {
      failWithMessage(assertjErrorMessage, actual, name, actualName);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
