package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link PersistentVolumeSpec} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractPersistentVolumeSpecAssert<S extends AbstractPersistentVolumeSpecAssert<S, A>, A extends PersistentVolumeSpec> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractPersistentVolumeSpecAssert}</code> to make assertions on actual PersistentVolumeSpec.
   * @param actual the PersistentVolumeSpec we want to make assertions on.
   */
  protected AbstractPersistentVolumeSpecAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property accessModes so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> accessModes()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getAccessModes(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "accessModes"));
    return answer;
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property awsElasticBlockStore so that assertions can be done on it
   */
  public AWSElasticBlockStoreVolumeSourceAssert awsElasticBlockStore()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (AWSElasticBlockStoreVolumeSourceAssert) assertThat(actual.getAwsElasticBlockStore()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "awsElasticBlockStore"));
  }


  /**
   * Navigates to the property azureDisk so that assertions can be done on it
   */
  public AzureDiskVolumeSourceAssert azureDisk()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (AzureDiskVolumeSourceAssert) assertThat(actual.getAzureDisk()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "azureDisk"));
  }


  /**
   * Navigates to the property azureFile so that assertions can be done on it
   */
  public AzureFileVolumeSourceAssert azureFile()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (AzureFileVolumeSourceAssert) assertThat(actual.getAzureFile()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "azureFile"));
  }


  /**
   * Navigates to the property capacity so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert capacity()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getCapacity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "capacity"));
  }


  /**
   * Navigates to the property cephfs so that assertions can be done on it
   */
  public CephFSVolumeSourceAssert cephfs()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CephFSVolumeSourceAssert) assertThat(actual.getCephfs()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cephfs"));
  }


  /**
   * Navigates to the property cinder so that assertions can be done on it
   */
  public CinderVolumeSourceAssert cinder()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (CinderVolumeSourceAssert) assertThat(actual.getCinder()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "cinder"));
  }


  /**
   * Navigates to the property claimRef so that assertions can be done on it
   */
  public ObjectReferenceAssert claimRef()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ObjectReferenceAssert) assertThat(actual.getClaimRef()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "claimRef"));
  }


  /**
   * Navigates to the property fc so that assertions can be done on it
   */
  public FCVolumeSourceAssert fc()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (FCVolumeSourceAssert) assertThat(actual.getFc()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "fc"));
  }


  /**
   * Navigates to the property flexVolume so that assertions can be done on it
   */
  public FlexVolumeSourceAssert flexVolume()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (FlexVolumeSourceAssert) assertThat(actual.getFlexVolume()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "flexVolume"));
  }


  /**
   * Navigates to the property flocker so that assertions can be done on it
   */
  public FlockerVolumeSourceAssert flocker()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (FlockerVolumeSourceAssert) assertThat(actual.getFlocker()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "flocker"));
  }


  /**
   * Navigates to the property gcePersistentDisk so that assertions can be done on it
   */
  public GCEPersistentDiskVolumeSourceAssert gcePersistentDisk()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GCEPersistentDiskVolumeSourceAssert) assertThat(actual.getGcePersistentDisk()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "gcePersistentDisk"));
  }


  /**
   * Navigates to the property glusterfs so that assertions can be done on it
   */
  public GlusterfsVolumeSourceAssert glusterfs()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (GlusterfsVolumeSourceAssert) assertThat(actual.getGlusterfs()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "glusterfs"));
  }


  /**
   * Navigates to the property hostPath so that assertions can be done on it
   */
  public HostPathVolumeSourceAssert hostPath()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (HostPathVolumeSourceAssert) assertThat(actual.getHostPath()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostPath"));
  }


  /**
   * Navigates to the property iscsi so that assertions can be done on it
   */
  public ISCSIVolumeSourceAssert iscsi()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ISCSIVolumeSourceAssert) assertThat(actual.getIscsi()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "iscsi"));
  }


  /**
   * Navigates to the property nfs so that assertions can be done on it
   */
  public NFSVolumeSourceAssert nfs()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (NFSVolumeSourceAssert) assertThat(actual.getNfs()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nfs"));
  }


  /**
   * Navigates to the property persistentVolumeReclaimPolicy so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert persistentVolumeReclaimPolicy()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getPersistentVolumeReclaimPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "persistentVolumeReclaimPolicy"));
  }


  /**
   * Navigates to the property quobyte so that assertions can be done on it
   */
  public QuobyteVolumeSourceAssert quobyte()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (QuobyteVolumeSourceAssert) assertThat(actual.getQuobyte()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "quobyte"));
  }


  /**
   * Navigates to the property rbd so that assertions can be done on it
   */
  public RBDVolumeSourceAssert rbd()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (RBDVolumeSourceAssert) assertThat(actual.getRbd()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "rbd"));
  }


  /**
   * Navigates to the property vsphereVolume so that assertions can be done on it
   */
  public VsphereVirtualDiskVolumeSourceAssert vsphereVolume()  {
    // check that actual PersistentVolumeSpec we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (VsphereVirtualDiskVolumeSourceAssert) assertThat(actual.getVsphereVolume()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "vsphereVolume"));
  }


}
