/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.openshift.api.model.BuildOutput;
import io.fabric8.openshift.api.model.BuildOutputBuilder;
import io.fabric8.openshift.api.model.BuildOutputFluentImpl;
import io.fabric8.openshift.api.model.BuildPostCommitSpec;
import io.fabric8.openshift.api.model.BuildPostCommitSpecBuilder;
import io.fabric8.openshift.api.model.BuildPostCommitSpecFluentImpl;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSourceBuilder;
import io.fabric8.openshift.api.model.BuildSourceFluentImpl;
import io.fabric8.openshift.api.model.BuildSpec;
import io.fabric8.openshift.api.model.BuildSpecFluent;
import io.fabric8.openshift.api.model.BuildStrategy;
import io.fabric8.openshift.api.model.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.BuildStrategyFluentImpl;
import io.fabric8.openshift.api.model.BuildTriggerCause;
import io.fabric8.openshift.api.model.BuildTriggerCauseBuilder;
import io.fabric8.openshift.api.model.BuildTriggerCauseFluentImpl;
import io.fabric8.openshift.api.model.SourceRevision;
import io.fabric8.openshift.api.model.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.SourceRevisionFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class BuildSpecFluentImpl<A extends BuildSpecFluent<A>>
extends BaseFluent<A>
implements BuildSpecFluent<A> {
    private Long completionDeadlineSeconds;
    private VisitableBuilder<? extends BuildOutput, ?> output;
    private VisitableBuilder<? extends BuildPostCommitSpec, ?> postCommit;
    private VisitableBuilder<? extends ResourceRequirements, ?> resources;
    private VisitableBuilder<? extends SourceRevision, ?> revision;
    private String serviceAccount;
    private VisitableBuilder<? extends BuildSource, ?> source;
    private VisitableBuilder<? extends BuildStrategy, ?> strategy;
    private List<VisitableBuilder<? extends BuildTriggerCause, ?>> triggeredBy = new ArrayList();

    public BuildSpecFluentImpl() {
    }

    public BuildSpecFluentImpl(BuildSpec instance) {
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        this.withOutput(instance.getOutput());
        this.withPostCommit(instance.getPostCommit());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
        this.withTriggeredBy(instance.getTriggeredBy());
    }

    @Override
    public Long getCompletionDeadlineSeconds() {
        return this.completionDeadlineSeconds;
    }

    @Override
    public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds) {
        this.completionDeadlineSeconds = completionDeadlineSeconds;
        return (A)this;
    }

    @Override
    public BuildOutput getOutput() {
        return this.output != null ? (BuildOutput)this.output.build() : null;
    }

    @Override
    public A withOutput(BuildOutput output) {
        if (output != null) {
            this.output = new BuildOutputBuilder(output);
            this._visitables.add(this.output);
        }
        return (A)this;
    }

    @Override
    public BuildSpecFluent.OutputNested<A> withNewOutput() {
        return new OutputNestedImpl();
    }

    @Override
    public BuildSpecFluent.OutputNested<A> withNewOutputLike(BuildOutput item) {
        return new OutputNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.OutputNested<A> editOutput() {
        return this.withNewOutputLike(this.getOutput());
    }

    @Override
    public BuildPostCommitSpec getPostCommit() {
        return this.postCommit != null ? (BuildPostCommitSpec)this.postCommit.build() : null;
    }

    @Override
    public A withPostCommit(BuildPostCommitSpec postCommit) {
        if (postCommit != null) {
            this.postCommit = new BuildPostCommitSpecBuilder(postCommit);
            this._visitables.add(this.postCommit);
        }
        return (A)this;
    }

    @Override
    public BuildSpecFluent.PostCommitNested<A> withNewPostCommit() {
        return new PostCommitNestedImpl();
    }

    @Override
    public BuildSpecFluent.PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item) {
        return new PostCommitNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.PostCommitNested<A> editPostCommit() {
        return this.withNewPostCommitLike(this.getPostCommit());
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources != null ? (ResourceRequirements)this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (A)this;
    }

    @Override
    public BuildSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public BuildSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public SourceRevision getRevision() {
        return this.revision != null ? (SourceRevision)this.revision.build() : null;
    }

    @Override
    public A withRevision(SourceRevision revision) {
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.add(this.revision);
        }
        return (A)this;
    }

    @Override
    public BuildSpecFluent.RevisionNested<A> withNewRevision() {
        return new RevisionNestedImpl();
    }

    @Override
    public BuildSpecFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item) {
        return new RevisionNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.RevisionNested<A> editRevision() {
        return this.withNewRevisionLike(this.getRevision());
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    @Override
    public BuildSource getSource() {
        return this.source != null ? (BuildSource)this.source.build() : null;
    }

    @Override
    public A withSource(BuildSource source) {
        if (source != null) {
            this.source = new BuildSourceBuilder(source);
            this._visitables.add(this.source);
        }
        return (A)this;
    }

    @Override
    public BuildSpecFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public BuildSpecFluent.SourceNested<A> withNewSourceLike(BuildSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.SourceNested<A> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public BuildStrategy getStrategy() {
        return this.strategy != null ? (BuildStrategy)this.strategy.build() : null;
    }

    @Override
    public A withStrategy(BuildStrategy strategy) {
        if (strategy != null) {
            this.strategy = new BuildStrategyBuilder(strategy);
            this._visitables.add(this.strategy);
        }
        return (A)this;
    }

    @Override
    public BuildSpecFluent.StrategyNested<A> withNewStrategy() {
        return new StrategyNestedImpl();
    }

    @Override
    public BuildSpecFluent.StrategyNested<A> withNewStrategyLike(BuildStrategy item) {
        return new StrategyNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    @Override
    public A addToTriggeredBy(BuildTriggerCause ... items) {
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.add(builder);
            this.triggeredBy.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTriggeredBy(BuildTriggerCause ... items) {
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.remove(builder);
            this.triggeredBy.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<BuildTriggerCause> getTriggeredBy() {
        return BuildSpecFluentImpl.build(this.triggeredBy);
    }

    @Override
    public A withTriggeredBy(List<BuildTriggerCause> triggeredBy) {
        this.triggeredBy.clear();
        if (triggeredBy != null) {
            for (BuildTriggerCause item : triggeredBy) {
                this.addToTriggeredBy(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTriggeredBy(BuildTriggerCause ... triggeredBy) {
        this.triggeredBy.clear();
        if (triggeredBy != null) {
            for (BuildTriggerCause item : triggeredBy) {
                this.addToTriggeredBy(item);
            }
        }
        return (A)this;
    }

    @Override
    public BuildSpecFluent.TriggeredByNested<A> addNewTriggeredBy() {
        return new TriggeredByNestedImpl();
    }

    @Override
    public BuildSpecFluent.TriggeredByNested<A> addNewTriggeredByLike(BuildTriggerCause item) {
        return new TriggeredByNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildSpecFluentImpl that = (BuildSpecFluentImpl)o;
        if (this.completionDeadlineSeconds != null ? !this.completionDeadlineSeconds.equals(that.completionDeadlineSeconds) : that.completionDeadlineSeconds != null) {
            return false;
        }
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        if (this.postCommit != null ? !this.postCommit.equals(that.postCommit) : that.postCommit != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        return !(this.triggeredBy != null ? !this.triggeredBy.equals(that.triggeredBy) : that.triggeredBy != null);
    }

    public class TriggeredByNestedImpl<N>
    extends BuildTriggerCauseFluentImpl<BuildSpecFluent.TriggeredByNested<N>>
    implements BuildSpecFluent.TriggeredByNested<N>,
    Nested<N> {
        private final BuildTriggerCauseBuilder builder;

        TriggeredByNestedImpl() {
            this.builder = new BuildTriggerCauseBuilder(this);
        }

        TriggeredByNestedImpl(BuildTriggerCause item) {
            this.builder = new BuildTriggerCauseBuilder(this, item);
        }

        @Override
        public N endTriggeredBy() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.addToTriggeredBy(this.builder.build());
        }
    }

    public class StrategyNestedImpl<N>
    extends BuildStrategyFluentImpl<BuildSpecFluent.StrategyNested<N>>
    implements BuildSpecFluent.StrategyNested<N>,
    Nested<N> {
        private final BuildStrategyBuilder builder;

        StrategyNestedImpl() {
            this.builder = new BuildStrategyBuilder(this);
        }

        StrategyNestedImpl(BuildStrategy item) {
            this.builder = new BuildStrategyBuilder(this, item);
        }

        @Override
        public N endStrategy() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withStrategy(this.builder.build());
        }
    }

    public class SourceNestedImpl<N>
    extends BuildSourceFluentImpl<BuildSpecFluent.SourceNested<N>>
    implements BuildSpecFluent.SourceNested<N>,
    Nested<N> {
        private final BuildSourceBuilder builder;

        SourceNestedImpl() {
            this.builder = new BuildSourceBuilder(this);
        }

        SourceNestedImpl(BuildSource item) {
            this.builder = new BuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }

    public class RevisionNestedImpl<N>
    extends SourceRevisionFluentImpl<BuildSpecFluent.RevisionNested<N>>
    implements BuildSpecFluent.RevisionNested<N>,
    Nested<N> {
        private final SourceRevisionBuilder builder;

        RevisionNestedImpl() {
            this.builder = new SourceRevisionBuilder(this);
        }

        RevisionNestedImpl(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        @Override
        public N endRevision() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withRevision(this.builder.build());
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<BuildSpecFluent.ResourcesNested<N>>
    implements BuildSpecFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class PostCommitNestedImpl<N>
    extends BuildPostCommitSpecFluentImpl<BuildSpecFluent.PostCommitNested<N>>
    implements BuildSpecFluent.PostCommitNested<N>,
    Nested<N> {
        private final BuildPostCommitSpecBuilder builder;

        PostCommitNestedImpl() {
            this.builder = new BuildPostCommitSpecBuilder(this);
        }

        PostCommitNestedImpl(BuildPostCommitSpec item) {
            this.builder = new BuildPostCommitSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withPostCommit(this.builder.build());
        }

        @Override
        public N endPostCommit() {
            return this.and();
        }
    }

    public class OutputNestedImpl<N>
    extends BuildOutputFluentImpl<BuildSpecFluent.OutputNested<N>>
    implements BuildSpecFluent.OutputNested<N>,
    Nested<N> {
        private final BuildOutputBuilder builder;

        OutputNestedImpl() {
            this.builder = new BuildOutputBuilder(this);
        }

        OutputNestedImpl(BuildOutput item) {
            this.builder = new BuildOutputBuilder(this, item);
        }

        @Override
        public N endOutput() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withOutput(this.builder.build());
        }
    }
}

