/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.PetSetStatus;
import io.fabric8.kubernetes.api.model.extensions.PetSetStatusFluent;
import io.fabric8.kubernetes.api.model.extensions.PetSetStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PetSetStatusBuilder
extends PetSetStatusFluentImpl<PetSetStatusBuilder>
implements VisitableBuilder<PetSetStatus, PetSetStatusBuilder> {
    PetSetStatusFluent<?> fluent;
    Boolean validationEnabled;

    public PetSetStatusBuilder() {
        this(true);
    }

    public PetSetStatusBuilder(Boolean validationEnabled) {
        this(new PetSetStatus(), validationEnabled);
    }

    public PetSetStatusBuilder(PetSetStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PetSetStatusBuilder(PetSetStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PetSetStatus(), validationEnabled);
    }

    public PetSetStatusBuilder(PetSetStatusFluent<?> fluent, PetSetStatus instance) {
        this(fluent, instance, true);
    }

    public PetSetStatusBuilder(PetSetStatusFluent<?> fluent, PetSetStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    public PetSetStatusBuilder(PetSetStatus instance) {
        this(instance, (Boolean)true);
    }

    public PetSetStatusBuilder(PetSetStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    public PetSetStatus build() {
        PetSetStatus buildable = new PetSetStatus(this.fluent.getObservedGeneration(), this.fluent.getReplicas());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PetSetStatusBuilder that = (PetSetStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

