/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.PetSetList;
import io.fabric8.kubernetes.api.model.extensions.PetSetListFluent;
import io.fabric8.kubernetes.api.model.extensions.PetSetListFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PetSetListBuilder
extends PetSetListFluentImpl<PetSetListBuilder>
implements VisitableBuilder<PetSetList, PetSetListBuilder> {
    PetSetListFluent<?> fluent;
    Boolean validationEnabled;

    public PetSetListBuilder() {
        this(true);
    }

    public PetSetListBuilder(Boolean validationEnabled) {
        this(new PetSetList(), validationEnabled);
    }

    public PetSetListBuilder(PetSetListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PetSetListBuilder(PetSetListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PetSetList(), validationEnabled);
    }

    public PetSetListBuilder(PetSetListFluent<?> fluent, PetSetList instance) {
        this(fluent, instance, true);
    }

    public PetSetListBuilder(PetSetListFluent<?> fluent, PetSetList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public PetSetListBuilder(PetSetList instance) {
        this(instance, (Boolean)true);
    }

    public PetSetListBuilder(PetSetList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public PetSetList build() {
        PetSetList buildable = new PetSetList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PetSetListBuilder that = (PetSetListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

