package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link RecreateDeploymentStrategyParams} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractRecreateDeploymentStrategyParamsAssert<S extends AbstractRecreateDeploymentStrategyParamsAssert<S, A>, A extends RecreateDeploymentStrategyParams> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractRecreateDeploymentStrategyParamsAssert}</code> to make assertions on actual RecreateDeploymentStrategyParams.
   * @param actual the RecreateDeploymentStrategyParams we want to make assertions on.
   */
  protected AbstractRecreateDeploymentStrategyParamsAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual RecreateDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property mid so that assertions can be done on it
   */
  public LifecycleHookAssert mid()  {
    // check that actual RecreateDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LifecycleHookAssert) assertThat(actual.getMid()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "mid"));
  }


  /**
   * Navigates to the property post so that assertions can be done on it
   */
  public LifecycleHookAssert post()  {
    // check that actual RecreateDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LifecycleHookAssert) assertThat(actual.getPost()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "post"));
  }


  /**
   * Navigates to the property pre so that assertions can be done on it
   */
  public LifecycleHookAssert pre()  {
    // check that actual RecreateDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (LifecycleHookAssert) assertThat(actual.getPre()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "pre"));
  }


  /**
   * Verifies that the actual RecreateDeploymentStrategyParams's timeoutSeconds is equal to the given one.
   * @param timeoutSeconds the given timeoutSeconds to compare the actual RecreateDeploymentStrategyParams's timeoutSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual RecreateDeploymentStrategyParams's timeoutSeconds is not equal to the given one.
   */
  public S hasTimeoutSeconds(Long timeoutSeconds) {
    // check that actual RecreateDeploymentStrategyParams we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting timeoutSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualTimeoutSeconds = actual.getTimeoutSeconds();
    if (!Objects.areEqual(actualTimeoutSeconds, timeoutSeconds)) {
      failWithMessage(assertjErrorMessage, actual, timeoutSeconds, actualTimeoutSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

}
