/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class IngressBackendBuilder
extends IngressBackendFluentImpl<IngressBackendBuilder>
implements VisitableBuilder<IngressBackend, IngressBackendBuilder> {
    IngressBackendFluent<?> fluent;
    Boolean validationEnabled;

    public IngressBackendBuilder() {
        this(true);
    }

    public IngressBackendBuilder(Boolean validationEnabled) {
        this(new IngressBackend(), validationEnabled);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressBackend(), validationEnabled);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, IngressBackend instance) {
        this(fluent, instance, true);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, IngressBackend instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withServiceName(instance.getServiceName());
        fluent.withServicePort(instance.getServicePort());
        this.validationEnabled = validationEnabled;
    }

    public IngressBackendBuilder(IngressBackend instance) {
        this(instance, (Boolean)true);
    }

    public IngressBackendBuilder(IngressBackend instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withServiceName(instance.getServiceName());
        this.withServicePort(instance.getServicePort());
        this.validationEnabled = validationEnabled;
    }

    public IngressBackend build() {
        IngressBackend buildable = new IngressBackend(this.fluent.getServiceName(), this.fluent.getServicePort());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressBackendBuilder that = (IngressBackendBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

