/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.OwnerReferenceFluentImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObjectMetaFluentImpl<A extends ObjectMetaFluent<A>>
extends BaseFluent<A>
implements ObjectMetaFluent<A> {
    private Map<String, String> annotations = new LinkedHashMap<String, String>();
    private String creationTimestamp;
    private Long deletionGracePeriodSeconds;
    private String deletionTimestamp;
    private List<String> finalizers = new ArrayList<String>();
    private String generateName;
    private Long generation;
    private Map<String, String> labels = new LinkedHashMap<String, String>();
    private String name;
    private String namespace;
    private List<VisitableBuilder<? extends OwnerReference, ?>> ownerReferences = new ArrayList();
    private String resourceVersion;
    private String selfLink;
    private String uid;

    public ObjectMetaFluentImpl() {
    }

    public ObjectMetaFluentImpl(ObjectMeta instance) {
        this.withAnnotations(instance.getAnnotations());
        this.withCreationTimestamp(instance.getCreationTimestamp());
        this.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds());
        this.withDeletionTimestamp(instance.getDeletionTimestamp());
        this.withFinalizers(instance.getFinalizers());
        this.withGenerateName(instance.getGenerateName());
        this.withGeneration(instance.getGeneration());
        this.withLabels(instance.getLabels());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.withOwnerReferences(instance.getOwnerReferences());
        this.withResourceVersion(instance.getResourceVersion());
        this.withSelfLink(instance.getSelfLink());
        this.withUid(instance.getUid());
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (key != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public A withAnnotations(Map<String, String> annotations) {
        this.annotations.clear();
        if (annotations != null) {
            this.annotations.putAll(annotations);
        }
        return (A)this;
    }

    @Override
    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Override
    public A withCreationTimestamp(String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
        return (A)this;
    }

    @Override
    public Long getDeletionGracePeriodSeconds() {
        return this.deletionGracePeriodSeconds;
    }

    @Override
    public A withDeletionGracePeriodSeconds(Long deletionGracePeriodSeconds) {
        this.deletionGracePeriodSeconds = deletionGracePeriodSeconds;
        return (A)this;
    }

    @Override
    public String getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    @Override
    public A withDeletionTimestamp(String deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
        return (A)this;
    }

    @Override
    public A addToFinalizers(String ... items) {
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromFinalizers(String ... items) {
        for (String item : items) {
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getFinalizers() {
        return this.finalizers;
    }

    @Override
    public A withFinalizers(List<String> finalizers) {
        this.finalizers.clear();
        if (finalizers != null) {
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withFinalizers(String ... finalizers) {
        this.finalizers.clear();
        if (finalizers != null) {
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        }
        return (A)this;
    }

    @Override
    public String getGenerateName() {
        return this.generateName;
    }

    @Override
    public A withGenerateName(String generateName) {
        this.generateName = generateName;
        return (A)this;
    }

    @Override
    public Long getGeneration() {
        return this.generation;
    }

    @Override
    public A withGeneration(Long generation) {
        this.generation = generation;
        return (A)this;
    }

    @Override
    public A addToLabels(String key, String value) {
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (key != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public A withLabels(Map<String, String> labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.putAll(labels);
        }
        return (A)this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public A addToOwnerReferences(OwnerReference ... items) {
        for (OwnerReference item : items) {
            OwnerReferenceBuilder builder = new OwnerReferenceBuilder(item);
            this._visitables.add(builder);
            this.ownerReferences.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromOwnerReferences(OwnerReference ... items) {
        for (OwnerReference item : items) {
            OwnerReferenceBuilder builder = new OwnerReferenceBuilder(item);
            this._visitables.remove(builder);
            this.ownerReferences.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<OwnerReference> getOwnerReferences() {
        return ObjectMetaFluentImpl.build(this.ownerReferences);
    }

    @Override
    public A withOwnerReferences(List<OwnerReference> ownerReferences) {
        this.ownerReferences.clear();
        if (ownerReferences != null) {
            for (OwnerReference item : ownerReferences) {
                this.addToOwnerReferences(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withOwnerReferences(OwnerReference ... ownerReferences) {
        this.ownerReferences.clear();
        if (ownerReferences != null) {
            for (OwnerReference item : ownerReferences) {
                this.addToOwnerReferences(item);
            }
        }
        return (A)this;
    }

    @Override
    public ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReference() {
        return new OwnerReferencesNestedImpl();
    }

    @Override
    public ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReferenceLike(OwnerReference item) {
        return new OwnerReferencesNestedImpl(item);
    }

    @Override
    public A addNewOwnerReference(String apiVersion, Boolean controller, String kind, String name, String uid) {
        return this.addToOwnerReferences(new OwnerReference(apiVersion, controller, kind, name, uid));
    }

    @Override
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    @Override
    public A withResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return (A)this;
    }

    @Override
    public String getSelfLink() {
        return this.selfLink;
    }

    @Override
    public A withSelfLink(String selfLink) {
        this.selfLink = selfLink;
        return (A)this;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectMetaFluentImpl that = (ObjectMetaFluentImpl)o;
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        if (this.creationTimestamp != null ? !this.creationTimestamp.equals(that.creationTimestamp) : that.creationTimestamp != null) {
            return false;
        }
        if (this.deletionGracePeriodSeconds != null ? !this.deletionGracePeriodSeconds.equals(that.deletionGracePeriodSeconds) : that.deletionGracePeriodSeconds != null) {
            return false;
        }
        if (this.deletionTimestamp != null ? !this.deletionTimestamp.equals(that.deletionTimestamp) : that.deletionTimestamp != null) {
            return false;
        }
        if (this.finalizers != null ? !this.finalizers.equals(that.finalizers) : that.finalizers != null) {
            return false;
        }
        if (this.generateName != null ? !this.generateName.equals(that.generateName) : that.generateName != null) {
            return false;
        }
        if (this.generation != null ? !this.generation.equals(that.generation) : that.generation != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.ownerReferences != null ? !this.ownerReferences.equals(that.ownerReferences) : that.ownerReferences != null) {
            return false;
        }
        if (this.resourceVersion != null ? !this.resourceVersion.equals(that.resourceVersion) : that.resourceVersion != null) {
            return false;
        }
        if (this.selfLink != null ? !this.selfLink.equals(that.selfLink) : that.selfLink != null) {
            return false;
        }
        return !(this.uid != null ? !this.uid.equals(that.uid) : that.uid != null);
    }

    public class OwnerReferencesNestedImpl<N>
    extends OwnerReferenceFluentImpl<ObjectMetaFluent.OwnerReferencesNested<N>>
    implements ObjectMetaFluent.OwnerReferencesNested<N>,
    Nested<N> {
        private final OwnerReferenceBuilder builder;

        OwnerReferencesNestedImpl() {
            this.builder = new OwnerReferenceBuilder(this);
        }

        OwnerReferencesNestedImpl(OwnerReference item) {
            this.builder = new OwnerReferenceBuilder(this, item);
        }

        @Override
        public N endOwnerReference() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ObjectMetaFluentImpl.this.addToOwnerReferences(this.builder.build());
        }
    }
}

