/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HostPathVolumeSource;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.HostPathVolumeSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class HostPathVolumeSourceBuilder
extends HostPathVolumeSourceFluentImpl<HostPathVolumeSourceBuilder>
implements VisitableBuilder<HostPathVolumeSource, HostPathVolumeSourceBuilder> {
    HostPathVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public HostPathVolumeSourceBuilder() {
        this(true);
    }

    public HostPathVolumeSourceBuilder(Boolean validationEnabled) {
        this(new HostPathVolumeSource(), validationEnabled);
    }

    public HostPathVolumeSourceBuilder(HostPathVolumeSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HostPathVolumeSourceBuilder(HostPathVolumeSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HostPathVolumeSource(), validationEnabled);
    }

    public HostPathVolumeSourceBuilder(HostPathVolumeSourceFluent<?> fluent, HostPathVolumeSource instance) {
        this(fluent, instance, true);
    }

    public HostPathVolumeSourceBuilder(HostPathVolumeSourceFluent<?> fluent, HostPathVolumeSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPath(instance.getPath());
        this.validationEnabled = validationEnabled;
    }

    public HostPathVolumeSourceBuilder(HostPathVolumeSource instance) {
        this(instance, (Boolean)true);
    }

    public HostPathVolumeSourceBuilder(HostPathVolumeSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPath(instance.getPath());
        this.validationEnabled = validationEnabled;
    }

    public HostPathVolumeSource build() {
        HostPathVolumeSource buildable = new HostPathVolumeSource(this.fluent.getPath());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostPathVolumeSourceBuilder that = (HostPathVolumeSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

