package io.fabric8.openshift.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ScopeRestriction} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractScopeRestrictionAssert<S extends AbstractScopeRestrictionAssert<S, A>, A extends ScopeRestriction> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractScopeRestrictionAssert}</code> to make assertions on actual ScopeRestriction.
   * @param actual the ScopeRestriction we want to make assertions on.
   */
  protected AbstractScopeRestrictionAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ScopeRestriction we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property clusterRole so that assertions can be done on it
   */
  public ClusterRoleScopeRestrictionAssert clusterRole()  {
    // check that actual ScopeRestriction we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (ClusterRoleScopeRestrictionAssert) assertThat(actual.getClusterRole()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterRole"));
  }


  /**
   * Navigates to the property literals so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> literals()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getLiterals(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "literals"));
    return answer;
  }


}
