package io.fabric8.kubernetes.api.model;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Objects;


import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;

import static org.assertj.core.api.Assertions.assertThat;
import static io.fabric8.kubernetes.assertions.internal.Assertions.assertThat;
import static io.fabric8.openshift.assertions.Assertions.assertThat;

/**
 * Abstract base class for {@link ObjectMeta} specific assertions - Generated by CustomAssertionGenerator.
 */
public abstract class AbstractObjectMetaAssert<S extends AbstractObjectMetaAssert<S, A>, A extends ObjectMeta> extends AbstractAssert<S, A> {

  /**
   * Creates a new <code>{@link AbstractObjectMetaAssert}</code> to make assertions on actual ObjectMeta.
   * @param actual the ObjectMeta we want to make assertions on.
   */
  protected AbstractObjectMetaAssert(A actual, Class<S> selfType) {
    super(actual, selfType);
  }


  /**
   * Navigates to the property additionalProperties so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert additionalProperties()  {
    // check that actual ObjectMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"));
  }


  /**
   * Navigates to the property annotations so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert annotations()  {
    // check that actual ObjectMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getAnnotations()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "annotations"));
  }


  /**
   * Navigates to the property creationTimestamp so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert creationTimestamp()  {
    // check that actual ObjectMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getCreationTimestamp()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "creationTimestamp"));
  }


  /**
   * Verifies that the actual ObjectMeta's deletionGracePeriodSeconds is equal to the given one.
   * @param deletionGracePeriodSeconds the given deletionGracePeriodSeconds to compare the actual ObjectMeta's deletionGracePeriodSeconds to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMeta's deletionGracePeriodSeconds is not equal to the given one.
   */
  public S hasDeletionGracePeriodSeconds(Long deletionGracePeriodSeconds) {
    // check that actual ObjectMeta we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting deletionGracePeriodSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualDeletionGracePeriodSeconds = actual.getDeletionGracePeriodSeconds();
    if (!Objects.areEqual(actualDeletionGracePeriodSeconds, deletionGracePeriodSeconds)) {
      failWithMessage(assertjErrorMessage, actual, deletionGracePeriodSeconds, actualDeletionGracePeriodSeconds);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property deletionTimestamp so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert deletionTimestamp()  {
    // check that actual ObjectMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getDeletionTimestamp()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deletionTimestamp"));
  }


  /**
   * Navigates to the property finalizers so that assertions can be done on it
   */
  public NavigationListAssert<String, org.assertj.core.api.StringAssert> finalizers()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<String, org.assertj.core.api.StringAssert> assertFactory = new AssertFactory<String, org.assertj.core.api.StringAssert>() {
      public org.assertj.core.api.StringAssert createAssert(String t) {
        return (org.assertj.core.api.StringAssert) assertThat(t);
      }
    };
    NavigationListAssert<String, org.assertj.core.api.StringAssert> answer = new NavigationListAssert<String, org.assertj.core.api.StringAssert>(actual.getFinalizers(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "finalizers"));
    return answer;
  }


  /**
   * Navigates to the property generateName so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert generateName()  {
    // check that actual ObjectMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getGenerateName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "generateName"));
  }


  /**
   * Verifies that the actual ObjectMeta's generation is equal to the given one.
   * @param generation the given generation to compare the actual ObjectMeta's generation to.
   * @return this assertion object.
   * @throws AssertionError - if the actual ObjectMeta's generation is not equal to the given one.
   */
  public S hasGeneration(Long generation) {
    // check that actual ObjectMeta we want to make assertions on is not null.
    isNotNull();

    // overrides the default error message with a more explicit one
    String assertjErrorMessage = "\nExpecting generation of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
    
    // null safe check
    Long actualGeneration = actual.getGeneration();
    if (!Objects.areEqual(actualGeneration, generation)) {
      failWithMessage(assertjErrorMessage, actual, generation, actualGeneration);
    }

    // return the current assertion for method chaining
    return myself;
  }

  /**
   * Navigates to the property labels so that assertions can be done on it
   */
  public org.assertj.core.api.MapAssert labels()  {
    // check that actual ObjectMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.MapAssert) assertThat(actual.getLabels()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "labels"));
  }


  /**
   * Navigates to the property name so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert name()  {
    // check that actual ObjectMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"));
  }


  /**
   * Navigates to the property namespace so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert namespace()  {
    // check that actual ObjectMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespace"));
  }


  /**
   * Navigates to the property ownerReferences so that assertions can be done on it
   */
  public NavigationListAssert<OwnerReference, OwnerReferenceAssert> ownerReferences()  {
    isNotNull();

    // return the assertion for the property
    AssertFactory<OwnerReference, OwnerReferenceAssert> assertFactory = new AssertFactory<OwnerReference, OwnerReferenceAssert>() {
      public OwnerReferenceAssert createAssert(OwnerReference t) {
        return (OwnerReferenceAssert) assertThat(t);
      }
    };
    NavigationListAssert<OwnerReference, OwnerReferenceAssert> answer = new NavigationListAssert<OwnerReference, OwnerReferenceAssert>(actual.getOwnerReferences(), assertFactory);
    answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ownerReferences"));
    return answer;
  }


  /**
   * Navigates to the property resourceVersion so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert resourceVersion()  {
    // check that actual ObjectMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getResourceVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceVersion"));
  }


  /**
   * Navigates to the property selfLink so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert selfLink()  {
    // check that actual ObjectMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getSelfLink()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selfLink"));
  }


  /**
   * Navigates to the property uid so that assertions can be done on it
   */
  public org.assertj.core.api.StringAssert uid()  {
    // check that actual ObjectMeta we want to make assertions on is not null.
    isNotNull();

    // return the assertion for the property
    return (org.assertj.core.api.StringAssert) assertThat(actual.getUid()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "uid"));
  }


}
